/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.trait.beanMemoryStore;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.PredicateMethodClassification;
import one.edee.oss.proxycian.recipe.Advice;
import one.edee.oss.proxycian.trait.beanMemoryStore.BeanMemoryStore;
import org.apache.commons.lang3.StringUtils;

public class BeanMemoryStoreAdvice
implements Advice<BeanMemoryStore> {
    private static final long serialVersionUID = 4100044042153442374L;
    public static final BeanMemoryStoreAdvice ALL_METHOD_INSTANCE = new BeanMemoryStoreAdvice(method -> true);
    public static final BeanMemoryStoreAdvice ABSTRACT_METHOD_INSTANCE = new BeanMemoryStoreAdvice(method -> Modifier.isAbstract(method.getModifiers()));
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private final Predicate<Method> basePredicate;

    private BeanMemoryStoreAdvice(Predicate<Method> basePredicate) {
        this.basePredicate = basePredicate;
    }

    @Override
    public Class<BeanMemoryStore> getRequestedStateContract() {
        return BeanMemoryStore.class;
    }

    @Override
    public List<MethodClassification<?, BeanMemoryStore>> getMethodClassification() {
        return Arrays.asList(new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean setter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(SET) && Void.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 1, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(SET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            proxyState.putValueToMemoryStore((String)methodContext, (Serializable)args[0]);
            return null;
        }), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean short getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && Short.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse((short)0)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean byte getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && Byte.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse((byte)0)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean int getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && Integer.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(0)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean long getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && Long.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(0L)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean float getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && Float.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(Float.valueOf(0.0f))), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean double getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && Double.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(0.0)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean list getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && method.getParameterCount() == 0 && List.class.isAssignableFrom(method.getReturnType()), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(Collections.emptyList())), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean map getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && method.getParameterCount() == 0 && Map.class.isAssignableFrom(method.getReturnType()), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(Collections.emptyMap())), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean set getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && method.getParameterCount() == 0 && Set.class.isAssignableFrom(method.getReturnType()), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(Collections.emptySet())), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean collection getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && method.getParameterCount() == 0 && Collection.class.isAssignableFrom(method.getReturnType()), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(Collections.emptyList())), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean object getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(GET) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(GET.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> proxyState.getValueFromMemoryStore((String)methodContext)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("JavaBean boolean getter", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(IS) && method.getParameterCount() == 0, (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(IS.length())), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getValueFromMemoryStore((String)methodContext)).orElse(false)), new PredicateMethodClassification<Object, String, BeanMemoryStore>("add to list returning void", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(ADD) && method.getParameterCount() == 1 && method.getReturnType().equals(Void.TYPE), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(ADD.length())) + "s", (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            proxyState.addValueToCollectionInMemoryStore((String)methodContext, (Serializable)args[0]);
            return null;
        }), new PredicateMethodClassification<Object, String, BeanMemoryStore>("add to list returning boolean", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(ADD) && method.getParameterCount() == 1 && method.getReturnType().equals(Boolean.TYPE), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(ADD.length())) + "s", (proxy, method, args, methodContext, proxyState, invokeSuper) -> proxyState.addValueToCollectionInMemoryStore((String)methodContext, (Serializable)args[0])), new PredicateMethodClassification<Object, String, BeanMemoryStore>("remove from list returning boolean", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(REMOVE) && method.getParameterCount() == 1 && method.getReturnType().equals(Boolean.TYPE), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(REMOVE.length())) + "s", (proxy, method, args, methodContext, proxyState, invokeSuper) -> proxyState.removeValueFromCollectionInMemoryStore((String)methodContext, (Serializable)args[0])), new PredicateMethodClassification<Object, String, BeanMemoryStore>("remove from list returning void", (method, proxyState) -> this.basePredicate.test((Method)method) && method.getName().startsWith(REMOVE) && method.getParameterCount() == 1 && method.getReturnType().equals(Void.TYPE), (method, proxyState) -> StringUtils.uncapitalize((String)method.getName().substring(REMOVE.length())) + "s", (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            proxyState.removeValueFromCollectionInMemoryStore((String)methodContext, (Serializable)args[0]);
            return null;
        }));
    }
}

