/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import one.edee.oss.proxycian.CurriedMethodContextInvocationHandler;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.MethodInvocationHandler;

public class PredicateMethodClassification<PROXY, METHOD_CONTEXT, PROXY_STATE>
implements MethodClassification<PROXY, PROXY_STATE> {
    private final String description;
    private final BiPredicate<Method, PROXY_STATE> methodMatcher;
    private final BiFunction<Method, PROXY_STATE, METHOD_CONTEXT> methodContextFactory;
    private final MethodInvocationHandler<PROXY, METHOD_CONTEXT, PROXY_STATE> invocationHandler;

    @Override
    @Nullable
    public CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> createCurriedMethodContextInvocationHandler(@Nonnull Method classificationMethod, @Nonnull PROXY_STATE proxyState) {
        if (this.methodMatcher.test(classificationMethod, proxyState)) {
            METHOD_CONTEXT methodContext = this.methodContextFactory.apply(classificationMethod, proxyState);
            return new MethodClassificationCurriedMethodContextInvocationHandler<PROXY, METHOD_CONTEXT, PROXY_STATE>(this.description, methodContext, this.invocationHandler);
        }
        return null;
    }

    public String toString() {
        return this.description;
    }

    public PredicateMethodClassification(String description, BiPredicate<Method, PROXY_STATE> methodMatcher, BiFunction<Method, PROXY_STATE, METHOD_CONTEXT> methodContextFactory, MethodInvocationHandler<PROXY, METHOD_CONTEXT, PROXY_STATE> invocationHandler) {
        this.description = description;
        this.methodMatcher = methodMatcher;
        this.methodContextFactory = methodContextFactory;
        this.invocationHandler = invocationHandler;
    }

    protected static class MethodClassificationCurriedMethodContextInvocationHandler<THE_PROXY, THE_METHOD_CONTEXT, THE_PROXY_STATE>
    implements CurriedMethodContextInvocationHandler<THE_PROXY, THE_PROXY_STATE> {
        private final String description;
        private final THE_METHOD_CONTEXT methodContext;
        private final MethodInvocationHandler<THE_PROXY, THE_METHOD_CONTEXT, THE_PROXY_STATE> invocationHandler;

        public MethodClassificationCurriedMethodContextInvocationHandler(String description, THE_METHOD_CONTEXT methodContext, MethodInvocationHandler<THE_PROXY, THE_METHOD_CONTEXT, THE_PROXY_STATE> invocationHandler) {
            this.description = description;
            this.methodContext = methodContext;
            this.invocationHandler = invocationHandler;
        }

        @Override
        public Object invoke(THE_PROXY proxy, Method executionMethod, Object[] args, THE_PROXY_STATE proxyState, Callable<Object> invokeSuper) throws InvocationTargetException {
            return this.invocationHandler.invoke(proxy, executionMethod, args, this.methodContext, proxyState, invokeSuper);
        }

        public String toString() {
            return this.description + (this.methodContext == null ? "" : ": " + this.methodContext);
        }
    }
}

