/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis;

import java.io.PrintStream;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistModifier;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.BadBytecode;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.CodeAttribute;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.CodeIterator;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ConstPool;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.Descriptor;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.InstructionPrinter;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.MethodInfo;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis.Analyzer;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis.Frame;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis.Type;

public final class FramePrinter {
    private final PrintStream stream;

    public FramePrinter(PrintStream stream) {
        this.stream = stream;
    }

    public static void print(javassistCtClass clazz, PrintStream stream) {
        new FramePrinter(stream).print(clazz);
    }

    public void print(javassistCtClass clazz) {
        javassistCtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.print(methods[i]);
        }
    }

    private String getMethodString(javassistCtMethod method) {
        try {
            return javassistModifier.toString(method.getModifiers()) + " " + method.getReturnType().getName() + " " + method.getName() + Descriptor.toString(method.getSignature()) + ";";
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void print(javassistCtMethod method) {
        Frame[] frames;
        this.stream.println("\n" + this.getMethodString(method));
        MethodInfo info = method.getMethodInfo2();
        ConstPool pool = info.getConstPool();
        CodeAttribute code = info.getCodeAttribute();
        if (code == null) {
            return;
        }
        try {
            frames = new Analyzer().analyze(method.getDeclaringClass(), info);
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
        int spacing = String.valueOf(code.getCodeLength()).length();
        CodeIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            int pos;
            try {
                pos = iterator.next();
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            this.stream.println(pos + ": " + InstructionPrinter.instructionString(iterator, pos, pool));
            this.addSpacing(spacing + 3);
            Frame frame = frames[pos];
            if (frame == null) {
                this.stream.println("--DEAD CODE--");
                continue;
            }
            this.printStack(frame);
            this.addSpacing(spacing + 3);
            this.printLocals(frame);
        }
    }

    private void printStack(Frame frame) {
        this.stream.print("stack [");
        int top = frame.getTopIndex();
        for (int i = 0; i <= top; ++i) {
            if (i > 0) {
                this.stream.print(", ");
            }
            Type type = frame.getStack(i);
            this.stream.print(type);
        }
        this.stream.println("]");
    }

    private void printLocals(Frame frame) {
        this.stream.print("locals [");
        int length = frame.localsLength();
        for (int i = 0; i < length; ++i) {
            Type type;
            if (i > 0) {
                this.stream.print(", ");
            }
            this.stream.print((type = frame.getLocal(i)) == null ? "empty" : type.toString());
        }
        this.stream.println("]");
    }

    private void addSpacing(int count) {
        while (count-- > 0) {
            this.stream.print(' ');
        }
    }
}

