/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original.javassistscopedpool;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Map;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistLoaderClassPath;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistscopedpool.ScopedClassPoolRepository;
import one.edee.oss.proxycian.javassist.original.javassistscopedpool.SoftValueHashMap;

public class ScopedClassPool
extends javassistClassPool {
    protected ScopedClassPoolRepository repository;
    protected Reference<ClassLoader> classLoader;
    protected javassistLoaderClassPath classPath;
    protected Map<String, javassistCtClass> softcache = new SoftValueHashMap<String, javassistCtClass>();
    boolean isBootstrapCl = true;

    protected ScopedClassPool(ClassLoader cl, javassistClassPool src, ScopedClassPoolRepository repository) {
        this(cl, src, repository, false);
    }

    protected ScopedClassPool(ClassLoader cl, javassistClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        super(src);
        this.repository = repository;
        this.classLoader = new WeakReference<ClassLoader>(cl);
        if (cl != null) {
            this.classPath = new javassistLoaderClassPath(cl);
            this.insertClassPath(this.classPath);
        }
        this.childFirstLookup = true;
        if (!isTemp && cl == null) {
            this.isBootstrapCl = true;
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader cl = this.getClassLoader0();
        if (cl == null && !this.isBootstrapCl) {
            throw new IllegalStateException("ClassLoader has been garbage collected");
        }
        return cl;
    }

    protected ClassLoader getClassLoader0() {
        return this.classLoader.get();
    }

    public void close() {
        this.removeClassPath(this.classPath);
        this.classes.clear();
        this.softcache.clear();
    }

    public synchronized void flushClass(String classname) {
        this.classes.remove(classname);
        this.softcache.remove(classname);
    }

    public synchronized void soften(javassistCtClass clazz) {
        if (this.repository.isPrune()) {
            clazz.prune();
        }
        this.classes.remove(clazz.getName());
        this.softcache.put(clazz.getName(), clazz);
    }

    public boolean isUnloadedClassLoader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected javassistCtClass getCached(String classname) {
        javassistCtClass clazz = this.getCachedLocally(classname);
        if (clazz == null) {
            boolean isLocal = false;
            ClassLoader dcl = this.getClassLoader0();
            if (dcl != null) {
                int lastIndex = classname.lastIndexOf(36);
                String classResourceName = null;
                classResourceName = lastIndex < 0 ? classname.replaceAll("[\\.]", "/") + ".class" : classname.substring(0, lastIndex).replaceAll("[\\.]", "/") + classname.substring(lastIndex) + ".class";
                boolean bl = isLocal = dcl.getResource(classResourceName) != null;
            }
            if (!isLocal) {
                Map<ClassLoader, ScopedClassPool> registeredCLs;
                Map<ClassLoader, ScopedClassPool> map = registeredCLs = this.repository.getRegisteredCLs();
                synchronized (map) {
                    for (ScopedClassPool pool : registeredCLs.values()) {
                        if (pool.isUnloadedClassLoader()) {
                            this.repository.unregisterClassLoader(pool.getClassLoader());
                            continue;
                        }
                        clazz = pool.getCachedLocally(classname);
                        if (clazz == null) continue;
                        return clazz;
                    }
                }
            }
        }
        return clazz;
    }

    @Override
    protected void cacheCtClass(String classname, javassistCtClass c, boolean dynamic) {
        if (dynamic) {
            super.cacheCtClass(classname, c, dynamic);
        } else {
            if (this.repository.isPrune()) {
                c.prune();
            }
            this.softcache.put(classname, c);
        }
    }

    public void lockInCache(javassistCtClass c) {
        super.cacheCtClass(c.getName(), c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected javassistCtClass getCachedLocally(String classname) {
        javassistCtClass cached = (javassistCtClass)this.classes.get(classname);
        if (cached != null) {
            return cached;
        }
        Map<String, javassistCtClass> map = this.softcache;
        synchronized (map) {
            return this.softcache.get(classname);
        }
    }

    public synchronized javassistCtClass getLocally(String classname) throws javassistNotFoundException {
        this.softcache.remove(classname);
        javassistCtClass clazz = (javassistCtClass)this.classes.get(classname);
        if (clazz == null) {
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new javassistNotFoundException(classname);
            }
            super.cacheCtClass(classname, clazz, false);
        }
        return clazz;
    }

    @Override
    public Class<?> toClass(javassistCtClass ct, ClassLoader loader, ProtectionDomain domain) throws javassistCannotCompileException {
        this.lockInCache(ct);
        return super.toClass(ct, this.getClassLoader0(), domain);
    }

    static {
        javassistClassPool.doPruning = false;
        javassistClassPool.releaseUnmodifiedClassFile = false;
    }
}

