/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original.javassistexpr;

import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistCtBehavior;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtPrimitiveType;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.BadBytecode;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.Bytecode;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.CodeAttribute;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.CodeIterator;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ConstPool;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.Descriptor;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.MethodInfo;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.CompileError;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.Javac;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.JvstCodeGen;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.JvstTypeChecker;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.ProceedHandler;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.ast.ASTList;
import one.edee.oss.proxycian.javassist.original.javassistexpr.Expr;

public class NewArray
extends Expr {
    int opcode;

    protected NewArray(int pos, CodeIterator i, javassistCtClass declaring, MethodInfo m, int op) {
        super(pos, i, declaring, m);
        this.opcode = op;
    }

    @Override
    public javassistCtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    @Override
    public javassistCtClass[] mayThrow() {
        return super.mayThrow();
    }

    public javassistCtClass getComponentType() throws javassistNotFoundException {
        if (this.opcode == 188) {
            int atype = this.iterator.byteAt(this.currentPos + 1);
            return this.getPrimitiveType(atype);
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int index = this.iterator.u16bitAt(this.currentPos + 1);
            String desc = this.getConstPool().getClassInfo(index);
            int dim = Descriptor.arrayDimension(desc);
            desc = Descriptor.toArrayComponent(desc, dim);
            return Descriptor.toCtClass(desc, this.thisClass.getClassPool());
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    javassistCtClass getPrimitiveType(int atype) {
        switch (atype) {
            case 4: {
                return javassistCtClass.booleanType;
            }
            case 5: {
                return javassistCtClass.charType;
            }
            case 6: {
                return javassistCtClass.floatType;
            }
            case 7: {
                return javassistCtClass.doubleType;
            }
            case 8: {
                return javassistCtClass.byteType;
            }
            case 9: {
                return javassistCtClass.shortType;
            }
            case 10: {
                return javassistCtClass.intType;
            }
            case 11: {
                return javassistCtClass.longType;
            }
        }
        throw new RuntimeException("bad atype: " + atype);
    }

    public int getDimension() {
        if (this.opcode == 188) {
            return 1;
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int index = this.iterator.u16bitAt(this.currentPos + 1);
            String desc = this.getConstPool().getClassInfo(index);
            return Descriptor.arrayDimension(desc) + (this.opcode == 189 ? 1 : 0);
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    public int getCreatedDimensions() {
        if (this.opcode == 197) {
            return this.iterator.byteAt(this.currentPos + 3);
        }
        return 1;
    }

    @Override
    public void replace(String statement) throws javassistCannotCompileException {
        try {
            this.replace2(statement);
        }
        catch (CompileError e) {
            throw new javassistCannotCompileException(e);
        }
        catch (javassistNotFoundException e) {
            throw new javassistCannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new javassistCannotCompileException("broken method");
        }
    }

    private void replace2(String statement) throws CompileError, javassistNotFoundException, BadBytecode, javassistCannotCompileException {
        int codeLength;
        String desc;
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int pos = this.currentPos;
        int index = 0;
        int dim = 1;
        if (this.opcode == 188) {
            index = this.iterator.byteAt(this.currentPos + 1);
            javassistCtPrimitiveType cpt = (javassistCtPrimitiveType)this.getPrimitiveType(index);
            desc = "[" + cpt.getDescriptor();
            codeLength = 2;
        } else if (this.opcode == 189) {
            index = this.iterator.u16bitAt(pos + 1);
            desc = constPool.getClassInfo(index);
            desc = desc.startsWith("[") ? "[" + desc : "[L" + desc + ";";
            codeLength = 3;
        } else if (this.opcode == 197) {
            index = this.iterator.u16bitAt(this.currentPos + 1);
            desc = constPool.getClassInfo(index);
            dim = this.iterator.byteAt(this.currentPos + 3);
            codeLength = 4;
        } else {
            throw new RuntimeException("bad opcode: " + this.opcode);
        }
        javassistCtClass retType = Descriptor.toCtClass(desc, this.thisClass.getClassPool());
        Javac jc = new Javac(this.thisClass);
        CodeAttribute ca = this.iterator.get();
        javassistCtClass[] params = new javassistCtClass[dim];
        for (int i = 0; i < dim; ++i) {
            params[i] = javassistCtClass.intType;
        }
        int paramVar = ca.getMaxLocals();
        jc.recordParams("java.lang.Object", params, true, paramVar, this.withinStatic());
        NewArray.checkResultValue(retType, statement);
        int retVar = jc.recordReturnType(retType, true);
        jc.recordProceed(new ProceedForArray(retType, this.opcode, index, dim));
        Bytecode bytecode = jc.getBytecode();
        NewArray.storeStack(params, true, paramVar, bytecode);
        jc.recordLocalVariables(ca, pos);
        bytecode.addOpcode(1);
        bytecode.addAstore(retVar);
        jc.compileStmnt(statement);
        bytecode.addAload(retVar);
        this.replace0(pos, bytecode, codeLength);
    }

    static class ProceedForArray
    implements ProceedHandler {
        javassistCtClass arrayType;
        int opcode;
        int index;
        int dimension;

        ProceedForArray(javassistCtClass type, int op, int i, int dim) {
            this.arrayType = type;
            this.opcode = op;
            this.index = i;
            this.dimension = dim;
        }

        @Override
        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args) throws CompileError {
            int num = gen.getMethodArgsLength(args);
            if (num != this.dimension) {
                throw new CompileError("$proceed() with a wrong number of parameters");
            }
            gen.atMethodArgs(args, new int[num], new int[num], new String[num]);
            bytecode.addOpcode(this.opcode);
            if (this.opcode == 189) {
                bytecode.addIndex(this.index);
            } else if (this.opcode == 188) {
                bytecode.add(this.index);
            } else {
                bytecode.addIndex(this.index);
                bytecode.add(this.dimension);
                bytecode.growStack(1 - this.dimension);
            }
            gen.setType(this.arrayType);
        }

        @Override
        public void setReturnType(JvstTypeChecker c, ASTList args) throws CompileError {
            c.setType(this.arrayType);
        }
    }
}

