/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original.javassisttools.rmi;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtConstructor;
import one.edee.oss.proxycian.javassist.original.javassistCtField;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistCtNewConstructor;
import one.edee.oss.proxycian.javassist.original.javassistCtNewMethod;
import one.edee.oss.proxycian.javassist.original.javassistModifier;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistTranslator;

public class StubGenerator
implements javassistTranslator {
    private static final String fieldImporter = "importer";
    private static final String fieldObjectId = "objectId";
    private static final String accessorObjectId = "_getObjectId";
    private static final String sampleClass = "one.edee.oss.proxycian.javassist.original.javassisttools.rmi.Sample";
    private javassistClassPool classPool;
    private Map<String, javassistCtClass> proxyClasses = new Hashtable<String, javassistCtClass>();
    private javassistCtMethod forwardMethod;
    private javassistCtMethod forwardStaticMethod;
    private javassistCtClass[] proxyConstructorParamTypes;
    private javassistCtClass[] interfacesForProxy;
    private javassistCtClass[] exceptionForProxy;

    @Override
    public void start(javassistClassPool pool) throws javassistNotFoundException {
        this.classPool = pool;
        javassistCtClass c = pool.get(sampleClass);
        this.forwardMethod = c.getDeclaredMethod("forward");
        this.forwardStaticMethod = c.getDeclaredMethod("forwardStatic");
        this.proxyConstructorParamTypes = pool.get(new String[]{"one.edee.oss.proxycian.javassist.original.javassisttools.rmi.ObjectImporter", "int"});
        this.interfacesForProxy = pool.get(new String[]{"java.io.Serializable", "one.edee.oss.proxycian.javassist.original.javassisttools.rmi.Proxy"});
        this.exceptionForProxy = new javassistCtClass[]{pool.get("one.edee.oss.proxycian.javassist.original.javassisttools.rmi.RemoteException")};
    }

    @Override
    public void onLoad(javassistClassPool pool, String classname) {
    }

    public boolean isProxyClass(String name) {
        return this.proxyClasses.get(name) != null;
    }

    public synchronized boolean makeProxyClass(Class<?> clazz) throws javassistCannotCompileException, javassistNotFoundException {
        String classname = clazz.getName();
        if (this.proxyClasses.get(classname) != null) {
            return false;
        }
        javassistCtClass ctclazz = this.produceProxyClass(this.classPool.get(classname), clazz);
        this.proxyClasses.put(classname, ctclazz);
        this.modifySuperclass(ctclazz);
        return true;
    }

    private javassistCtClass produceProxyClass(javassistCtClass orgclass, Class<?> orgRtClass) throws javassistCannotCompileException, javassistNotFoundException {
        int modify = orgclass.getModifiers();
        if (javassistModifier.isAbstract(modify) || javassistModifier.isNative(modify) || !javassistModifier.isPublic(modify)) {
            throw new javassistCannotCompileException(orgclass.getName() + " must be public, non-native, and non-abstract.");
        }
        javassistCtClass proxy = this.classPool.makeClass(orgclass.getName(), orgclass.getSuperclass());
        proxy.setInterfaces(this.interfacesForProxy);
        javassistCtField f = new javassistCtField(this.classPool.get("one.edee.oss.proxycian.javassist.original.javassisttools.rmi.ObjectImporter"), fieldImporter, proxy);
        f.setModifiers(2);
        proxy.addField(f, javassistCtField.Initializer.byParameter(0));
        f = new javassistCtField(javassistCtClass.intType, fieldObjectId, proxy);
        f.setModifiers(2);
        proxy.addField(f, javassistCtField.Initializer.byParameter(1));
        proxy.addMethod(javassistCtNewMethod.getter(accessorObjectId, f));
        proxy.addConstructor(javassistCtNewConstructor.defaultConstructor(proxy));
        javassistCtConstructor cons = javassistCtNewConstructor.skeleton(this.proxyConstructorParamTypes, null, proxy);
        proxy.addConstructor(cons);
        try {
            this.addMethods(proxy, orgRtClass.getMethods());
            return proxy;
        }
        catch (SecurityException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    private javassistCtClass toCtClass(Class<?> rtclass) throws javassistNotFoundException {
        String name;
        if (!rtclass.isArray()) {
            name = rtclass.getName();
        } else {
            StringBuilder sbuf = new StringBuilder();
            do {
                sbuf.append("[]");
            } while ((rtclass = rtclass.getComponentType()).isArray());
            sbuf.insert(0, rtclass.getName());
            name = sbuf.toString();
        }
        return this.classPool.get(name);
    }

    private javassistCtClass[] toCtClass(Class<?>[] rtclasses) throws javassistNotFoundException {
        int n = rtclasses.length;
        javassistCtClass[] ctclasses = new javassistCtClass[n];
        for (int i = 0; i < n; ++i) {
            ctclasses[i] = this.toCtClass(rtclasses[i]);
        }
        return ctclasses;
    }

    private void addMethods(javassistCtClass proxy, Method[] ms) throws javassistCannotCompileException, javassistNotFoundException {
        for (int i = 0; i < ms.length; ++i) {
            Method m = ms[i];
            int mod = m.getModifiers();
            if (m.getDeclaringClass() == Object.class || javassistModifier.isFinal(mod)) continue;
            if (javassistModifier.isPublic(mod)) {
                javassistCtMethod body = javassistModifier.isStatic(mod) ? this.forwardStaticMethod : this.forwardMethod;
                javassistCtMethod wmethod = javassistCtNewMethod.wrapped(this.toCtClass(m.getReturnType()), m.getName(), this.toCtClass(m.getParameterTypes()), this.exceptionForProxy, body, javassistCtMethod.ConstParameter.integer(i), proxy);
                wmethod.setModifiers(mod);
                proxy.addMethod(wmethod);
                continue;
            }
            if (javassistModifier.isProtected(mod) || javassistModifier.isPrivate(mod)) continue;
            throw new javassistCannotCompileException("the methods must be public, protected, or private.");
        }
    }

    private void modifySuperclass(javassistCtClass orgclass) throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtClass superclazz;
        while ((superclazz = orgclass.getSuperclass()) != null) {
            try {
                superclazz.getDeclaredConstructor(null);
                break;
            }
            catch (javassistNotFoundException javassistNotFoundException2) {
                superclazz.addConstructor(javassistCtNewConstructor.defaultConstructor(superclazz));
                orgclass = superclazz;
            }
        }
    }
}

