/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.recipe;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.OnInstantiationCallback;
import one.edee.oss.proxycian.PredicateMethodClassification;
import one.edee.oss.proxycian.recipe.Advice;
import one.edee.oss.proxycian.recipe.IntroductionAdvice;
import one.edee.oss.proxycian.recipe.SelfVerifiableState;
import one.edee.oss.proxycian.utils.ArrayUtils;

public class ProxyRecipe
implements Serializable {
    private static final long serialVersionUID = -4034411993592819942L;
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private final OnInstantiationCallback instantiationCallback;
    private final Class<?>[] interfaces;
    private final Advice<?>[] advices;
    private transient MethodClassification<?, ?>[] methodClassifications;
    private final Set<Class<?>> verifiedStateClasses = ConcurrentHashMap.newKeySet();

    private static Class<?>[] combine(Class<?> aClass, Class<?>[] interfaces) {
        Class[] combinedClasses = new Class[interfaces.length + 1];
        combinedClasses[0] = aClass;
        System.arraycopy(interfaces, 0, combinedClasses, 1, interfaces.length);
        return combinedClasses;
    }

    public ProxyRecipe(Advice<?> ... advices) {
        this(EMPTY_CLASSES, advices);
    }

    public ProxyRecipe(Advice<?>[] advices, OnInstantiationCallback instantiationCallback) {
        this(EMPTY_CLASSES, advices, instantiationCallback);
    }

    public ProxyRecipe(Class<?> abstractClass, Class<?>[] interfaces, Advice<?>[] advices) {
        this(ProxyRecipe.combine(abstractClass, interfaces), advices);
    }

    public ProxyRecipe(Class<?> abstractClass, Class<?>[] interfaces, Advice<?>[] advices, OnInstantiationCallback instantiationCallback) {
        this(ProxyRecipe.combine(abstractClass, interfaces), advices, instantiationCallback);
    }

    public ProxyRecipe(Class<?>[] interfaces, Advice<?>[] advices) {
        this(interfaces, advices, null);
    }

    public ProxyRecipe(Class<?>[] interfaces, Advice<?>[] advices, OnInstantiationCallback instantiationCallback) {
        this.instantiationCallback = instantiationCallback;
        this.advices = advices;
        LinkedList additionalInterfaces = null;
        for (Advice<?> advice : advices) {
            if (!(advice instanceof IntroductionAdvice)) continue;
            if (additionalInterfaces == null) {
                additionalInterfaces = new LinkedList();
            }
            List<Class<?>> interfacesToImplement = ((IntroductionAdvice)advice).getInterfacesToImplement();
            for (Class<?> interfaceToImplement : interfacesToImplement) {
                if (additionalInterfaces.contains(interfaceToImplement)) continue;
                additionalInterfaces.add(interfaceToImplement);
            }
        }
        this.interfaces = additionalInterfaces == null ? interfaces : ArrayUtils.mergeArrays(interfaces, additionalInterfaces.toArray(EMPTY_CLASSES));
    }

    public void verifyProxyState(Object proxyState) {
        if (!this.verifiedStateClasses.contains(proxyState.getClass())) {
            for (Advice<?> advice : this.advices) {
                Optional.ofNullable(advice.getRequestedStateContract()).ifPresent(requestedInterface -> {
                    BiPredicate<Object, Class> compatibilityChecker;
                    BiPredicate<Object, Class> biPredicate = compatibilityChecker = advice instanceof SelfVerifiableState ? (pState, reqIface) -> ((SelfVerifiableState)((Object)advice)).verifyCompatibility(proxyState, (Class<?>)requestedInterface) : (pState, reqIface) -> requestedInterface.isInstance(pState);
                    if (!compatibilityChecker.test(proxyState, (Class)requestedInterface)) {
                        throw new IllegalArgumentException("Proxy state " + proxyState.getClass() + " doesn't implement " + requestedInterface + " requested by " + advice.getClass() + "!");
                    }
                });
            }
            this.verifiedStateClasses.add(proxyState.getClass());
        }
    }

    public Class<?>[] getInterfacesWith(Class<?> ... baseClasses) {
        if (this.interfaces[0].isInterface()) {
            return ArrayUtils.mergeArrays(baseClasses, this.interfaces);
        }
        Class[] result = new Class[baseClasses.length + this.interfaces.length];
        result[0] = this.interfaces[0];
        System.arraycopy(baseClasses, 0, result, 1, baseClasses.length);
        System.arraycopy(this.interfaces, 1, result, 1 + baseClasses.length, this.interfaces.length - 1);
        return result;
    }

    public MethodClassification<?, ?>[] getMethodClassificationsWith(PredicateMethodClassification<?, ?, ?> ... baseMethodClassifications) {
        MethodClassification<?, ?>[] methodClassifications = this.getMethodClassifications();
        MethodClassification[] combinedResult = new MethodClassification[methodClassifications.length + baseMethodClassifications.length];
        System.arraycopy(methodClassifications, 0, combinedResult, 0, methodClassifications.length);
        System.arraycopy(baseMethodClassifications, 0, combinedResult, methodClassifications.length, baseMethodClassifications.length);
        return combinedResult;
    }

    private MethodClassification<?, ?>[] getMethodClassifications() {
        if (this.methodClassifications == null) {
            this.methodClassifications = (MethodClassification[])Arrays.stream(this.advices).flatMap(it -> it.getMethodClassification().stream()).toArray(MethodClassification[]::new);
        }
        return this.methodClassifications;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyRecipe)) {
            return false;
        }
        ProxyRecipe other = (ProxyRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OnInstantiationCallback this$instantiationCallback = this.getInstantiationCallback();
        OnInstantiationCallback other$instantiationCallback = other.getInstantiationCallback();
        if (this$instantiationCallback == null ? other$instantiationCallback != null : !this$instantiationCallback.equals(other$instantiationCallback)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInterfaces(), other.getInterfaces())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAdvices(), other.getAdvices())) {
            return false;
        }
        Set<Class<?>> this$verifiedStateClasses = this.verifiedStateClasses;
        Set<Class<?>> other$verifiedStateClasses = other.verifiedStateClasses;
        return !(this$verifiedStateClasses == null ? other$verifiedStateClasses != null : !((Object)this$verifiedStateClasses).equals(other$verifiedStateClasses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OnInstantiationCallback $instantiationCallback = this.getInstantiationCallback();
        result = result * 59 + ($instantiationCallback == null ? 43 : $instantiationCallback.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInterfaces());
        result = result * 59 + Arrays.deepHashCode(this.getAdvices());
        Set<Class<?>> $verifiedStateClasses = this.verifiedStateClasses;
        result = result * 59 + ($verifiedStateClasses == null ? 43 : ((Object)$verifiedStateClasses).hashCode());
        return result;
    }

    public String toString() {
        return "ProxyRecipe(instantiationCallback=" + this.getInstantiationCallback() + ", interfaces=" + Arrays.deepToString(this.getInterfaces()) + ", advices=" + Arrays.deepToString(this.getAdvices()) + ", methodClassifications=" + Arrays.deepToString(this.getMethodClassifications()) + ", verifiedStateClasses=" + this.verifiedStateClasses + ")";
    }

    public OnInstantiationCallback getInstantiationCallback() {
        return this.instantiationCallback;
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public Advice<?>[] getAdvices() {
        return this.advices;
    }
}

