/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.trait.delegate;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import one.edee.oss.proxycian.CacheKeyProvider;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.PredicateMethodClassification;
import one.edee.oss.proxycian.recipe.IntroductionAdvice;
import one.edee.oss.proxycian.recipe.SelfVerifiableState;
import one.edee.oss.proxycian.util.ReflectionUtils;

public class DelegateCallsAdvice<T>
implements IntroductionAdvice<T>,
SelfVerifiableState {
    private static final long serialVersionUID = 8341706887626479107L;
    private final Class<T> iface;
    private final Function<Object, Object> delegateAccessor;
    private final boolean considerVerified;

    private DelegateCallsAdvice(Class<T> iface) {
        this.iface = iface;
        this.delegateAccessor = null;
        this.considerVerified = false;
    }

    public DelegateCallsAdvice(Class<T> iface, Function<Object, Object> delegateAccessor) {
        this.iface = iface;
        this.delegateAccessor = delegateAccessor;
        this.considerVerified = false;
    }

    private DelegateCallsAdvice(Class<T> iface, boolean considerVerified) {
        this.iface = iface;
        this.delegateAccessor = null;
        this.considerVerified = considerVerified;
    }

    public DelegateCallsAdvice(Class<T> iface, Function<Object, Object> delegateAccessor, boolean considerVerified) {
        this.iface = iface;
        this.delegateAccessor = delegateAccessor;
        this.considerVerified = considerVerified;
    }

    public static <T> DelegateCallsAdvice<T> getInstance(Class<T> iface) {
        return new DelegateCallsAdvice<T>(iface);
    }

    public static <T> DelegateCallsAdvice<T> getInstance(Class<T> iface, Function<Object, Object> delegateAccessor) {
        return new DelegateCallsAdvice<T>(iface, delegateAccessor);
    }

    public static <T> DelegateCallsAdvice<T> getInstanceValidFor(Class<T> iface) {
        return new DelegateCallsAdvice<T>(iface, true);
    }

    public static <T> DelegateCallsAdvice<T> getInstanceValidFor(Class<T> iface, Function<Object, Object> delegateAccessor) {
        return new DelegateCallsAdvice<T>(iface, delegateAccessor, true);
    }

    @Override
    public boolean verifyCompatibility(@Nonnull Object proxyState, @Nonnull Class<?> withRequestedInterface) {
        return this.considerVerified || withRequestedInterface.isInstance(this.delegateAccessor == null ? proxyState : this.delegateAccessor.apply(proxyState));
    }

    @Override
    public Class<T> getRequestedStateContract() {
        return this.iface;
    }

    @Override
    public List<MethodClassification<?, T>> getMethodClassification() {
        return Collections.singletonList(new DelegatingMethodClassification(this.iface, this.delegateAccessor));
    }

    @Override
    public List<Class<?>> getInterfacesToImplement() {
        if (this.iface.isInterface()) {
            return Collections.singletonList(this.iface);
        }
        return Arrays.asList(this.iface.getInterfaces());
    }

    public static class DelegatingMethodClassification<U, S>
    extends PredicateMethodClassification<U, Method, S>
    implements CacheKeyProvider {
        private final Function<Object, Object> delegateAccessor;

        public DelegatingMethodClassification(Class<S> iface, Function<Object, Object> delegateAccessor) {
            super("Delegate to " + (delegateAccessor == null ? "state" : "state property"), (method, proxyState) -> ReflectionUtils.isMatchingMethodPresentOn(method, iface) && ReflectionUtils.isMatchingMethodPresentOn(method, iface), (method, proxyState) -> {
                try {
                    return iface.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Method " + method.toGenericString() + " is unexpectedly not defined on " + iface + "!");
                }
            }, (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
                Object targetState = delegateAccessor == null ? proxyState : delegateAccessor.apply(proxyState);
                try {
                    return methodContext.invoke(targetState, args);
                }
                catch (IllegalAccessException e) {
                    throw new InvocationTargetException(e);
                }
            });
            this.delegateAccessor = delegateAccessor;
        }

        @Override
        public Object getCacheKey() {
            return this.delegateAccessor;
        }
    }
}

