/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original;

import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtField;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistModifier;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.BadBytecode;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.CodeAttribute;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.CodeIterator;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ConstPool;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.MethodInfo;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformAccessArrayField;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformAfter;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformBefore;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformCall;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformCallToStatic;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformFieldAccess;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformNew;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformNewClass;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformReadField;
import one.edee.oss.proxycian.javassist.original.javassistconvert.TransformWriteField;
import one.edee.oss.proxycian.javassist.original.javassistconvert.Transformer;

public class javassistCodeConverter {
    protected Transformer transformers = null;

    public void replaceNew(javassistCtClass newClass, javassistCtClass calledClass, String calledMethod) {
        this.transformers = new TransformNew(this.transformers, newClass.getName(), calledClass.getName(), calledMethod);
    }

    public void replaceNew(javassistCtClass oldClass, javassistCtClass newClass) {
        this.transformers = new TransformNewClass(this.transformers, oldClass.getName(), newClass.getName());
    }

    public void redirectFieldAccess(javassistCtField field, javassistCtClass newClass, String newFieldname) {
        this.transformers = new TransformFieldAccess(this.transformers, field, newClass.getName(), newFieldname);
    }

    public void replaceFieldRead(javassistCtField field, javassistCtClass calledClass, String calledMethod) {
        this.transformers = new TransformReadField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceFieldWrite(javassistCtField field, javassistCtClass calledClass, String calledMethod) {
        this.transformers = new TransformWriteField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceArrayAccess(javassistCtClass calledClass, ArrayAccessReplacementMethodNames names) throws javassistNotFoundException {
        this.transformers = new TransformAccessArrayField(this.transformers, calledClass.getName(), names);
    }

    public void redirectMethodCall(javassistCtMethod origMethod, javassistCtMethod substMethod) throws javassistCannotCompileException {
        String d2;
        String d1 = origMethod.getMethodInfo2().getDescriptor();
        if (!d1.equals(d2 = substMethod.getMethodInfo2().getDescriptor())) {
            throw new javassistCannotCompileException("signature mismatch: " + substMethod.getLongName());
        }
        int mod1 = origMethod.getModifiers();
        int mod2 = substMethod.getModifiers();
        if (javassistModifier.isStatic(mod1) != javassistModifier.isStatic(mod2) || javassistModifier.isPrivate(mod1) && !javassistModifier.isPrivate(mod2) || origMethod.getDeclaringClass().isInterface() != substMethod.getDeclaringClass().isInterface()) {
            throw new javassistCannotCompileException("invoke-type mismatch " + substMethod.getLongName());
        }
        this.transformers = new TransformCall(this.transformers, origMethod, substMethod);
    }

    public void redirectMethodCall(String oldMethodName, javassistCtMethod newMethod) throws javassistCannotCompileException {
        this.transformers = new TransformCall(this.transformers, oldMethodName, newMethod);
    }

    public void redirectMethodCallToStatic(javassistCtMethod origMethod, javassistCtMethod staticMethod) {
        this.transformers = new TransformCallToStatic(this.transformers, origMethod, staticMethod);
    }

    public void insertBeforeMethod(javassistCtMethod origMethod, javassistCtMethod beforeMethod) throws javassistCannotCompileException {
        try {
            this.transformers = new TransformBefore(this.transformers, origMethod, beforeMethod);
        }
        catch (javassistNotFoundException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    public void insertAfterMethod(javassistCtMethod origMethod, javassistCtMethod afterMethod) throws javassistCannotCompileException {
        try {
            this.transformers = new TransformAfter(this.transformers, origMethod, afterMethod);
        }
        catch (javassistNotFoundException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    protected void doit(javassistCtClass clazz, MethodInfo minfo, ConstPool cp) throws javassistCannotCompileException {
        Transformer t;
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null || this.transformers == null) {
            return;
        }
        for (t = this.transformers; t != null; t = t.getNext()) {
            t.initialize(cp, clazz, minfo);
        }
        CodeIterator iterator = codeAttr.iterator();
        while (iterator.hasNext()) {
            try {
                int pos = iterator.next();
                for (t = this.transformers; t != null; t = t.getNext()) {
                    pos = t.transform(clazz, pos, iterator, cp);
                }
            }
            catch (BadBytecode e) {
                throw new javassistCannotCompileException(e);
            }
        }
        int locals = 0;
        int stack = 0;
        for (t = this.transformers; t != null; t = t.getNext()) {
            int s = t.extraLocals();
            if (s > locals) {
                locals = s;
            }
            if ((s = t.extraStack()) <= stack) continue;
            stack = s;
        }
        for (t = this.transformers; t != null; t = t.getNext()) {
            t.clean();
        }
        if (locals > 0) {
            codeAttr.setMaxLocals(codeAttr.getMaxLocals() + locals);
        }
        if (stack > 0) {
            codeAttr.setMaxStack(codeAttr.getMaxStack() + stack);
        }
        try {
            minfo.rebuildStackMapIf6(clazz.getClassPool(), clazz.getClassFile2());
        }
        catch (BadBytecode b) {
            throw new javassistCannotCompileException(b.getMessage(), b);
        }
    }

    public static interface ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead();

        public String byteOrBooleanWrite();

        public String charRead();

        public String charWrite();

        public String doubleRead();

        public String doubleWrite();

        public String floatRead();

        public String floatWrite();

        public String intRead();

        public String intWrite();

        public String longRead();

        public String longWrite();

        public String objectRead();

        public String objectWrite();

        public String shortRead();

        public String shortWrite();
    }

    public static class DefaultArrayAccessReplacementMethodNames
    implements ArrayAccessReplacementMethodNames {
        @Override
        public String byteOrBooleanRead() {
            return "arrayReadByteOrBoolean";
        }

        @Override
        public String byteOrBooleanWrite() {
            return "arrayWriteByteOrBoolean";
        }

        @Override
        public String charRead() {
            return "arrayReadChar";
        }

        @Override
        public String charWrite() {
            return "arrayWriteChar";
        }

        @Override
        public String doubleRead() {
            return "arrayReadDouble";
        }

        @Override
        public String doubleWrite() {
            return "arrayWriteDouble";
        }

        @Override
        public String floatRead() {
            return "arrayReadFloat";
        }

        @Override
        public String floatWrite() {
            return "arrayWriteFloat";
        }

        @Override
        public String intRead() {
            return "arrayReadInt";
        }

        @Override
        public String intWrite() {
            return "arrayWriteInt";
        }

        @Override
        public String longRead() {
            return "arrayReadLong";
        }

        @Override
        public String longWrite() {
            return "arrayWriteLong";
        }

        @Override
        public String objectRead() {
            return "arrayReadObject";
        }

        @Override
        public String objectWrite() {
            return "arrayWriteObject";
        }

        @Override
        public String shortRead() {
            return "arrayReadShort";
        }

        @Override
        public String shortWrite() {
            return "arrayWriteShort";
        }
    }
}

