/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.trait.localDataStore;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.PredicateMethodClassification;
import one.edee.oss.proxycian.recipe.IntroductionAdvice;
import one.edee.oss.proxycian.trait.localDataStore.LocalDataStore;
import one.edee.oss.proxycian.trait.localDataStore.LocalDataStoreProvider;
import one.edee.oss.proxycian.util.ReflectionUtils;
import one.edee.oss.proxycian.utils.GenericsUtils;

public class LocalDataStoreAdvice
implements IntroductionAdvice<LocalDataStoreProvider> {
    private static final long serialVersionUID = 8044624463306298114L;
    public static LocalDataStoreAdvice INSTANCE = new LocalDataStoreAdvice();

    private LocalDataStoreAdvice() {
    }

    @Override
    public List<Class<?>> getInterfacesToImplement() {
        return Collections.singletonList(LocalDataStore.class);
    }

    @Override
    public Class<LocalDataStoreProvider> getRequestedStateContract() {
        return LocalDataStoreProvider.class;
    }

    @Override
    public List<MethodClassification<?, LocalDataStoreProvider>> getMethodClassification() {
        return Arrays.asList(new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.getLocalData(String)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "getLocalData", String.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getLocalDataStoreIfPresent()).map(it -> (Serializable)it.get((String)args[0])).orElse(null)), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.getLocalData(Class)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "getLocalData", Class.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getLocalDataStoreIfPresent()).map(it -> (Serializable)it.get(this.computeName((Class)args[0]))).orElse(null)), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.setLocalData(Serializable)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "setLocalData", Serializable.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            Serializable value = (Serializable)args[0];
            if (value != null) {
                String valueName = this.computeName(value.getClass());
                proxyState.getOrCreateLocalDataStore().put(valueName, value);
            }
            return null;
        }), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.setLocalData(String,Serializable)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "setLocalData", String.class, Serializable.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            String valueName = (String)args[0];
            Serializable value = (Serializable)args[1];
            if (value != null) {
                proxyState.getOrCreateLocalDataStore().put(valueName, value);
            }
            return null;
        }), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.computeLocalDataIfAbsent(Supplier)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "computeLocalDataIfAbsent", Supplier.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            try {
                Supplier valueSupplier = (Supplier)args[0];
                Method getter = valueSupplier.getClass().getMethod("get", new Class[0]);
                Class<?> methodReturnType = GenericsUtils.getMethodReturnType(valueSupplier.getClass(), getter);
                String valueName = this.computeName(methodReturnType);
                Map<String, Serializable> memoryStore = proxyState.getOrCreateLocalDataStore();
                Serializable value = memoryStore.get(valueName);
                if (value == null) {
                    Serializable newValue = (Serializable)valueSupplier.get();
                    memoryStore.put(valueName, newValue);
                    value = newValue;
                } else if (!methodReturnType.equals(value.getClass())) {
                    throw new IllegalArgumentException("Guessed type " + methodReturnType.getName() + " doesn't match cached type " + value.getClass().getName() + ". If you're calling with lambda function proper type cannot be guessed from generics. Use computeLocalDataIfAbsent(String, Supplier) method instead!");
                }
                return value;
            }
            catch (NoSuchMethodException e) {
                throw new InvocationTargetException(e);
            }
        }), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.computeLocalDataIfAbsent(String, Supplier)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "computeLocalDataIfAbsent", String.class, Supplier.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            String valueName = (String)args[0];
            Supplier valueSupplier = (Supplier)args[1];
            Map<String, Serializable> memoryStore = proxyState.getOrCreateLocalDataStore();
            Serializable value = memoryStore.get(valueName);
            if (value == null) {
                Serializable newValue = (Serializable)valueSupplier.get();
                memoryStore.put(valueName, newValue);
                value = newValue;
            }
            return value;
        }), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.removeLocalData(String)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "removeLocalData", String.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getLocalDataStoreIfPresent()).map(it -> (Serializable)it.remove((String)args[0])).orElse(null)), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.removeLocalData(Class)", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "removeLocalData", Class.class), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getLocalDataStoreIfPresent()).map(it -> (Serializable)it.remove(this.computeName((Class)args[0]))).orElse(null)), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.getLocalDataNames()", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "getLocalDataNames", new Class[0]), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> Optional.ofNullable(proxyState.getLocalDataStoreIfPresent()).map(Map::keySet).orElse(null)), new PredicateMethodClassification<Object, Void, LocalDataStoreProvider>("LocalDataStore.clearLocalData()", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, LocalDataStore.class, "clearLocalData", new Class[0]), MethodClassification.noContext(), (proxy, method, args, methodContext, proxyState, invokeSuper) -> {
            Optional.ofNullable(proxyState.getLocalDataStoreIfPresent()).ifPresent(Map::clear);
            return null;
        }));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    private String computeName(Class<?> aClass) {
        return aClass.getSimpleName();
    }
}

