/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original;

import java.io.DataOutputStream;
import java.io.IOException;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtClassType;
import one.edee.oss.proxycian.javassist.original.javassistCtConstructor;
import one.edee.oss.proxycian.javassist.original.javassistCtNewConstructor;
import one.edee.oss.proxycian.javassist.original.javassistModifier;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ClassFile;

class javassistCtNewClass
extends javassistCtClassType {
    protected boolean hasConstructor;

    javassistCtNewClass(String name, javassistClassPool cp, boolean isInterface, javassistCtClass superclass) {
        super(name, cp);
        this.wasChanged = true;
        String superName = isInterface || superclass == null ? null : superclass.getName();
        this.classfile = new ClassFile(isInterface, name, superName);
        if (isInterface && superclass != null) {
            this.classfile.setInterfaces(new String[]{superclass.getName()});
        }
        this.setModifiers(javassistModifier.setPublic(this.getModifiers()));
        this.hasConstructor = isInterface;
    }

    @Override
    protected void extendToString(StringBuilder buffer) {
        if (this.hasConstructor) {
            buffer.append("hasConstructor ");
        }
        super.extendToString(buffer);
    }

    @Override
    public void addConstructor(javassistCtConstructor c) throws javassistCannotCompileException {
        this.hasConstructor = true;
        super.addConstructor(c);
    }

    @Override
    public void toBytecode(DataOutputStream out) throws javassistCannotCompileException, IOException {
        if (!this.hasConstructor) {
            try {
                this.inheritAllConstructors();
                this.hasConstructor = true;
            }
            catch (javassistNotFoundException e) {
                throw new javassistCannotCompileException(e);
            }
        }
        super.toBytecode(out);
    }

    public void inheritAllConstructors() throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtClass superclazz = this.getSuperclass();
        javassistCtConstructor[] cs = superclazz.getDeclaredConstructors();
        int n = 0;
        for (int i = 0; i < cs.length; ++i) {
            javassistCtConstructor c = cs[i];
            int mod = c.getModifiers();
            if (!this.isInheritable(mod, superclazz)) continue;
            javassistCtConstructor cons = javassistCtNewConstructor.make(c.getParameterTypes(), c.getExceptionTypes(), this);
            cons.setModifiers(mod & 7);
            this.addConstructor(cons);
            ++n;
        }
        if (n < 1) {
            throw new javassistCannotCompileException("no inheritable constructor in " + superclazz.getName());
        }
    }

    private boolean isInheritable(int mod, javassistCtClass superclazz) {
        if (javassistModifier.isPrivate(mod)) {
            return false;
        }
        if (javassistModifier.isPackage(mod)) {
            String pname = this.getPackageName();
            String pname2 = superclazz.getPackageName();
            if (pname == null) {
                return pname2 == null;
            }
            return pname.equals(pname2);
        }
        return true;
    }
}

