/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassClassPath;
import one.edee.oss.proxycian.javassist.original.javassistClassPath;
import one.edee.oss.proxycian.javassist.original.javassistClassPathList;
import one.edee.oss.proxycian.javassist.original.javassistDirClassPath;
import one.edee.oss.proxycian.javassist.original.javassistJarClassPath;
import one.edee.oss.proxycian.javassist.original.javassistJarDirClassPath;
import one.edee.oss.proxycian.javassist.original.javassistLoaderClassPath;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ClassFile;

final class javassistClassPoolTail {
    protected javassistClassPathList pathList = null;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[class path: ");
        javassistClassPathList list = this.pathList;
        while (list != null) {
            buf.append(list.path.toString());
            buf.append(File.pathSeparatorChar);
            list = list.next;
        }
        buf.append(']');
        return buf.toString();
    }

    public synchronized javassistClassPath insertClassPath(javassistClassPath cp) {
        this.pathList = new javassistClassPathList(cp, this.pathList);
        return cp;
    }

    public synchronized javassistClassPath appendClassPath(javassistClassPath cp) {
        javassistClassPathList tail = new javassistClassPathList(cp, null);
        javassistClassPathList list = this.pathList;
        if (list == null) {
            this.pathList = tail;
        } else {
            while (list.next != null) {
                list = list.next;
            }
            list.next = tail;
        }
        return cp;
    }

    public synchronized void removeClassPath(javassistClassPath cp) {
        javassistClassPathList list = this.pathList;
        if (list != null) {
            if (list.path == cp) {
                this.pathList = list.next;
            } else {
                while (list.next != null) {
                    if (list.next.path == cp) {
                        list.next = list.next.next;
                        continue;
                    }
                    list = list.next;
                }
            }
        }
    }

    public javassistClassPath appendSystemPath() {
        if (ClassFile.MAJOR_VERSION < 53) {
            return this.appendClassPath(new javassistClassClassPath());
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.appendClassPath(new javassistLoaderClassPath(cl));
    }

    public javassistClassPath insertClassPath(String pathname) throws javassistNotFoundException {
        return this.insertClassPath(javassistClassPoolTail.makePathObject(pathname));
    }

    public javassistClassPath appendClassPath(String pathname) throws javassistNotFoundException {
        return this.appendClassPath(javassistClassPoolTail.makePathObject(pathname));
    }

    private static javassistClassPath makePathObject(String pathname) throws javassistNotFoundException {
        String lower = pathname.toLowerCase();
        if (lower.endsWith(".jar") || lower.endsWith(".zip")) {
            return new javassistJarClassPath(pathname);
        }
        int len = pathname.length();
        if (len > 2 && pathname.charAt(len - 1) == '*' && (pathname.charAt(len - 2) == '/' || pathname.charAt(len - 2) == File.separatorChar)) {
            String dir = pathname.substring(0, len - 2);
            return new javassistJarDirClassPath(dir);
        }
        return new javassistDirClassPath(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClassfile(String classname, OutputStream out) throws javassistNotFoundException, IOException, javassistCannotCompileException {
        InputStream fin = this.openClassfile(classname);
        if (fin == null) {
            throw new javassistNotFoundException(classname);
        }
        try {
            javassistClassPoolTail.copyStream(fin, out);
        }
        finally {
            fin.close();
        }
    }

    InputStream openClassfile(String classname) throws javassistNotFoundException {
        javassistClassPathList list = this.pathList;
        InputStream ins = null;
        javassistNotFoundException error = null;
        while (list != null) {
            block5: {
                try {
                    ins = list.path.openClassfile(classname);
                }
                catch (javassistNotFoundException e) {
                    if (error != null) break block5;
                    error = e;
                }
            }
            if (ins == null) {
                list = list.next;
                continue;
            }
            return ins;
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    public URL find(String classname) {
        javassistClassPathList list = this.pathList;
        URL url = null;
        while (list != null) {
            url = list.path.find(classname);
            if (url == null) {
                list = list.next;
                continue;
            }
            return url;
        }
        return null;
    }

    public static byte[] readStream(InputStream fin) throws IOException {
        byte[][] bufs = new byte[8][];
        int bufsize = 4096;
        for (int i = 0; i < 8; ++i) {
            bufs[i] = new byte[bufsize];
            int size = 0;
            int len = 0;
            do {
                if ((len = fin.read(bufs[i], size, bufsize - size)) >= 0) continue;
                byte[] result = new byte[bufsize - 4096 + size];
                int s = 0;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(bufs[j], 0, result, s, s + 4096);
                    s = s + s + 4096;
                }
                System.arraycopy(bufs[i], 0, result, s, size);
                return result;
            } while ((size += len) < bufsize);
            bufsize *= 2;
        }
        throw new IOException("too much data");
    }

    public static void copyStream(InputStream fin, OutputStream fout) throws IOException {
        int bufsize = 4096;
        byte[] buf = null;
        for (int i = 0; i < 64; ++i) {
            if (i < 8) {
                buf = new byte[bufsize *= 2];
            }
            int size = 0;
            int len = 0;
            do {
                if ((len = fin.read(buf, size, bufsize - size)) >= 0) continue;
                fout.write(buf, 0, size);
                return;
            } while ((size += len) < bufsize);
            fout.write(buf);
        }
        throw new IOException("too much data");
    }
}

