/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassPath;
import one.edee.oss.proxycian.javassist.original.javassistClassPoolTail;
import one.edee.oss.proxycian.javassist.original.javassistCtArray;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtClassType;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistCtNewClass;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ClassFile;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.Descriptor;
import one.edee.oss.proxycian.javassist.original.javassistutil.proxy.DefineClassHelper;
import one.edee.oss.proxycian.javassist.original.javassistutil.proxy.DefinePackageHelper;

public class javassistClassPool {
    public boolean childFirstLookup = false;
    public static boolean doPruning = false;
    private int compressCount;
    private static final int COMPRESS_THRESHOLD = 100;
    public static boolean releaseUnmodifiedClassFile = true;
    public static boolean cacheOpenedJarFile = true;
    protected javassistClassPoolTail source;
    protected javassistClassPool parent;
    protected Hashtable classes = new Hashtable(191);
    private Hashtable cflow = null;
    private static final int INIT_HASH_SIZE = 191;
    private ArrayList importedPackages;
    private static javassistClassPool defaultPool = null;

    public javassistClassPool() {
        this(null);
    }

    public javassistClassPool(boolean useDefaultPath) {
        this(null);
        if (useDefaultPath) {
            this.appendSystemPath();
        }
    }

    public javassistClassPool(javassistClassPool parent) {
        this.source = new javassistClassPoolTail();
        this.parent = parent;
        if (parent == null) {
            javassistCtClass[] pt = javassistCtClass.primitiveTypes;
            for (int i = 0; i < pt.length; ++i) {
                this.classes.put(pt[i].getName(), pt[i]);
            }
        }
        this.cflow = null;
        this.compressCount = 0;
        this.clearImportedPackages();
    }

    public static synchronized javassistClassPool getDefault() {
        if (defaultPool == null) {
            defaultPool = new javassistClassPool(null);
            defaultPool.appendSystemPath();
        }
        return defaultPool;
    }

    protected javassistCtClass getCached(String classname) {
        return (javassistCtClass)this.classes.get(classname);
    }

    protected void cacheCtClass(String classname, javassistCtClass c, boolean dynamic) {
        this.classes.put(classname, c);
    }

    protected javassistCtClass removeCached(String classname) {
        return (javassistCtClass)this.classes.remove(classname);
    }

    public String toString() {
        return this.source.toString();
    }

    void compress() {
        if (this.compressCount++ > 100) {
            this.compressCount = 0;
            Enumeration e = this.classes.elements();
            while (e.hasMoreElements()) {
                ((javassistCtClass)e.nextElement()).compress();
            }
        }
    }

    public void importPackage(String packageName) {
        this.importedPackages.add(packageName);
    }

    public void clearImportedPackages() {
        this.importedPackages = new ArrayList();
        this.importedPackages.add("java.lang");
    }

    public Iterator<String> getImportedPackages() {
        return this.importedPackages.iterator();
    }

    public void recordInvalidClassName(String name) {
    }

    void recordCflow(String name, String cname, String fname) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        this.cflow.put(name, new Object[]{cname, fname});
    }

    public Object[] lookupCflow(String name) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        return (Object[])this.cflow.get(name);
    }

    public javassistCtClass getAndRename(String orgName, String newName) throws javassistNotFoundException {
        javassistCtClass clazz = this.get0(orgName, false);
        if (clazz == null) {
            throw new javassistNotFoundException(orgName);
        }
        if (clazz instanceof javassistCtClassType) {
            ((javassistCtClassType)clazz).setClassPool(this);
        }
        clazz.setName(newName);
        return clazz;
    }

    synchronized void classNameChanged(String oldname, javassistCtClass clazz) {
        javassistCtClass c = this.getCached(oldname);
        if (c == clazz) {
            this.removeCached(oldname);
        }
        String newName = clazz.getName();
        this.checkNotFrozen(newName);
        this.cacheCtClass(newName, clazz, false);
    }

    public javassistCtClass get(String classname) throws javassistNotFoundException {
        javassistCtClass clazz = classname == null ? null : this.get0(classname, true);
        if (clazz == null) {
            throw new javassistNotFoundException(classname);
        }
        clazz.incGetCounter();
        return clazz;
    }

    public javassistCtClass getOrNull(String classname) {
        javassistCtClass clazz = null;
        if (classname == null) {
            clazz = null;
        } else {
            try {
                clazz = this.get0(classname, true);
            }
            catch (javassistNotFoundException javassistNotFoundException2) {
                // empty catch block
            }
        }
        if (clazz != null) {
            clazz.incGetCounter();
        }
        return clazz;
    }

    public javassistCtClass getCtClass(String classname) throws javassistNotFoundException {
        if (classname.charAt(0) == '[') {
            return Descriptor.toCtClass(classname, this);
        }
        return this.get(classname);
    }

    protected synchronized javassistCtClass get0(String classname, boolean useCache) throws javassistNotFoundException {
        javassistCtClass clazz = null;
        if (useCache && (clazz = this.getCached(classname)) != null) {
            return clazz;
        }
        if (!this.childFirstLookup && this.parent != null && (clazz = this.parent.get0(classname, useCache)) != null) {
            return clazz;
        }
        clazz = this.createCtClass(classname, useCache);
        if (clazz != null) {
            if (useCache) {
                this.cacheCtClass(clazz.getName(), clazz, false);
            }
            return clazz;
        }
        if (this.childFirstLookup && this.parent != null) {
            clazz = this.parent.get0(classname, useCache);
        }
        return clazz;
    }

    protected javassistCtClass createCtClass(String classname, boolean useCache) {
        if (classname.charAt(0) == '[') {
            classname = Descriptor.toClassName(classname);
        }
        if (classname.endsWith("[]")) {
            String base = classname.substring(0, classname.indexOf(91));
            if (!(useCache && this.getCached(base) != null || this.find(base) != null)) {
                return null;
            }
            return new javassistCtArray(classname, this);
        }
        if (this.find(classname) == null) {
            return null;
        }
        return new javassistCtClassType(classname, this);
    }

    public URL find(String classname) {
        return this.source.find(classname);
    }

    void checkNotFrozen(String classname) throws RuntimeException {
        javassistCtClass clazz = this.getCached(classname);
        if (clazz == null) {
            if (!this.childFirstLookup && this.parent != null) {
                try {
                    clazz = this.parent.get0(classname, true);
                }
                catch (javassistNotFoundException javassistNotFoundException2) {
                    // empty catch block
                }
                if (clazz != null) {
                    throw new RuntimeException(classname + " is in a parent ClassPool.  Use the parent.");
                }
            }
        } else if (clazz.isFrozen()) {
            throw new RuntimeException(classname + ": frozen class (cannot edit)");
        }
    }

    javassistCtClass checkNotExists(String classname) {
        javassistCtClass clazz = this.getCached(classname);
        if (clazz == null && !this.childFirstLookup && this.parent != null) {
            try {
                clazz = this.parent.get0(classname, true);
            }
            catch (javassistNotFoundException javassistNotFoundException2) {
                // empty catch block
            }
        }
        return clazz;
    }

    InputStream openClassfile(String classname) throws javassistNotFoundException {
        return this.source.openClassfile(classname);
    }

    void writeClassfile(String classname, OutputStream out) throws javassistNotFoundException, IOException, javassistCannotCompileException {
        this.source.writeClassfile(classname, out);
    }

    public javassistCtClass[] get(String[] classnames) throws javassistNotFoundException {
        if (classnames == null) {
            return new javassistCtClass[0];
        }
        int num = classnames.length;
        javassistCtClass[] result = new javassistCtClass[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.get(classnames[i]);
        }
        return result;
    }

    public javassistCtMethod getMethod(String classname, String methodname) throws javassistNotFoundException {
        javassistCtClass c = this.get(classname);
        return c.getDeclaredMethod(methodname);
    }

    public javassistCtClass makeClass(InputStream classfile) throws IOException, RuntimeException {
        return this.makeClass(classfile, true);
    }

    public javassistCtClass makeClass(InputStream classfile, boolean ifNotFrozen) throws IOException, RuntimeException {
        this.compress();
        classfile = new BufferedInputStream(classfile);
        javassistCtClassType clazz = new javassistCtClassType(classfile, this);
        ((javassistCtClass)clazz).checkModify();
        String classname = clazz.getName();
        if (ifNotFrozen) {
            this.checkNotFrozen(classname);
        }
        this.cacheCtClass(classname, clazz, true);
        return clazz;
    }

    public javassistCtClass makeClass(ClassFile classfile) throws RuntimeException {
        return this.makeClass(classfile, true);
    }

    public javassistCtClass makeClass(ClassFile classfile, boolean ifNotFrozen) throws RuntimeException {
        this.compress();
        javassistCtClassType clazz = new javassistCtClassType(classfile, this);
        ((javassistCtClass)clazz).checkModify();
        String classname = clazz.getName();
        if (ifNotFrozen) {
            this.checkNotFrozen(classname);
        }
        this.cacheCtClass(classname, clazz, true);
        return clazz;
    }

    public javassistCtClass makeClassIfNew(InputStream classfile) throws IOException, RuntimeException {
        this.compress();
        classfile = new BufferedInputStream(classfile);
        javassistCtClassType clazz = new javassistCtClassType(classfile, this);
        ((javassistCtClass)clazz).checkModify();
        String classname = clazz.getName();
        javassistCtClass found = this.checkNotExists(classname);
        if (found != null) {
            return found;
        }
        this.cacheCtClass(classname, clazz, true);
        return clazz;
    }

    public javassistCtClass makeClass(String classname) throws RuntimeException {
        return this.makeClass(classname, null);
    }

    public synchronized javassistCtClass makeClass(String classname, javassistCtClass superclass) throws RuntimeException {
        this.checkNotFrozen(classname);
        javassistCtNewClass clazz = new javassistCtNewClass(classname, this, false, superclass);
        this.cacheCtClass(classname, clazz, true);
        return clazz;
    }

    synchronized javassistCtClass makeNestedClass(String classname) {
        this.checkNotFrozen(classname);
        javassistCtNewClass clazz = new javassistCtNewClass(classname, this, false, null);
        this.cacheCtClass(classname, clazz, true);
        return clazz;
    }

    public javassistCtClass makeInterface(String name) throws RuntimeException {
        return this.makeInterface(name, null);
    }

    public synchronized javassistCtClass makeInterface(String name, javassistCtClass superclass) throws RuntimeException {
        this.checkNotFrozen(name);
        javassistCtNewClass clazz = new javassistCtNewClass(name, this, true, superclass);
        this.cacheCtClass(name, clazz, true);
        return clazz;
    }

    public javassistCtClass makeAnnotation(String name) throws RuntimeException {
        try {
            javassistCtClass cc = this.makeInterface(name, this.get("java.lang.annotation.Annotation"));
            cc.setModifiers(cc.getModifiers() | 0x2000);
            return cc;
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public javassistClassPath appendSystemPath() {
        return this.source.appendSystemPath();
    }

    public javassistClassPath insertClassPath(javassistClassPath cp) {
        return this.source.insertClassPath(cp);
    }

    public javassistClassPath appendClassPath(javassistClassPath cp) {
        return this.source.appendClassPath(cp);
    }

    public javassistClassPath insertClassPath(String pathname) throws javassistNotFoundException {
        return this.source.insertClassPath(pathname);
    }

    public javassistClassPath appendClassPath(String pathname) throws javassistNotFoundException {
        return this.source.appendClassPath(pathname);
    }

    public void removeClassPath(javassistClassPath cp) {
        this.source.removeClassPath(cp);
    }

    public void appendPathList(String pathlist) throws javassistNotFoundException {
        char sep = File.pathSeparatorChar;
        int i = 0;
        while (true) {
            int j;
            if ((j = pathlist.indexOf(sep, i)) < 0) break;
            this.appendClassPath(pathlist.substring(i, j));
            i = j + 1;
        }
        this.appendClassPath(pathlist.substring(i));
    }

    public Class toClass(javassistCtClass clazz) throws javassistCannotCompileException {
        return this.toClass(clazz, this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return javassistClassPool.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Class toClass(javassistCtClass ct, ClassLoader loader) throws javassistCannotCompileException {
        return this.toClass(ct, null, loader, null);
    }

    public Class toClass(javassistCtClass ct, ClassLoader loader, ProtectionDomain domain) throws javassistCannotCompileException {
        return this.toClass(ct, null, loader, domain);
    }

    public Class<?> toClass(javassistCtClass ct, Class<?> neighbor) throws javassistCannotCompileException {
        try {
            return DefineClassHelper.toClass(neighbor, ct.toBytecode());
        }
        catch (IOException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    public Class<?> toClass(javassistCtClass ct, MethodHandles.Lookup lookup) throws javassistCannotCompileException {
        try {
            return DefineClassHelper.toClass(lookup, ct.toBytecode());
        }
        catch (IOException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    public Class toClass(javassistCtClass ct, Class<?> neighbor, ClassLoader loader, ProtectionDomain domain) throws javassistCannotCompileException {
        try {
            return DefineClassHelper.toClass(ct.getName(), neighbor, loader, domain, ct.toBytecode());
        }
        catch (IOException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    public void makePackage(ClassLoader loader, String name) throws javassistCannotCompileException {
        DefinePackageHelper.definePackage(name, loader);
    }
}

