/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis.MultiArrayType;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.analysis.MultiType;

public class Type {
    private final javassistCtClass clazz;
    private final boolean special;
    private static final Map<javassistCtClass, Type> prims = new IdentityHashMap<javassistCtClass, Type>();
    public static final Type DOUBLE = new Type(javassistCtClass.doubleType);
    public static final Type BOOLEAN = new Type(javassistCtClass.booleanType);
    public static final Type LONG = new Type(javassistCtClass.longType);
    public static final Type CHAR = new Type(javassistCtClass.charType);
    public static final Type BYTE = new Type(javassistCtClass.byteType);
    public static final Type SHORT = new Type(javassistCtClass.shortType);
    public static final Type INTEGER = new Type(javassistCtClass.intType);
    public static final Type FLOAT = new Type(javassistCtClass.floatType);
    public static final Type VOID = new Type(javassistCtClass.voidType);
    public static final Type UNINIT = new Type(null);
    public static final Type RETURN_ADDRESS = new Type(null, true);
    public static final Type TOP = new Type(null, true);
    public static final Type BOGUS = new Type(null, true);
    public static final Type OBJECT = Type.lookupType("java.lang.Object");
    public static final Type SERIALIZABLE = Type.lookupType("java.io.Serializable");
    public static final Type CLONEABLE = Type.lookupType("java.lang.Cloneable");
    public static final Type THROWABLE = Type.lookupType("java.lang.Throwable");

    public static Type get(javassistCtClass clazz) {
        Type type = prims.get(clazz);
        return type != null ? type : new Type(clazz);
    }

    private static Type lookupType(String name) {
        try {
            return new Type(javassistClassPool.getDefault().get(name));
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    Type(javassistCtClass clazz) {
        this(clazz, false);
    }

    private Type(javassistCtClass clazz, boolean special) {
        this.clazz = clazz;
        this.special = special;
    }

    boolean popChanged() {
        return false;
    }

    public int getSize() {
        return this.clazz == javassistCtClass.doubleType || this.clazz == javassistCtClass.longType || this == TOP ? 2 : 1;
    }

    public javassistCtClass getCtClass() {
        return this.clazz;
    }

    public boolean isReference() {
        return !this.special && (this.clazz == null || !this.clazz.isPrimitive());
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isArray() {
        return this.clazz != null && this.clazz.isArray();
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        String name = this.clazz.getName();
        int pos = name.length() - 1;
        int count = 0;
        while (name.charAt(pos) == ']') {
            pos -= 2;
            ++count;
        }
        return count;
    }

    public Type getComponent() {
        javassistCtClass component;
        if (this.clazz == null || !this.clazz.isArray()) {
            return null;
        }
        try {
            component = this.clazz.getComponentType();
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e);
        }
        Type type = prims.get(component);
        return type != null ? type : new Type(component);
    }

    public boolean isAssignableFrom(Type type) {
        if (this == type) {
            return true;
        }
        if (type == UNINIT && this.isReference() || this == UNINIT && type.isReference()) {
            return true;
        }
        if (type instanceof MultiType) {
            return ((MultiType)type).isAssignableTo(this);
        }
        if (type instanceof MultiArrayType) {
            return ((MultiArrayType)type).isAssignableTo(this);
        }
        if (this.clazz == null || this.clazz.isPrimitive()) {
            return false;
        }
        try {
            return type.clazz.subtypeOf(this.clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Type merge(Type type) {
        if (type == this) {
            return this;
        }
        if (type == null) {
            return this;
        }
        if (type == UNINIT) {
            return this;
        }
        if (this == UNINIT) {
            return type;
        }
        if (!type.isReference() || !this.isReference()) {
            return BOGUS;
        }
        if (type instanceof MultiType) {
            return type.merge(this);
        }
        if (type.isArray() && this.isArray()) {
            return this.mergeArray(type);
        }
        try {
            return this.mergeClasses(type);
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    Type getRootComponent(Type type) {
        while (type.isArray()) {
            type = type.getComponent();
        }
        return type;
    }

    private Type createArray(Type rootComponent, int dims) {
        Type type;
        if (rootComponent instanceof MultiType) {
            return new MultiArrayType((MultiType)rootComponent, dims);
        }
        String name = this.arrayName(rootComponent.clazz.getName(), dims);
        try {
            type = Type.get(this.getClassPool(rootComponent).get(name));
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e);
        }
        return type;
    }

    String arrayName(String component, int dims) {
        int i = component.length();
        int size = i + dims * 2;
        char[] string = new char[size];
        component.getChars(0, i, string, 0);
        while (i < size) {
            string[i++] = 91;
            string[i++] = 93;
        }
        component = new String(string);
        return component;
    }

    private javassistClassPool getClassPool(Type rootComponent) {
        javassistClassPool pool = rootComponent.clazz.getClassPool();
        return pool != null ? pool : javassistClassPool.getDefault();
    }

    private Type mergeArray(Type type) {
        int targetDims;
        Type targetRoot;
        int thisDims;
        Type typeRoot = this.getRootComponent(type);
        Type thisRoot = this.getRootComponent(this);
        int typeDims = type.getDimensions();
        if (typeDims == (thisDims = this.getDimensions())) {
            Type mergedComponent = thisRoot.merge(typeRoot);
            if (mergedComponent == BOGUS) {
                return OBJECT;
            }
            return this.createArray(mergedComponent, thisDims);
        }
        if (typeDims < thisDims) {
            targetRoot = typeRoot;
            targetDims = typeDims;
        } else {
            targetRoot = thisRoot;
            targetDims = thisDims;
        }
        if (Type.eq(Type.CLONEABLE.clazz, targetRoot.clazz) || Type.eq(Type.SERIALIZABLE.clazz, targetRoot.clazz)) {
            return this.createArray(targetRoot, targetDims);
        }
        return this.createArray(OBJECT, targetDims);
    }

    private static javassistCtClass findCommonSuperClass(javassistCtClass one, javassistCtClass two) throws javassistNotFoundException {
        javassistCtClass shallow;
        javassistCtClass deep = one;
        javassistCtClass backupShallow = shallow = two;
        javassistCtClass backupDeep = deep;
        while (true) {
            if (Type.eq(deep, shallow) && deep.getSuperclass() != null) {
                return deep;
            }
            javassistCtClass deepSuper = deep.getSuperclass();
            javassistCtClass shallowSuper = shallow.getSuperclass();
            if (shallowSuper == null) {
                shallow = backupShallow;
                break;
            }
            if (deepSuper == null) {
                deep = backupDeep;
                backupDeep = backupShallow;
                backupShallow = deep;
                deep = shallow;
                shallow = backupShallow;
                break;
            }
            deep = deepSuper;
            shallow = shallowSuper;
        }
        while ((deep = deep.getSuperclass()) != null) {
            backupDeep = backupDeep.getSuperclass();
        }
        deep = backupDeep;
        while (!Type.eq(deep, shallow)) {
            deep = deep.getSuperclass();
            shallow = shallow.getSuperclass();
        }
        return deep;
    }

    private Type mergeClasses(Type type) throws javassistNotFoundException {
        javassistCtClass superClass = Type.findCommonSuperClass(this.clazz, type.clazz);
        if (superClass.getSuperclass() == null) {
            Map<String, javassistCtClass> interfaces = this.findCommonInterfaces(type);
            if (interfaces.size() == 1) {
                return new Type(interfaces.values().iterator().next());
            }
            if (interfaces.size() > 1) {
                return new MultiType(interfaces);
            }
            return new Type(superClass);
        }
        Map<String, javassistCtClass> commonDeclared = this.findExclusiveDeclaredInterfaces(type, superClass);
        if (commonDeclared.size() > 0) {
            return new MultiType(commonDeclared, new Type(superClass));
        }
        return new Type(superClass);
    }

    private Map<String, javassistCtClass> findCommonInterfaces(Type type) {
        Map<String, javassistCtClass> typeMap = this.getAllInterfaces(type.clazz, null);
        Map<String, javassistCtClass> thisMap = this.getAllInterfaces(this.clazz, null);
        return this.findCommonInterfaces(typeMap, thisMap);
    }

    private Map<String, javassistCtClass> findExclusiveDeclaredInterfaces(Type type, javassistCtClass exclude) {
        Map<String, javassistCtClass> typeMap = this.getDeclaredInterfaces(type.clazz, null);
        Map<String, javassistCtClass> thisMap = this.getDeclaredInterfaces(this.clazz, null);
        Map<String, javassistCtClass> excludeMap = this.getAllInterfaces(exclude, null);
        for (String intf : excludeMap.keySet()) {
            typeMap.remove(intf);
            thisMap.remove(intf);
        }
        return this.findCommonInterfaces(typeMap, thisMap);
    }

    Map<String, javassistCtClass> findCommonInterfaces(Map<String, javassistCtClass> typeMap, Map<String, javassistCtClass> alterMap) {
        if (alterMap == null) {
            alterMap = new HashMap<String, javassistCtClass>();
        }
        if (typeMap == null || typeMap.isEmpty()) {
            alterMap.clear();
        }
        Iterator<String> it = alterMap.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (typeMap.containsKey(name)) continue;
            it.remove();
        }
        ArrayList<javassistCtClass> interfaces = new ArrayList<javassistCtClass>();
        for (javassistCtClass intf : alterMap.values()) {
            try {
                interfaces.addAll(Arrays.asList(intf.getInterfaces()));
            }
            catch (javassistNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        for (javassistCtClass c : interfaces) {
            alterMap.remove(c.getName());
        }
        return alterMap;
    }

    Map<String, javassistCtClass> getAllInterfaces(javassistCtClass clazz, Map<String, javassistCtClass> map) {
        if (map == null) {
            map = new HashMap<String, javassistCtClass>();
        }
        if (clazz.isInterface()) {
            map.put(clazz.getName(), clazz);
        }
        do {
            try {
                javassistCtClass[] interfaces;
                for (javassistCtClass intf : interfaces = clazz.getInterfaces()) {
                    map.put(intf.getName(), intf);
                    this.getAllInterfaces(intf, map);
                }
                clazz = clazz.getSuperclass();
            }
            catch (javassistNotFoundException e) {
                throw new RuntimeException(e);
            }
        } while (clazz != null);
        return map;
    }

    Map<String, javassistCtClass> getDeclaredInterfaces(javassistCtClass clazz, Map<String, javassistCtClass> map) {
        javassistCtClass[] interfaces;
        if (map == null) {
            map = new HashMap<String, javassistCtClass>();
        }
        if (clazz.isInterface()) {
            map.put(clazz.getName(), clazz);
        }
        try {
            interfaces = clazz.getInterfaces();
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (javassistCtClass intf : interfaces) {
            map.put(intf.getName(), intf);
            this.getDeclaredInterfaces(intf, map);
        }
        return map;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.clazz.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        return o.getClass() == this.getClass() && Type.eq(this.clazz, ((Type)o).clazz);
    }

    static boolean eq(javassistCtClass one, javassistCtClass two) {
        return one == two || one != null && two != null && one.getName().equals(two.getName());
    }

    public String toString() {
        if (this == BOGUS) {
            return "BOGUS";
        }
        if (this == UNINIT) {
            return "UNINIT";
        }
        if (this == RETURN_ADDRESS) {
            return "RETURN ADDRESS";
        }
        if (this == TOP) {
            return "TOP";
        }
        return this.clazz == null ? "null" : this.clazz.getName();
    }

    static {
        prims.put(javassistCtClass.doubleType, DOUBLE);
        prims.put(javassistCtClass.longType, LONG);
        prims.put(javassistCtClass.charType, CHAR);
        prims.put(javassistCtClass.shortType, SHORT);
        prims.put(javassistCtClass.intType, INTEGER);
        prims.put(javassistCtClass.floatType, FLOAT);
        prims.put(javassistCtClass.byteType, BYTE);
        prims.put(javassistCtClass.booleanType, BOOLEAN);
        prims.put(javassistCtClass.voidType, VOID);
    }
}

