package one.gfw.antlr4.java;

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public interface JavaParserVisitor<T> extends ParseTreeVisitor<T> {

    T visitCompilationUnit(JavaParser.CompilationUnitContext ctx);

    T visitPackageDeclaration(JavaParser.PackageDeclarationContext ctx);

    T visitImportDeclaration(JavaParser.ImportDeclarationContext ctx);

    T visitTypeDeclaration(JavaParser.TypeDeclarationContext ctx);

    T visitModifier(JavaParser.ModifierContext ctx);

    T visitClassOrInterfaceModifier(JavaParser.ClassOrInterfaceModifierContext ctx);

    T visitVariableModifier(JavaParser.VariableModifierContext ctx);

    T visitClassDeclaration(JavaParser.ClassDeclarationContext ctx);

    T visitTypeParameters(JavaParser.TypeParametersContext ctx);

    T visitTypeParameter(JavaParser.TypeParameterContext ctx);

    T visitTypeBound(JavaParser.TypeBoundContext ctx);

    T visitEnumDeclaration(JavaParser.EnumDeclarationContext ctx);

    T visitEnumConstants(JavaParser.EnumConstantsContext ctx);

    T visitEnumConstant(JavaParser.EnumConstantContext ctx);

    T visitEnumBodyDeclarations(JavaParser.EnumBodyDeclarationsContext ctx);

    T visitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx);

    T visitClassBody(JavaParser.ClassBodyContext ctx);

    T visitInterfaceBody(JavaParser.InterfaceBodyContext ctx);

    T visitClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx);

    T visitMemberDeclaration(JavaParser.MemberDeclarationContext ctx);

    T visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx);

    T visitMethodBody(JavaParser.MethodBodyContext ctx);

    T visitTypeTypeOrVoid(JavaParser.TypeTypeOrVoidContext ctx);

    T visitGenericMethodDeclaration(JavaParser.GenericMethodDeclarationContext ctx);

    T visitGenericConstructorDeclaration(JavaParser.GenericConstructorDeclarationContext ctx);

    T visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx);

    T visitFieldDeclaration(JavaParser.FieldDeclarationContext ctx);

    T visitInterfaceBodyDeclaration(JavaParser.InterfaceBodyDeclarationContext ctx);

    T visitInterfaceMemberDeclaration(JavaParser.InterfaceMemberDeclarationContext ctx);

    T visitConstDeclaration(JavaParser.ConstDeclarationContext ctx);

    T visitConstantDeclarator(JavaParser.ConstantDeclaratorContext ctx);

    T visitInterfaceMethodDeclaration(JavaParser.InterfaceMethodDeclarationContext ctx);

    T visitInterfaceMethodModifier(JavaParser.InterfaceMethodModifierContext ctx);

    T visitGenericInterfaceMethodDeclaration(JavaParser.GenericInterfaceMethodDeclarationContext ctx);

    T visitInterfaceCommonBodyDeclaration(JavaParser.InterfaceCommonBodyDeclarationContext ctx);

    T visitVariableDeclarators(JavaParser.VariableDeclaratorsContext ctx);

    T visitVariableDeclarator(JavaParser.VariableDeclaratorContext ctx);

    T visitVariableDeclaratorId(JavaParser.VariableDeclaratorIdContext ctx);

    T visitVariableInitializer(JavaParser.VariableInitializerContext ctx);

    T visitArrayInitializer(JavaParser.ArrayInitializerContext ctx);

    T visitClassOrInterfaceType(JavaParser.ClassOrInterfaceTypeContext ctx);

    T visitTypeArgument(JavaParser.TypeArgumentContext ctx);

    T visitQualifiedNameList(JavaParser.QualifiedNameListContext ctx);

    T visitFormalParameters(JavaParser.FormalParametersContext ctx);

    T visitReceiverParameter(JavaParser.ReceiverParameterContext ctx);

    T visitFormalParameterList(JavaParser.FormalParameterListContext ctx);

    T visitFormalParameter(JavaParser.FormalParameterContext ctx);

    T visitLastFormalParameter(JavaParser.LastFormalParameterContext ctx);

    T visitLambdaLVTIList(JavaParser.LambdaLVTIListContext ctx);

    T visitLambdaLVTIParameter(JavaParser.LambdaLVTIParameterContext ctx);

    T visitQualifiedName(JavaParser.QualifiedNameContext ctx);

    T visitLiteral(JavaParser.LiteralContext ctx);

    T visitIntegerLiteral(JavaParser.IntegerLiteralContext ctx);

    T visitFloatLiteral(JavaParser.FloatLiteralContext ctx);

    T visitAltAnnotationQualifiedName(JavaParser.AltAnnotationQualifiedNameContext ctx);

    T visitAnnotation(JavaParser.AnnotationContext ctx);

    T visitElementValuePairs(JavaParser.ElementValuePairsContext ctx);

    T visitElementValuePair(JavaParser.ElementValuePairContext ctx);

    T visitElementValue(JavaParser.ElementValueContext ctx);

    T visitElementValueArrayInitializer(JavaParser.ElementValueArrayInitializerContext ctx);

    T visitAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx);

    T visitAnnotationTypeBody(JavaParser.AnnotationTypeBodyContext ctx);

    T visitAnnotationTypeElementDeclaration(JavaParser.AnnotationTypeElementDeclarationContext ctx);

    T visitAnnotationTypeElementRest(JavaParser.AnnotationTypeElementRestContext ctx);

    T visitAnnotationMethodOrConstantRest(JavaParser.AnnotationMethodOrConstantRestContext ctx);

    T visitAnnotationMethodRest(JavaParser.AnnotationMethodRestContext ctx);

    T visitAnnotationConstantRest(JavaParser.AnnotationConstantRestContext ctx);

    T visitDefaultValue(JavaParser.DefaultValueContext ctx);

    T visitModuleDeclaration(JavaParser.ModuleDeclarationContext ctx);

    T visitModuleBody(JavaParser.ModuleBodyContext ctx);

    T visitModuleDirective(JavaParser.ModuleDirectiveContext ctx);

    T visitRequiresModifier(JavaParser.RequiresModifierContext ctx);

    T visitRecordDeclaration(JavaParser.RecordDeclarationContext ctx);

    T visitRecordHeader(JavaParser.RecordHeaderContext ctx);

    T visitRecordComponentList(JavaParser.RecordComponentListContext ctx);

    T visitRecordComponent(JavaParser.RecordComponentContext ctx);

    T visitRecordBody(JavaParser.RecordBodyContext ctx);

    T visitBlock(JavaParser.BlockContext ctx);

    T visitBlockStatement(JavaParser.BlockStatementContext ctx);

    T visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx);

    T visitIdentifier(JavaParser.IdentifierContext ctx);

    T visitLocalTypeDeclaration(JavaParser.LocalTypeDeclarationContext ctx);

    T visitStatement(JavaParser.StatementContext ctx);

    T visitCatchClause(JavaParser.CatchClauseContext ctx);

    T visitCatchType(JavaParser.CatchTypeContext ctx);

    T visitFinallyBlock(JavaParser.FinallyBlockContext ctx);

    T visitResourceSpecification(JavaParser.ResourceSpecificationContext ctx);

    T visitResources(JavaParser.ResourcesContext ctx);

    T visitResource(JavaParser.ResourceContext ctx);

    T visitSwitchBlockStatementGroup(JavaParser.SwitchBlockStatementGroupContext ctx);

    T visitSwitchLabel(JavaParser.SwitchLabelContext ctx);

    T visitForControl(JavaParser.ForControlContext ctx);

    T visitForInit(JavaParser.ForInitContext ctx);

    T visitEnhancedForControl(JavaParser.EnhancedForControlContext ctx);

    T visitParExpression(JavaParser.ParExpressionContext ctx);

    T visitExpressionList(JavaParser.ExpressionListContext ctx);

    T visitMethodCall(JavaParser.MethodCallContext ctx);

    T visitExpression(JavaParser.ExpressionContext ctx);

    T visitPattern(JavaParser.PatternContext ctx);

    T visitLambdaExpression(JavaParser.LambdaExpressionContext ctx);

    T visitLambdaParameters(JavaParser.LambdaParametersContext ctx);

    T visitLambdaBody(JavaParser.LambdaBodyContext ctx);

    T visitPrimary(JavaParser.PrimaryContext ctx);

    T visitSwitchExpression(JavaParser.SwitchExpressionContext ctx);

    T visitSwitchLabeledRule(JavaParser.SwitchLabeledRuleContext ctx);

    T visitGuardedPattern(JavaParser.GuardedPatternContext ctx);

    T visitSwitchRuleOutcome(JavaParser.SwitchRuleOutcomeContext ctx);

    T visitClassType(JavaParser.ClassTypeContext ctx);

    T visitCreator(JavaParser.CreatorContext ctx);

    T visitCreatedName(JavaParser.CreatedNameContext ctx);

    T visitInnerCreator(JavaParser.InnerCreatorContext ctx);

    T visitArrayCreatorRest(JavaParser.ArrayCreatorRestContext ctx);

    T visitClassCreatorRest(JavaParser.ClassCreatorRestContext ctx);

    T visitExplicitGenericInvocation(JavaParser.ExplicitGenericInvocationContext ctx);

    T visitTypeArgumentsOrDiamond(JavaParser.TypeArgumentsOrDiamondContext ctx);

    T visitNonWildcardTypeArgumentsOrDiamond(JavaParser.NonWildcardTypeArgumentsOrDiamondContext ctx);

    T visitNonWildcardTypeArguments(JavaParser.NonWildcardTypeArgumentsContext ctx);

    T visitTypeList(JavaParser.TypeListContext ctx);

    T visitTypeType(JavaParser.TypeTypeContext ctx);

    T visitPrimitiveType(JavaParser.PrimitiveTypeContext ctx);

    T visitTypeArguments(JavaParser.TypeArgumentsContext ctx);

    T visitSuperSuffix(JavaParser.SuperSuffixContext ctx);

    T visitExplicitGenericInvocationSuffix(JavaParser.ExplicitGenericInvocationSuffixContext ctx);

    T visitArguments(JavaParser.ArgumentsContext ctx);
}
