package one.gfw.antlr4.js.javascript;

import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;

public abstract class JavaScriptParserBase extends Parser {

    public JavaScriptParserBase(TokenStream input) {
        super(input);
    }

    protected boolean p(String str) {
        return prev(str);
    }

    protected boolean prev(String str) {
        return _input.LT(-1).getText().equals(str);
    }

    protected boolean n(String str) {
        return next(str);
    }

    protected boolean next(String str) {
        return _input.LT(1).getText().equals(str);
    }

    protected boolean notLineTerminator() {
        return !here(JavaScriptParser.LineTerminator);
    }

    protected boolean notOpenBraceAndNotFunction() {
        int nextTokenType = _input.LT(1).getType();
        return nextTokenType != JavaScriptParser.OpenBrace && nextTokenType != JavaScriptParser.Function_;
    }

    protected boolean closeBrace() {
        return _input.LT(1).getType() == JavaScriptParser.CloseBrace;
    }

    private boolean here(final int type) {
        int possibleIndexEosToken = this.getCurrentToken().getTokenIndex() - 1;
        Token ahead = _input.get(possibleIndexEosToken);
        return (ahead.getChannel() == Lexer.HIDDEN) && (ahead.getType() == type);
    }

    protected boolean lineTerminatorAhead() {
        int possibleIndexEosToken = this.getCurrentToken().getTokenIndex() - 1;
        Token ahead = _input.get(possibleIndexEosToken);
        if (ahead.getChannel() != Lexer.HIDDEN) {
            return false;
        }
        if (ahead.getType() == JavaScriptParser.LineTerminator) {
            return true;
        }
        if (ahead.getType() == JavaScriptParser.WhiteSpaces) {
            possibleIndexEosToken = this.getCurrentToken().getTokenIndex() - 2;
            ahead = _input.get(possibleIndexEosToken);
        }
        String text = ahead.getText();
        int type = ahead.getType();
        return (type == JavaScriptParser.MultiLineComment && (text.contains("\r") || text.contains("\n"))) || (type == JavaScriptParser.LineTerminator);
    }
}
