package one.gfw.antlr4.js.javascript;

import org.antlr.v4.runtime.tree.ParseTreeListener;

public interface JavaScriptParserListener extends ParseTreeListener {

    void enterProgram(JavaScriptParser.ProgramContext ctx);

    void exitProgram(JavaScriptParser.ProgramContext ctx);

    void enterSourceElement(JavaScriptParser.SourceElementContext ctx);

    void exitSourceElement(JavaScriptParser.SourceElementContext ctx);

    void enterStatement(JavaScriptParser.StatementContext ctx);

    void exitStatement(JavaScriptParser.StatementContext ctx);

    void enterBlock(JavaScriptParser.BlockContext ctx);

    void exitBlock(JavaScriptParser.BlockContext ctx);

    void enterStatementList(JavaScriptParser.StatementListContext ctx);

    void exitStatementList(JavaScriptParser.StatementListContext ctx);

    void enterImportStatement(JavaScriptParser.ImportStatementContext ctx);

    void exitImportStatement(JavaScriptParser.ImportStatementContext ctx);

    void enterImportFromBlock(JavaScriptParser.ImportFromBlockContext ctx);

    void exitImportFromBlock(JavaScriptParser.ImportFromBlockContext ctx);

    void enterModuleItems(JavaScriptParser.ModuleItemsContext ctx);

    void exitModuleItems(JavaScriptParser.ModuleItemsContext ctx);

    void enterImportDefault(JavaScriptParser.ImportDefaultContext ctx);

    void exitImportDefault(JavaScriptParser.ImportDefaultContext ctx);

    void enterImportNamespace(JavaScriptParser.ImportNamespaceContext ctx);

    void exitImportNamespace(JavaScriptParser.ImportNamespaceContext ctx);

    void enterImportFrom(JavaScriptParser.ImportFromContext ctx);

    void exitImportFrom(JavaScriptParser.ImportFromContext ctx);

    void enterAliasName(JavaScriptParser.AliasNameContext ctx);

    void exitAliasName(JavaScriptParser.AliasNameContext ctx);

    void enterExportDeclaration(JavaScriptParser.ExportDeclarationContext ctx);

    void exitExportDeclaration(JavaScriptParser.ExportDeclarationContext ctx);

    void enterExportDefaultDeclaration(JavaScriptParser.ExportDefaultDeclarationContext ctx);

    void exitExportDefaultDeclaration(JavaScriptParser.ExportDefaultDeclarationContext ctx);

    void enterExportFromBlock(JavaScriptParser.ExportFromBlockContext ctx);

    void exitExportFromBlock(JavaScriptParser.ExportFromBlockContext ctx);

    void enterDeclaration(JavaScriptParser.DeclarationContext ctx);

    void exitDeclaration(JavaScriptParser.DeclarationContext ctx);

    void enterVariableStatement(JavaScriptParser.VariableStatementContext ctx);

    void exitVariableStatement(JavaScriptParser.VariableStatementContext ctx);

    void enterVariableDeclarationList(JavaScriptParser.VariableDeclarationListContext ctx);

    void exitVariableDeclarationList(JavaScriptParser.VariableDeclarationListContext ctx);

    void enterVariableDeclaration(JavaScriptParser.VariableDeclarationContext ctx);

    void exitVariableDeclaration(JavaScriptParser.VariableDeclarationContext ctx);

    void enterEmptyStatement_(JavaScriptParser.EmptyStatement_Context ctx);

    void exitEmptyStatement_(JavaScriptParser.EmptyStatement_Context ctx);

    void enterExpressionStatement(JavaScriptParser.ExpressionStatementContext ctx);

    void exitExpressionStatement(JavaScriptParser.ExpressionStatementContext ctx);

    void enterIfStatement(JavaScriptParser.IfStatementContext ctx);

    void exitIfStatement(JavaScriptParser.IfStatementContext ctx);

    void enterDoStatement(JavaScriptParser.DoStatementContext ctx);

    void exitDoStatement(JavaScriptParser.DoStatementContext ctx);

    void enterWhileStatement(JavaScriptParser.WhileStatementContext ctx);

    void exitWhileStatement(JavaScriptParser.WhileStatementContext ctx);

    void enterForStatement(JavaScriptParser.ForStatementContext ctx);

    void exitForStatement(JavaScriptParser.ForStatementContext ctx);

    void enterForInStatement(JavaScriptParser.ForInStatementContext ctx);

    void exitForInStatement(JavaScriptParser.ForInStatementContext ctx);

    void enterForOfStatement(JavaScriptParser.ForOfStatementContext ctx);

    void exitForOfStatement(JavaScriptParser.ForOfStatementContext ctx);

    void enterVarModifier(JavaScriptParser.VarModifierContext ctx);

    void exitVarModifier(JavaScriptParser.VarModifierContext ctx);

    void enterContinueStatement(JavaScriptParser.ContinueStatementContext ctx);

    void exitContinueStatement(JavaScriptParser.ContinueStatementContext ctx);

    void enterBreakStatement(JavaScriptParser.BreakStatementContext ctx);

    void exitBreakStatement(JavaScriptParser.BreakStatementContext ctx);

    void enterReturnStatement(JavaScriptParser.ReturnStatementContext ctx);

    void exitReturnStatement(JavaScriptParser.ReturnStatementContext ctx);

    void enterYieldStatement(JavaScriptParser.YieldStatementContext ctx);

    void exitYieldStatement(JavaScriptParser.YieldStatementContext ctx);

    void enterWithStatement(JavaScriptParser.WithStatementContext ctx);

    void exitWithStatement(JavaScriptParser.WithStatementContext ctx);

    void enterSwitchStatement(JavaScriptParser.SwitchStatementContext ctx);

    void exitSwitchStatement(JavaScriptParser.SwitchStatementContext ctx);

    void enterCaseBlock(JavaScriptParser.CaseBlockContext ctx);

    void exitCaseBlock(JavaScriptParser.CaseBlockContext ctx);

    void enterCaseClauses(JavaScriptParser.CaseClausesContext ctx);

    void exitCaseClauses(JavaScriptParser.CaseClausesContext ctx);

    void enterCaseClause(JavaScriptParser.CaseClauseContext ctx);

    void exitCaseClause(JavaScriptParser.CaseClauseContext ctx);

    void enterDefaultClause(JavaScriptParser.DefaultClauseContext ctx);

    void exitDefaultClause(JavaScriptParser.DefaultClauseContext ctx);

    void enterLabelledStatement(JavaScriptParser.LabelledStatementContext ctx);

    void exitLabelledStatement(JavaScriptParser.LabelledStatementContext ctx);

    void enterThrowStatement(JavaScriptParser.ThrowStatementContext ctx);

    void exitThrowStatement(JavaScriptParser.ThrowStatementContext ctx);

    void enterTryStatement(JavaScriptParser.TryStatementContext ctx);

    void exitTryStatement(JavaScriptParser.TryStatementContext ctx);

    void enterCatchProduction(JavaScriptParser.CatchProductionContext ctx);

    void exitCatchProduction(JavaScriptParser.CatchProductionContext ctx);

    void enterFinallyProduction(JavaScriptParser.FinallyProductionContext ctx);

    void exitFinallyProduction(JavaScriptParser.FinallyProductionContext ctx);

    void enterDebuggerStatement(JavaScriptParser.DebuggerStatementContext ctx);

    void exitDebuggerStatement(JavaScriptParser.DebuggerStatementContext ctx);

    void enterFunctionDeclaration(JavaScriptParser.FunctionDeclarationContext ctx);

    void exitFunctionDeclaration(JavaScriptParser.FunctionDeclarationContext ctx);

    void enterClassDeclaration(JavaScriptParser.ClassDeclarationContext ctx);

    void exitClassDeclaration(JavaScriptParser.ClassDeclarationContext ctx);

    void enterClassTail(JavaScriptParser.ClassTailContext ctx);

    void exitClassTail(JavaScriptParser.ClassTailContext ctx);

    void enterClassElement(JavaScriptParser.ClassElementContext ctx);

    void exitClassElement(JavaScriptParser.ClassElementContext ctx);

    void enterMethodDefinition(JavaScriptParser.MethodDefinitionContext ctx);

    void exitMethodDefinition(JavaScriptParser.MethodDefinitionContext ctx);

    void enterFormalParameterList(JavaScriptParser.FormalParameterListContext ctx);

    void exitFormalParameterList(JavaScriptParser.FormalParameterListContext ctx);

    void enterFormalParameterArg(JavaScriptParser.FormalParameterArgContext ctx);

    void exitFormalParameterArg(JavaScriptParser.FormalParameterArgContext ctx);

    void enterLastFormalParameterArg(JavaScriptParser.LastFormalParameterArgContext ctx);

    void exitLastFormalParameterArg(JavaScriptParser.LastFormalParameterArgContext ctx);

    void enterFunctionBody(JavaScriptParser.FunctionBodyContext ctx);

    void exitFunctionBody(JavaScriptParser.FunctionBodyContext ctx);

    void enterSourceElements(JavaScriptParser.SourceElementsContext ctx);

    void exitSourceElements(JavaScriptParser.SourceElementsContext ctx);

    void enterArrayLiteral(JavaScriptParser.ArrayLiteralContext ctx);

    void exitArrayLiteral(JavaScriptParser.ArrayLiteralContext ctx);

    void enterElementList(JavaScriptParser.ElementListContext ctx);

    void exitElementList(JavaScriptParser.ElementListContext ctx);

    void enterArrayElement(JavaScriptParser.ArrayElementContext ctx);

    void exitArrayElement(JavaScriptParser.ArrayElementContext ctx);

    void enterPropertyExpressionAssignment(JavaScriptParser.PropertyExpressionAssignmentContext ctx);

    void exitPropertyExpressionAssignment(JavaScriptParser.PropertyExpressionAssignmentContext ctx);

    void enterComputedPropertyExpressionAssignment(JavaScriptParser.ComputedPropertyExpressionAssignmentContext ctx);

    void exitComputedPropertyExpressionAssignment(JavaScriptParser.ComputedPropertyExpressionAssignmentContext ctx);

    void enterFunctionProperty(JavaScriptParser.FunctionPropertyContext ctx);

    void exitFunctionProperty(JavaScriptParser.FunctionPropertyContext ctx);

    void enterPropertyGetter(JavaScriptParser.PropertyGetterContext ctx);

    void exitPropertyGetter(JavaScriptParser.PropertyGetterContext ctx);

    void enterPropertySetter(JavaScriptParser.PropertySetterContext ctx);

    void exitPropertySetter(JavaScriptParser.PropertySetterContext ctx);

    void enterPropertyShorthand(JavaScriptParser.PropertyShorthandContext ctx);

    void exitPropertyShorthand(JavaScriptParser.PropertyShorthandContext ctx);

    void enterPropertyName(JavaScriptParser.PropertyNameContext ctx);

    void exitPropertyName(JavaScriptParser.PropertyNameContext ctx);

    void enterArguments(JavaScriptParser.ArgumentsContext ctx);

    void exitArguments(JavaScriptParser.ArgumentsContext ctx);

    void enterArgument(JavaScriptParser.ArgumentContext ctx);

    void exitArgument(JavaScriptParser.ArgumentContext ctx);

    void enterExpressionSequence(JavaScriptParser.ExpressionSequenceContext ctx);

    void exitExpressionSequence(JavaScriptParser.ExpressionSequenceContext ctx);

    void enterTemplateStringExpression(JavaScriptParser.TemplateStringExpressionContext ctx);

    void exitTemplateStringExpression(JavaScriptParser.TemplateStringExpressionContext ctx);

    void enterTernaryExpression(JavaScriptParser.TernaryExpressionContext ctx);

    void exitTernaryExpression(JavaScriptParser.TernaryExpressionContext ctx);

    void enterLogicalAndExpression(JavaScriptParser.LogicalAndExpressionContext ctx);

    void exitLogicalAndExpression(JavaScriptParser.LogicalAndExpressionContext ctx);

    void enterPowerExpression(JavaScriptParser.PowerExpressionContext ctx);

    void exitPowerExpression(JavaScriptParser.PowerExpressionContext ctx);

    void enterPreIncrementExpression(JavaScriptParser.PreIncrementExpressionContext ctx);

    void exitPreIncrementExpression(JavaScriptParser.PreIncrementExpressionContext ctx);

    void enterObjectLiteralExpression(JavaScriptParser.ObjectLiteralExpressionContext ctx);

    void exitObjectLiteralExpression(JavaScriptParser.ObjectLiteralExpressionContext ctx);

    void enterMetaExpression(JavaScriptParser.MetaExpressionContext ctx);

    void exitMetaExpression(JavaScriptParser.MetaExpressionContext ctx);

    void enterInExpression(JavaScriptParser.InExpressionContext ctx);

    void exitInExpression(JavaScriptParser.InExpressionContext ctx);

    void enterLogicalOrExpression(JavaScriptParser.LogicalOrExpressionContext ctx);

    void exitLogicalOrExpression(JavaScriptParser.LogicalOrExpressionContext ctx);

    void enterNotExpression(JavaScriptParser.NotExpressionContext ctx);

    void exitNotExpression(JavaScriptParser.NotExpressionContext ctx);

    void enterPreDecreaseExpression(JavaScriptParser.PreDecreaseExpressionContext ctx);

    void exitPreDecreaseExpression(JavaScriptParser.PreDecreaseExpressionContext ctx);

    void enterArgumentsExpression(JavaScriptParser.ArgumentsExpressionContext ctx);

    void exitArgumentsExpression(JavaScriptParser.ArgumentsExpressionContext ctx);

    void enterAwaitExpression(JavaScriptParser.AwaitExpressionContext ctx);

    void exitAwaitExpression(JavaScriptParser.AwaitExpressionContext ctx);

    void enterThisExpression(JavaScriptParser.ThisExpressionContext ctx);

    void exitThisExpression(JavaScriptParser.ThisExpressionContext ctx);

    void enterFunctionExpression(JavaScriptParser.FunctionExpressionContext ctx);

    void exitFunctionExpression(JavaScriptParser.FunctionExpressionContext ctx);

    void enterUnaryMinusExpression(JavaScriptParser.UnaryMinusExpressionContext ctx);

    void exitUnaryMinusExpression(JavaScriptParser.UnaryMinusExpressionContext ctx);

    void enterAssignmentExpression(JavaScriptParser.AssignmentExpressionContext ctx);

    void exitAssignmentExpression(JavaScriptParser.AssignmentExpressionContext ctx);

    void enterPostDecreaseExpression(JavaScriptParser.PostDecreaseExpressionContext ctx);

    void exitPostDecreaseExpression(JavaScriptParser.PostDecreaseExpressionContext ctx);

    void enterTypeofExpression(JavaScriptParser.TypeofExpressionContext ctx);

    void exitTypeofExpression(JavaScriptParser.TypeofExpressionContext ctx);

    void enterInstanceofExpression(JavaScriptParser.InstanceofExpressionContext ctx);

    void exitInstanceofExpression(JavaScriptParser.InstanceofExpressionContext ctx);

    void enterUnaryPlusExpression(JavaScriptParser.UnaryPlusExpressionContext ctx);

    void exitUnaryPlusExpression(JavaScriptParser.UnaryPlusExpressionContext ctx);

    void enterDeleteExpression(JavaScriptParser.DeleteExpressionContext ctx);

    void exitDeleteExpression(JavaScriptParser.DeleteExpressionContext ctx);

    void enterImportExpression(JavaScriptParser.ImportExpressionContext ctx);

    void exitImportExpression(JavaScriptParser.ImportExpressionContext ctx);

    void enterEqualityExpression(JavaScriptParser.EqualityExpressionContext ctx);

    void exitEqualityExpression(JavaScriptParser.EqualityExpressionContext ctx);

    void enterBitXOrExpression(JavaScriptParser.BitXOrExpressionContext ctx);

    void exitBitXOrExpression(JavaScriptParser.BitXOrExpressionContext ctx);

    void enterSuperExpression(JavaScriptParser.SuperExpressionContext ctx);

    void exitSuperExpression(JavaScriptParser.SuperExpressionContext ctx);

    void enterMultiplicativeExpression(JavaScriptParser.MultiplicativeExpressionContext ctx);

    void exitMultiplicativeExpression(JavaScriptParser.MultiplicativeExpressionContext ctx);

    void enterBitShiftExpression(JavaScriptParser.BitShiftExpressionContext ctx);

    void exitBitShiftExpression(JavaScriptParser.BitShiftExpressionContext ctx);

    void enterParenthesizedExpression(JavaScriptParser.ParenthesizedExpressionContext ctx);

    void exitParenthesizedExpression(JavaScriptParser.ParenthesizedExpressionContext ctx);

    void enterAdditiveExpression(JavaScriptParser.AdditiveExpressionContext ctx);

    void exitAdditiveExpression(JavaScriptParser.AdditiveExpressionContext ctx);

    void enterRelationalExpression(JavaScriptParser.RelationalExpressionContext ctx);

    void exitRelationalExpression(JavaScriptParser.RelationalExpressionContext ctx);

    void enterPostIncrementExpression(JavaScriptParser.PostIncrementExpressionContext ctx);

    void exitPostIncrementExpression(JavaScriptParser.PostIncrementExpressionContext ctx);

    void enterYieldExpression(JavaScriptParser.YieldExpressionContext ctx);

    void exitYieldExpression(JavaScriptParser.YieldExpressionContext ctx);

    void enterBitNotExpression(JavaScriptParser.BitNotExpressionContext ctx);

    void exitBitNotExpression(JavaScriptParser.BitNotExpressionContext ctx);

    void enterNewExpression(JavaScriptParser.NewExpressionContext ctx);

    void exitNewExpression(JavaScriptParser.NewExpressionContext ctx);

    void enterLiteralExpression(JavaScriptParser.LiteralExpressionContext ctx);

    void exitLiteralExpression(JavaScriptParser.LiteralExpressionContext ctx);

    void enterArrayLiteralExpression(JavaScriptParser.ArrayLiteralExpressionContext ctx);

    void exitArrayLiteralExpression(JavaScriptParser.ArrayLiteralExpressionContext ctx);

    void enterMemberDotExpression(JavaScriptParser.MemberDotExpressionContext ctx);

    void exitMemberDotExpression(JavaScriptParser.MemberDotExpressionContext ctx);

    void enterClassExpression(JavaScriptParser.ClassExpressionContext ctx);

    void exitClassExpression(JavaScriptParser.ClassExpressionContext ctx);

    void enterMemberIndexExpression(JavaScriptParser.MemberIndexExpressionContext ctx);

    void exitMemberIndexExpression(JavaScriptParser.MemberIndexExpressionContext ctx);

    void enterIdentifierExpression(JavaScriptParser.IdentifierExpressionContext ctx);

    void exitIdentifierExpression(JavaScriptParser.IdentifierExpressionContext ctx);

    void enterBitAndExpression(JavaScriptParser.BitAndExpressionContext ctx);

    void exitBitAndExpression(JavaScriptParser.BitAndExpressionContext ctx);

    void enterBitOrExpression(JavaScriptParser.BitOrExpressionContext ctx);

    void exitBitOrExpression(JavaScriptParser.BitOrExpressionContext ctx);

    void enterAssignmentOperatorExpression(JavaScriptParser.AssignmentOperatorExpressionContext ctx);

    void exitAssignmentOperatorExpression(JavaScriptParser.AssignmentOperatorExpressionContext ctx);

    void enterVoidExpression(JavaScriptParser.VoidExpressionContext ctx);

    void exitVoidExpression(JavaScriptParser.VoidExpressionContext ctx);

    void enterCoalesceExpression(JavaScriptParser.CoalesceExpressionContext ctx);

    void exitCoalesceExpression(JavaScriptParser.CoalesceExpressionContext ctx);

    void enterAssignable(JavaScriptParser.AssignableContext ctx);

    void exitAssignable(JavaScriptParser.AssignableContext ctx);

    void enterObjectLiteral(JavaScriptParser.ObjectLiteralContext ctx);

    void exitObjectLiteral(JavaScriptParser.ObjectLiteralContext ctx);

    void enterFunctionDecl(JavaScriptParser.FunctionDeclContext ctx);

    void exitFunctionDecl(JavaScriptParser.FunctionDeclContext ctx);

    void enterAnonymousFunctionDecl(JavaScriptParser.AnonymousFunctionDeclContext ctx);

    void exitAnonymousFunctionDecl(JavaScriptParser.AnonymousFunctionDeclContext ctx);

    void enterArrowFunction(JavaScriptParser.ArrowFunctionContext ctx);

    void exitArrowFunction(JavaScriptParser.ArrowFunctionContext ctx);

    void enterArrowFunctionParameters(JavaScriptParser.ArrowFunctionParametersContext ctx);

    void exitArrowFunctionParameters(JavaScriptParser.ArrowFunctionParametersContext ctx);

    void enterArrowFunctionBody(JavaScriptParser.ArrowFunctionBodyContext ctx);

    void exitArrowFunctionBody(JavaScriptParser.ArrowFunctionBodyContext ctx);

    void enterAssignmentOperator(JavaScriptParser.AssignmentOperatorContext ctx);

    void exitAssignmentOperator(JavaScriptParser.AssignmentOperatorContext ctx);

    void enterLiteral(JavaScriptParser.LiteralContext ctx);

    void exitLiteral(JavaScriptParser.LiteralContext ctx);

    void enterTemplateStringLiteral(JavaScriptParser.TemplateStringLiteralContext ctx);

    void exitTemplateStringLiteral(JavaScriptParser.TemplateStringLiteralContext ctx);

    void enterTemplateStringAtom(JavaScriptParser.TemplateStringAtomContext ctx);

    void exitTemplateStringAtom(JavaScriptParser.TemplateStringAtomContext ctx);

    void enterNumericLiteral(JavaScriptParser.NumericLiteralContext ctx);

    void exitNumericLiteral(JavaScriptParser.NumericLiteralContext ctx);

    void enterBigintLiteral(JavaScriptParser.BigintLiteralContext ctx);

    void exitBigintLiteral(JavaScriptParser.BigintLiteralContext ctx);

    void enterGetter(JavaScriptParser.GetterContext ctx);

    void exitGetter(JavaScriptParser.GetterContext ctx);

    void enterSetter(JavaScriptParser.SetterContext ctx);

    void exitSetter(JavaScriptParser.SetterContext ctx);

    void enterIdentifierName(JavaScriptParser.IdentifierNameContext ctx);

    void exitIdentifierName(JavaScriptParser.IdentifierNameContext ctx);

    void enterIdentifier(JavaScriptParser.IdentifierContext ctx);

    void exitIdentifier(JavaScriptParser.IdentifierContext ctx);

    void enterReservedWord(JavaScriptParser.ReservedWordContext ctx);

    void exitReservedWord(JavaScriptParser.ReservedWordContext ctx);

    void enterKeyword(JavaScriptParser.KeywordContext ctx);

    void exitKeyword(JavaScriptParser.KeywordContext ctx);

    void enterLet_(JavaScriptParser.Let_Context ctx);

    void exitLet_(JavaScriptParser.Let_Context ctx);

    void enterEos(JavaScriptParser.EosContext ctx);

    void exitEos(JavaScriptParser.EosContext ctx);
}
