package one.gfw.antlr4.sql.postgresql;

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public interface PostgreSQLParserVisitor<T> extends ParseTreeVisitor<T> {

    T visitRoot(PostgreSQLParser.RootContext ctx);

    T visitPlsqlroot(PostgreSQLParser.PlsqlrootContext ctx);

    T visitStmtblock(PostgreSQLParser.StmtblockContext ctx);

    T visitStmtmulti(PostgreSQLParser.StmtmultiContext ctx);

    T visitStmt(PostgreSQLParser.StmtContext ctx);

    T visitPlsqlconsolecommand(PostgreSQLParser.PlsqlconsolecommandContext ctx);

    T visitCallstmt(PostgreSQLParser.CallstmtContext ctx);

    T visitCreaterolestmt(PostgreSQLParser.CreaterolestmtContext ctx);

    T visitOpt_with(PostgreSQLParser.Opt_withContext ctx);

    T visitOptrolelist(PostgreSQLParser.OptrolelistContext ctx);

    T visitAlteroptrolelist(PostgreSQLParser.AlteroptrolelistContext ctx);

    T visitAlteroptroleelem(PostgreSQLParser.AlteroptroleelemContext ctx);

    T visitCreateoptroleelem(PostgreSQLParser.CreateoptroleelemContext ctx);

    T visitCreateuserstmt(PostgreSQLParser.CreateuserstmtContext ctx);

    T visitAlterrolestmt(PostgreSQLParser.AlterrolestmtContext ctx);

    T visitOpt_in_database(PostgreSQLParser.Opt_in_databaseContext ctx);

    T visitAlterrolesetstmt(PostgreSQLParser.AlterrolesetstmtContext ctx);

    T visitDroprolestmt(PostgreSQLParser.DroprolestmtContext ctx);

    T visitCreategroupstmt(PostgreSQLParser.CreategroupstmtContext ctx);

    T visitAltergroupstmt(PostgreSQLParser.AltergroupstmtContext ctx);

    T visitAdd_drop(PostgreSQLParser.Add_dropContext ctx);

    T visitCreateschemastmt(PostgreSQLParser.CreateschemastmtContext ctx);

    T visitOptschemaname(PostgreSQLParser.OptschemanameContext ctx);

    T visitOptschemaeltlist(PostgreSQLParser.OptschemaeltlistContext ctx);

    T visitSchema_stmt(PostgreSQLParser.Schema_stmtContext ctx);

    T visitVariablesetstmt(PostgreSQLParser.VariablesetstmtContext ctx);

    T visitSet_rest(PostgreSQLParser.Set_restContext ctx);

    T visitGeneric_set(PostgreSQLParser.Generic_setContext ctx);

    T visitSet_rest_more(PostgreSQLParser.Set_rest_moreContext ctx);

    T visitVar_name(PostgreSQLParser.Var_nameContext ctx);

    T visitVar_list(PostgreSQLParser.Var_listContext ctx);

    T visitVar_value(PostgreSQLParser.Var_valueContext ctx);

    T visitIso_level(PostgreSQLParser.Iso_levelContext ctx);

    T visitOpt_boolean_or_string(PostgreSQLParser.Opt_boolean_or_stringContext ctx);

    T visitZone_value(PostgreSQLParser.Zone_valueContext ctx);

    T visitOpt_encoding(PostgreSQLParser.Opt_encodingContext ctx);

    T visitNonreservedword_or_sconst(PostgreSQLParser.Nonreservedword_or_sconstContext ctx);

    T visitVariableresetstmt(PostgreSQLParser.VariableresetstmtContext ctx);

    T visitReset_rest(PostgreSQLParser.Reset_restContext ctx);

    T visitGeneric_reset(PostgreSQLParser.Generic_resetContext ctx);

    T visitSetresetclause(PostgreSQLParser.SetresetclauseContext ctx);

    T visitFunctionsetresetclause(PostgreSQLParser.FunctionsetresetclauseContext ctx);

    T visitVariableshowstmt(PostgreSQLParser.VariableshowstmtContext ctx);

    T visitConstraintssetstmt(PostgreSQLParser.ConstraintssetstmtContext ctx);

    T visitConstraints_set_list(PostgreSQLParser.Constraints_set_listContext ctx);

    T visitConstraints_set_mode(PostgreSQLParser.Constraints_set_modeContext ctx);

    T visitCheckpointstmt(PostgreSQLParser.CheckpointstmtContext ctx);

    T visitDiscardstmt(PostgreSQLParser.DiscardstmtContext ctx);

    T visitAltertablestmt(PostgreSQLParser.AltertablestmtContext ctx);

    T visitAlter_table_cmds(PostgreSQLParser.Alter_table_cmdsContext ctx);

    T visitPartition_cmd(PostgreSQLParser.Partition_cmdContext ctx);

    T visitIndex_partition_cmd(PostgreSQLParser.Index_partition_cmdContext ctx);

    T visitAlter_table_cmd(PostgreSQLParser.Alter_table_cmdContext ctx);

    T visitAlter_column_default(PostgreSQLParser.Alter_column_defaultContext ctx);

    T visitOpt_drop_behavior(PostgreSQLParser.Opt_drop_behaviorContext ctx);

    T visitOpt_collate_clause(PostgreSQLParser.Opt_collate_clauseContext ctx);

    T visitAlter_using(PostgreSQLParser.Alter_usingContext ctx);

    T visitReplica_identity(PostgreSQLParser.Replica_identityContext ctx);

    T visitReloptions(PostgreSQLParser.ReloptionsContext ctx);

    T visitOpt_reloptions(PostgreSQLParser.Opt_reloptionsContext ctx);

    T visitReloption_list(PostgreSQLParser.Reloption_listContext ctx);

    T visitReloption_elem(PostgreSQLParser.Reloption_elemContext ctx);

    T visitAlter_identity_column_option_list(PostgreSQLParser.Alter_identity_column_option_listContext ctx);

    T visitAlter_identity_column_option(PostgreSQLParser.Alter_identity_column_optionContext ctx);

    T visitPartitionboundspec(PostgreSQLParser.PartitionboundspecContext ctx);

    T visitHash_partbound_elem(PostgreSQLParser.Hash_partbound_elemContext ctx);

    T visitHash_partbound(PostgreSQLParser.Hash_partboundContext ctx);

    T visitAltercompositetypestmt(PostgreSQLParser.AltercompositetypestmtContext ctx);

    T visitAlter_type_cmds(PostgreSQLParser.Alter_type_cmdsContext ctx);

    T visitAlter_type_cmd(PostgreSQLParser.Alter_type_cmdContext ctx);

    T visitCloseportalstmt(PostgreSQLParser.CloseportalstmtContext ctx);

    T visitCopystmt(PostgreSQLParser.CopystmtContext ctx);

    T visitCopy_from(PostgreSQLParser.Copy_fromContext ctx);

    T visitOpt_program(PostgreSQLParser.Opt_programContext ctx);

    T visitCopy_file_name(PostgreSQLParser.Copy_file_nameContext ctx);

    T visitCopy_options(PostgreSQLParser.Copy_optionsContext ctx);

    T visitCopy_opt_list(PostgreSQLParser.Copy_opt_listContext ctx);

    T visitCopy_opt_item(PostgreSQLParser.Copy_opt_itemContext ctx);

    T visitOpt_binary(PostgreSQLParser.Opt_binaryContext ctx);

    T visitCopy_delimiter(PostgreSQLParser.Copy_delimiterContext ctx);

    T visitOpt_using(PostgreSQLParser.Opt_usingContext ctx);

    T visitCopy_generic_opt_list(PostgreSQLParser.Copy_generic_opt_listContext ctx);

    T visitCopy_generic_opt_elem(PostgreSQLParser.Copy_generic_opt_elemContext ctx);

    T visitCopy_generic_opt_arg(PostgreSQLParser.Copy_generic_opt_argContext ctx);

    T visitCopy_generic_opt_arg_list(PostgreSQLParser.Copy_generic_opt_arg_listContext ctx);

    T visitCopy_generic_opt_arg_list_item(PostgreSQLParser.Copy_generic_opt_arg_list_itemContext ctx);

    T visitCreatestmt(PostgreSQLParser.CreatestmtContext ctx);

    T visitOpttemp(PostgreSQLParser.OpttempContext ctx);

    T visitOpttableelementlist(PostgreSQLParser.OpttableelementlistContext ctx);

    T visitOpttypedtableelementlist(PostgreSQLParser.OpttypedtableelementlistContext ctx);

    T visitTableelementlist(PostgreSQLParser.TableelementlistContext ctx);

    T visitTypedtableelementlist(PostgreSQLParser.TypedtableelementlistContext ctx);

    T visitTableelement(PostgreSQLParser.TableelementContext ctx);

    T visitTypedtableelement(PostgreSQLParser.TypedtableelementContext ctx);

    T visitColumnDef(PostgreSQLParser.ColumnDefContext ctx);

    T visitColumnOptions(PostgreSQLParser.ColumnOptionsContext ctx);

    T visitColquallist(PostgreSQLParser.ColquallistContext ctx);

    T visitColconstraint(PostgreSQLParser.ColconstraintContext ctx);

    T visitColconstraintelem(PostgreSQLParser.ColconstraintelemContext ctx);

    T visitGenerated_when(PostgreSQLParser.Generated_whenContext ctx);

    T visitConstraintattr(PostgreSQLParser.ConstraintattrContext ctx);

    T visitTablelikeclause(PostgreSQLParser.TablelikeclauseContext ctx);

    T visitTablelikeoptionlist(PostgreSQLParser.TablelikeoptionlistContext ctx);

    T visitTablelikeoption(PostgreSQLParser.TablelikeoptionContext ctx);

    T visitTableconstraint(PostgreSQLParser.TableconstraintContext ctx);

    T visitConstraintelem(PostgreSQLParser.ConstraintelemContext ctx);

    T visitOpt_no_inherit(PostgreSQLParser.Opt_no_inheritContext ctx);

    T visitOpt_column_list(PostgreSQLParser.Opt_column_listContext ctx);

    T visitColumnlist(PostgreSQLParser.ColumnlistContext ctx);

    T visitColumnElem(PostgreSQLParser.ColumnElemContext ctx);

    T visitOpt_c_include(PostgreSQLParser.Opt_c_includeContext ctx);

    T visitKey_match(PostgreSQLParser.Key_matchContext ctx);

    T visitExclusionconstraintlist(PostgreSQLParser.ExclusionconstraintlistContext ctx);

    T visitExclusionconstraintelem(PostgreSQLParser.ExclusionconstraintelemContext ctx);

    T visitExclusionwhereclause(PostgreSQLParser.ExclusionwhereclauseContext ctx);

    T visitKey_actions(PostgreSQLParser.Key_actionsContext ctx);

    T visitKey_update(PostgreSQLParser.Key_updateContext ctx);

    T visitKey_delete(PostgreSQLParser.Key_deleteContext ctx);

    T visitKey_action(PostgreSQLParser.Key_actionContext ctx);

    T visitOptinherit(PostgreSQLParser.OptinheritContext ctx);

    T visitOptpartitionspec(PostgreSQLParser.OptpartitionspecContext ctx);

    T visitPartitionspec(PostgreSQLParser.PartitionspecContext ctx);

    T visitPart_params(PostgreSQLParser.Part_paramsContext ctx);

    T visitPart_elem(PostgreSQLParser.Part_elemContext ctx);

    T visitTable_access_method_clause(PostgreSQLParser.Table_access_method_clauseContext ctx);

    T visitOptwith(PostgreSQLParser.OptwithContext ctx);

    T visitOncommitoption(PostgreSQLParser.OncommitoptionContext ctx);

    T visitOpttablespace(PostgreSQLParser.OpttablespaceContext ctx);

    T visitOptconstablespace(PostgreSQLParser.OptconstablespaceContext ctx);

    T visitExistingindex(PostgreSQLParser.ExistingindexContext ctx);

    T visitCreatestatsstmt(PostgreSQLParser.CreatestatsstmtContext ctx);

    T visitAlterstatsstmt(PostgreSQLParser.AlterstatsstmtContext ctx);

    T visitCreateasstmt(PostgreSQLParser.CreateasstmtContext ctx);

    T visitCreate_as_target(PostgreSQLParser.Create_as_targetContext ctx);

    T visitOpt_with_data(PostgreSQLParser.Opt_with_dataContext ctx);

    T visitCreatematviewstmt(PostgreSQLParser.CreatematviewstmtContext ctx);

    T visitCreate_mv_target(PostgreSQLParser.Create_mv_targetContext ctx);

    T visitOptnolog(PostgreSQLParser.OptnologContext ctx);

    T visitRefreshmatviewstmt(PostgreSQLParser.RefreshmatviewstmtContext ctx);

    T visitCreateseqstmt(PostgreSQLParser.CreateseqstmtContext ctx);

    T visitAlterseqstmt(PostgreSQLParser.AlterseqstmtContext ctx);

    T visitOptseqoptlist(PostgreSQLParser.OptseqoptlistContext ctx);

    T visitOptparenthesizedseqoptlist(PostgreSQLParser.OptparenthesizedseqoptlistContext ctx);

    T visitSeqoptlist(PostgreSQLParser.SeqoptlistContext ctx);

    T visitSeqoptelem(PostgreSQLParser.SeqoptelemContext ctx);

    T visitOpt_by(PostgreSQLParser.Opt_byContext ctx);

    T visitNumericonly(PostgreSQLParser.NumericonlyContext ctx);

    T visitNumericonly_list(PostgreSQLParser.Numericonly_listContext ctx);

    T visitCreateplangstmt(PostgreSQLParser.CreateplangstmtContext ctx);

    T visitOpt_trusted(PostgreSQLParser.Opt_trustedContext ctx);

    T visitHandler_name(PostgreSQLParser.Handler_nameContext ctx);

    T visitOpt_inline_handler(PostgreSQLParser.Opt_inline_handlerContext ctx);

    T visitValidator_clause(PostgreSQLParser.Validator_clauseContext ctx);

    T visitOpt_validator(PostgreSQLParser.Opt_validatorContext ctx);

    T visitOpt_procedural(PostgreSQLParser.Opt_proceduralContext ctx);

    T visitCreatetablespacestmt(PostgreSQLParser.CreatetablespacestmtContext ctx);

    T visitOpttablespaceowner(PostgreSQLParser.OpttablespaceownerContext ctx);

    T visitDroptablespacestmt(PostgreSQLParser.DroptablespacestmtContext ctx);

    T visitCreateextensionstmt(PostgreSQLParser.CreateextensionstmtContext ctx);

    T visitCreate_extension_opt_list(PostgreSQLParser.Create_extension_opt_listContext ctx);

    T visitCreate_extension_opt_item(PostgreSQLParser.Create_extension_opt_itemContext ctx);

    T visitAlterextensionstmt(PostgreSQLParser.AlterextensionstmtContext ctx);

    T visitAlter_extension_opt_list(PostgreSQLParser.Alter_extension_opt_listContext ctx);

    T visitAlter_extension_opt_item(PostgreSQLParser.Alter_extension_opt_itemContext ctx);

    T visitAlterextensioncontentsstmt(PostgreSQLParser.AlterextensioncontentsstmtContext ctx);

    T visitCreatefdwstmt(PostgreSQLParser.CreatefdwstmtContext ctx);

    T visitFdw_option(PostgreSQLParser.Fdw_optionContext ctx);

    T visitFdw_options(PostgreSQLParser.Fdw_optionsContext ctx);

    T visitOpt_fdw_options(PostgreSQLParser.Opt_fdw_optionsContext ctx);

    T visitAlterfdwstmt(PostgreSQLParser.AlterfdwstmtContext ctx);

    T visitCreate_generic_options(PostgreSQLParser.Create_generic_optionsContext ctx);

    T visitGeneric_option_list(PostgreSQLParser.Generic_option_listContext ctx);

    T visitAlter_generic_options(PostgreSQLParser.Alter_generic_optionsContext ctx);

    T visitAlter_generic_option_list(PostgreSQLParser.Alter_generic_option_listContext ctx);

    T visitAlter_generic_option_elem(PostgreSQLParser.Alter_generic_option_elemContext ctx);

    T visitGeneric_option_elem(PostgreSQLParser.Generic_option_elemContext ctx);

    T visitGeneric_option_name(PostgreSQLParser.Generic_option_nameContext ctx);

    T visitGeneric_option_arg(PostgreSQLParser.Generic_option_argContext ctx);

    T visitCreateforeignserverstmt(PostgreSQLParser.CreateforeignserverstmtContext ctx);

    T visitOpt_type(PostgreSQLParser.Opt_typeContext ctx);

    T visitForeign_server_version(PostgreSQLParser.Foreign_server_versionContext ctx);

    T visitOpt_foreign_server_version(PostgreSQLParser.Opt_foreign_server_versionContext ctx);

    T visitAlterforeignserverstmt(PostgreSQLParser.AlterforeignserverstmtContext ctx);

    T visitCreateforeigntablestmt(PostgreSQLParser.CreateforeigntablestmtContext ctx);

    T visitImportforeignschemastmt(PostgreSQLParser.ImportforeignschemastmtContext ctx);

    T visitImport_qualification_type(PostgreSQLParser.Import_qualification_typeContext ctx);

    T visitImport_qualification(PostgreSQLParser.Import_qualificationContext ctx);

    T visitCreateusermappingstmt(PostgreSQLParser.CreateusermappingstmtContext ctx);

    T visitAuth_ident(PostgreSQLParser.Auth_identContext ctx);

    T visitDropusermappingstmt(PostgreSQLParser.DropusermappingstmtContext ctx);

    T visitAlterusermappingstmt(PostgreSQLParser.AlterusermappingstmtContext ctx);

    T visitCreatepolicystmt(PostgreSQLParser.CreatepolicystmtContext ctx);

    T visitAlterpolicystmt(PostgreSQLParser.AlterpolicystmtContext ctx);

    T visitRowsecurityoptionalexpr(PostgreSQLParser.RowsecurityoptionalexprContext ctx);

    T visitRowsecurityoptionalwithcheck(PostgreSQLParser.RowsecurityoptionalwithcheckContext ctx);

    T visitRowsecuritydefaulttorole(PostgreSQLParser.RowsecuritydefaulttoroleContext ctx);

    T visitRowsecurityoptionaltorole(PostgreSQLParser.RowsecurityoptionaltoroleContext ctx);

    T visitRowsecuritydefaultpermissive(PostgreSQLParser.RowsecuritydefaultpermissiveContext ctx);

    T visitRowsecuritydefaultforcmd(PostgreSQLParser.RowsecuritydefaultforcmdContext ctx);

    T visitRow_security_cmd(PostgreSQLParser.Row_security_cmdContext ctx);

    T visitCreateamstmt(PostgreSQLParser.CreateamstmtContext ctx);

    T visitAm_type(PostgreSQLParser.Am_typeContext ctx);

    T visitCreatetrigstmt(PostgreSQLParser.CreatetrigstmtContext ctx);

    T visitTriggeractiontime(PostgreSQLParser.TriggeractiontimeContext ctx);

    T visitTriggerevents(PostgreSQLParser.TriggereventsContext ctx);

    T visitTriggeroneevent(PostgreSQLParser.TriggeroneeventContext ctx);

    T visitTriggerreferencing(PostgreSQLParser.TriggerreferencingContext ctx);

    T visitTriggertransitions(PostgreSQLParser.TriggertransitionsContext ctx);

    T visitTriggertransition(PostgreSQLParser.TriggertransitionContext ctx);

    T visitTransitionoldornew(PostgreSQLParser.TransitionoldornewContext ctx);

    T visitTransitionrowortable(PostgreSQLParser.TransitionrowortableContext ctx);

    T visitTransitionrelname(PostgreSQLParser.TransitionrelnameContext ctx);

    T visitTriggerforspec(PostgreSQLParser.TriggerforspecContext ctx);

    T visitTriggerforopteach(PostgreSQLParser.TriggerforopteachContext ctx);

    T visitTriggerfortype(PostgreSQLParser.TriggerfortypeContext ctx);

    T visitTriggerwhen(PostgreSQLParser.TriggerwhenContext ctx);

    T visitFunction_or_procedure(PostgreSQLParser.Function_or_procedureContext ctx);

    T visitTriggerfuncargs(PostgreSQLParser.TriggerfuncargsContext ctx);

    T visitTriggerfuncarg(PostgreSQLParser.TriggerfuncargContext ctx);

    T visitOptconstrfromtable(PostgreSQLParser.OptconstrfromtableContext ctx);

    T visitConstraintattributespec(PostgreSQLParser.ConstraintattributespecContext ctx);

    T visitConstraintattributeElem(PostgreSQLParser.ConstraintattributeElemContext ctx);

    T visitCreateeventtrigstmt(PostgreSQLParser.CreateeventtrigstmtContext ctx);

    T visitEvent_trigger_when_list(PostgreSQLParser.Event_trigger_when_listContext ctx);

    T visitEvent_trigger_when_item(PostgreSQLParser.Event_trigger_when_itemContext ctx);

    T visitEvent_trigger_value_list(PostgreSQLParser.Event_trigger_value_listContext ctx);

    T visitAltereventtrigstmt(PostgreSQLParser.AltereventtrigstmtContext ctx);

    T visitEnable_trigger(PostgreSQLParser.Enable_triggerContext ctx);

    T visitCreateassertionstmt(PostgreSQLParser.CreateassertionstmtContext ctx);

    T visitDefinestmt(PostgreSQLParser.DefinestmtContext ctx);

    T visitDefinition(PostgreSQLParser.DefinitionContext ctx);

    T visitDef_list(PostgreSQLParser.Def_listContext ctx);

    T visitDef_elem(PostgreSQLParser.Def_elemContext ctx);

    T visitDef_arg(PostgreSQLParser.Def_argContext ctx);

    T visitOld_aggr_definition(PostgreSQLParser.Old_aggr_definitionContext ctx);

    T visitOld_aggr_list(PostgreSQLParser.Old_aggr_listContext ctx);

    T visitOld_aggr_elem(PostgreSQLParser.Old_aggr_elemContext ctx);

    T visitOpt_enum_val_list(PostgreSQLParser.Opt_enum_val_listContext ctx);

    T visitEnum_val_list(PostgreSQLParser.Enum_val_listContext ctx);

    T visitAlterenumstmt(PostgreSQLParser.AlterenumstmtContext ctx);

    T visitOpt_if_not_exists(PostgreSQLParser.Opt_if_not_existsContext ctx);

    T visitCreateopclassstmt(PostgreSQLParser.CreateopclassstmtContext ctx);

    T visitOpclass_item_list(PostgreSQLParser.Opclass_item_listContext ctx);

    T visitOpclass_item(PostgreSQLParser.Opclass_itemContext ctx);

    T visitOpt_default(PostgreSQLParser.Opt_defaultContext ctx);

    T visitOpt_opfamily(PostgreSQLParser.Opt_opfamilyContext ctx);

    T visitOpclass_purpose(PostgreSQLParser.Opclass_purposeContext ctx);

    T visitOpt_recheck(PostgreSQLParser.Opt_recheckContext ctx);

    T visitCreateopfamilystmt(PostgreSQLParser.CreateopfamilystmtContext ctx);

    T visitAlteropfamilystmt(PostgreSQLParser.AlteropfamilystmtContext ctx);

    T visitOpclass_drop_list(PostgreSQLParser.Opclass_drop_listContext ctx);

    T visitOpclass_drop(PostgreSQLParser.Opclass_dropContext ctx);

    T visitDropopclassstmt(PostgreSQLParser.DropopclassstmtContext ctx);

    T visitDropopfamilystmt(PostgreSQLParser.DropopfamilystmtContext ctx);

    T visitDropownedstmt(PostgreSQLParser.DropownedstmtContext ctx);

    T visitReassignownedstmt(PostgreSQLParser.ReassignownedstmtContext ctx);

    T visitDropstmt(PostgreSQLParser.DropstmtContext ctx);

    T visitObject_type_any_name(PostgreSQLParser.Object_type_any_nameContext ctx);

    T visitObject_type_name(PostgreSQLParser.Object_type_nameContext ctx);

    T visitDrop_type_name(PostgreSQLParser.Drop_type_nameContext ctx);

    T visitObject_type_name_on_any_name(PostgreSQLParser.Object_type_name_on_any_nameContext ctx);

    T visitAny_name_list(PostgreSQLParser.Any_name_listContext ctx);

    T visitAny_name(PostgreSQLParser.Any_nameContext ctx);

    T visitAttrs(PostgreSQLParser.AttrsContext ctx);

    T visitType_name_list(PostgreSQLParser.Type_name_listContext ctx);

    T visitTruncatestmt(PostgreSQLParser.TruncatestmtContext ctx);

    T visitOpt_restart_seqs(PostgreSQLParser.Opt_restart_seqsContext ctx);

    T visitCommentstmt(PostgreSQLParser.CommentstmtContext ctx);

    T visitComment_text(PostgreSQLParser.Comment_textContext ctx);

    T visitSeclabelstmt(PostgreSQLParser.SeclabelstmtContext ctx);

    T visitOpt_provider(PostgreSQLParser.Opt_providerContext ctx);

    T visitSecurity_label(PostgreSQLParser.Security_labelContext ctx);

    T visitFetchstmt(PostgreSQLParser.FetchstmtContext ctx);

    T visitFetch_args(PostgreSQLParser.Fetch_argsContext ctx);

    T visitFrom_in(PostgreSQLParser.From_inContext ctx);

    T visitOpt_from_in(PostgreSQLParser.Opt_from_inContext ctx);

    T visitGrantstmt(PostgreSQLParser.GrantstmtContext ctx);

    T visitRevokestmt(PostgreSQLParser.RevokestmtContext ctx);

    T visitPrivileges(PostgreSQLParser.PrivilegesContext ctx);

    T visitPrivilege_list(PostgreSQLParser.Privilege_listContext ctx);

    T visitPrivilege(PostgreSQLParser.PrivilegeContext ctx);

    T visitPrivilege_target(PostgreSQLParser.Privilege_targetContext ctx);

    T visitGrantee_list(PostgreSQLParser.Grantee_listContext ctx);

    T visitGrantee(PostgreSQLParser.GranteeContext ctx);

    T visitOpt_grant_grant_option(PostgreSQLParser.Opt_grant_grant_optionContext ctx);

    T visitGrantrolestmt(PostgreSQLParser.GrantrolestmtContext ctx);

    T visitRevokerolestmt(PostgreSQLParser.RevokerolestmtContext ctx);

    T visitOpt_grant_admin_option(PostgreSQLParser.Opt_grant_admin_optionContext ctx);

    T visitOpt_granted_by(PostgreSQLParser.Opt_granted_byContext ctx);

    T visitAlterdefaultprivilegesstmt(PostgreSQLParser.AlterdefaultprivilegesstmtContext ctx);

    T visitDefacloptionlist(PostgreSQLParser.DefacloptionlistContext ctx);

    T visitDefacloption(PostgreSQLParser.DefacloptionContext ctx);

    T visitDefaclaction(PostgreSQLParser.DefaclactionContext ctx);

    T visitDefacl_privilege_target(PostgreSQLParser.Defacl_privilege_targetContext ctx);

    T visitIndexstmt(PostgreSQLParser.IndexstmtContext ctx);

    T visitOpt_unique(PostgreSQLParser.Opt_uniqueContext ctx);

    T visitOpt_concurrently(PostgreSQLParser.Opt_concurrentlyContext ctx);

    T visitOpt_index_name(PostgreSQLParser.Opt_index_nameContext ctx);

    T visitAccess_method_clause(PostgreSQLParser.Access_method_clauseContext ctx);

    T visitIndex_params(PostgreSQLParser.Index_paramsContext ctx);

    T visitIndex_elem_options(PostgreSQLParser.Index_elem_optionsContext ctx);

    T visitIndex_elem(PostgreSQLParser.Index_elemContext ctx);

    T visitOpt_include(PostgreSQLParser.Opt_includeContext ctx);

    T visitIndex_including_params(PostgreSQLParser.Index_including_paramsContext ctx);

    T visitOpt_collate(PostgreSQLParser.Opt_collateContext ctx);

    T visitOpt_class(PostgreSQLParser.Opt_classContext ctx);

    T visitOpt_asc_desc(PostgreSQLParser.Opt_asc_descContext ctx);

    T visitOpt_nulls_order(PostgreSQLParser.Opt_nulls_orderContext ctx);

    T visitCreatefunctionstmt(PostgreSQLParser.CreatefunctionstmtContext ctx);

    T visitOpt_or_replace(PostgreSQLParser.Opt_or_replaceContext ctx);

    T visitFunc_args(PostgreSQLParser.Func_argsContext ctx);

    T visitFunc_args_list(PostgreSQLParser.Func_args_listContext ctx);

    T visitFunction_with_argtypes_list(PostgreSQLParser.Function_with_argtypes_listContext ctx);

    T visitFunction_with_argtypes(PostgreSQLParser.Function_with_argtypesContext ctx);

    T visitFunc_args_with_defaults(PostgreSQLParser.Func_args_with_defaultsContext ctx);

    T visitFunc_args_with_defaults_list(PostgreSQLParser.Func_args_with_defaults_listContext ctx);

    T visitFunc_arg(PostgreSQLParser.Func_argContext ctx);

    T visitArg_class(PostgreSQLParser.Arg_classContext ctx);

    T visitParam_name(PostgreSQLParser.Param_nameContext ctx);

    T visitFunc_return(PostgreSQLParser.Func_returnContext ctx);

    T visitFunc_type(PostgreSQLParser.Func_typeContext ctx);

    T visitFunc_arg_with_default(PostgreSQLParser.Func_arg_with_defaultContext ctx);

    T visitAggr_arg(PostgreSQLParser.Aggr_argContext ctx);

    T visitAggr_args(PostgreSQLParser.Aggr_argsContext ctx);

    T visitAggr_args_list(PostgreSQLParser.Aggr_args_listContext ctx);

    T visitAggregate_with_argtypes(PostgreSQLParser.Aggregate_with_argtypesContext ctx);

    T visitAggregate_with_argtypes_list(PostgreSQLParser.Aggregate_with_argtypes_listContext ctx);

    T visitCreatefunc_opt_list(PostgreSQLParser.Createfunc_opt_listContext ctx);

    T visitCommon_func_opt_item(PostgreSQLParser.Common_func_opt_itemContext ctx);

    T visitCreatefunc_opt_item(PostgreSQLParser.Createfunc_opt_itemContext ctx);

    T visitFunc_as(PostgreSQLParser.Func_asContext ctx);

    T visitTransform_type_list(PostgreSQLParser.Transform_type_listContext ctx);

    T visitOpt_definition(PostgreSQLParser.Opt_definitionContext ctx);

    T visitTable_func_column(PostgreSQLParser.Table_func_columnContext ctx);

    T visitTable_func_column_list(PostgreSQLParser.Table_func_column_listContext ctx);

    T visitAlterfunctionstmt(PostgreSQLParser.AlterfunctionstmtContext ctx);

    T visitAlterfunc_opt_list(PostgreSQLParser.Alterfunc_opt_listContext ctx);

    T visitOpt_restrict(PostgreSQLParser.Opt_restrictContext ctx);

    T visitRemovefuncstmt(PostgreSQLParser.RemovefuncstmtContext ctx);

    T visitRemoveaggrstmt(PostgreSQLParser.RemoveaggrstmtContext ctx);

    T visitRemoveoperstmt(PostgreSQLParser.RemoveoperstmtContext ctx);

    T visitOper_argtypes(PostgreSQLParser.Oper_argtypesContext ctx);

    T visitAny_operator(PostgreSQLParser.Any_operatorContext ctx);

    T visitOperator_with_argtypes_list(PostgreSQLParser.Operator_with_argtypes_listContext ctx);

    T visitOperator_with_argtypes(PostgreSQLParser.Operator_with_argtypesContext ctx);

    T visitDostmt(PostgreSQLParser.DostmtContext ctx);

    T visitDostmt_opt_list(PostgreSQLParser.Dostmt_opt_listContext ctx);

    T visitDostmt_opt_item(PostgreSQLParser.Dostmt_opt_itemContext ctx);

    T visitCreatecaststmt(PostgreSQLParser.CreatecaststmtContext ctx);

    T visitCast_context(PostgreSQLParser.Cast_contextContext ctx);

    T visitDropcaststmt(PostgreSQLParser.DropcaststmtContext ctx);

    T visitOpt_if_exists(PostgreSQLParser.Opt_if_existsContext ctx);

    T visitCreatetransformstmt(PostgreSQLParser.CreatetransformstmtContext ctx);

    T visitTransform_element_list(PostgreSQLParser.Transform_element_listContext ctx);

    T visitDroptransformstmt(PostgreSQLParser.DroptransformstmtContext ctx);

    T visitReindexstmt(PostgreSQLParser.ReindexstmtContext ctx);

    T visitReindex_target_type(PostgreSQLParser.Reindex_target_typeContext ctx);

    T visitReindex_target_multitable(PostgreSQLParser.Reindex_target_multitableContext ctx);

    T visitReindex_option_list(PostgreSQLParser.Reindex_option_listContext ctx);

    T visitReindex_option_elem(PostgreSQLParser.Reindex_option_elemContext ctx);

    T visitAltertblspcstmt(PostgreSQLParser.AltertblspcstmtContext ctx);

    T visitRenamestmt(PostgreSQLParser.RenamestmtContext ctx);

    T visitOpt_column(PostgreSQLParser.Opt_columnContext ctx);

    T visitOpt_set_data(PostgreSQLParser.Opt_set_dataContext ctx);

    T visitAlterobjectdependsstmt(PostgreSQLParser.AlterobjectdependsstmtContext ctx);

    T visitOpt_no(PostgreSQLParser.Opt_noContext ctx);

    T visitAlterobjectschemastmt(PostgreSQLParser.AlterobjectschemastmtContext ctx);

    T visitAlteroperatorstmt(PostgreSQLParser.AlteroperatorstmtContext ctx);

    T visitOperator_def_list(PostgreSQLParser.Operator_def_listContext ctx);

    T visitOperator_def_elem(PostgreSQLParser.Operator_def_elemContext ctx);

    T visitOperator_def_arg(PostgreSQLParser.Operator_def_argContext ctx);

    T visitAltertypestmt(PostgreSQLParser.AltertypestmtContext ctx);

    T visitAlterownerstmt(PostgreSQLParser.AlterownerstmtContext ctx);

    T visitCreatepublicationstmt(PostgreSQLParser.CreatepublicationstmtContext ctx);

    T visitOpt_publication_for_tables(PostgreSQLParser.Opt_publication_for_tablesContext ctx);

    T visitPublication_for_tables(PostgreSQLParser.Publication_for_tablesContext ctx);

    T visitAlterpublicationstmt(PostgreSQLParser.AlterpublicationstmtContext ctx);

    T visitCreatesubscriptionstmt(PostgreSQLParser.CreatesubscriptionstmtContext ctx);

    T visitPublication_name_list(PostgreSQLParser.Publication_name_listContext ctx);

    T visitPublication_name_item(PostgreSQLParser.Publication_name_itemContext ctx);

    T visitAltersubscriptionstmt(PostgreSQLParser.AltersubscriptionstmtContext ctx);

    T visitDropsubscriptionstmt(PostgreSQLParser.DropsubscriptionstmtContext ctx);

    T visitRulestmt(PostgreSQLParser.RulestmtContext ctx);

    T visitRuleactionlist(PostgreSQLParser.RuleactionlistContext ctx);

    T visitRuleactionmulti(PostgreSQLParser.RuleactionmultiContext ctx);

    T visitRuleactionstmt(PostgreSQLParser.RuleactionstmtContext ctx);

    T visitRuleactionstmtOrEmpty(PostgreSQLParser.RuleactionstmtOrEmptyContext ctx);

    T visitEvent(PostgreSQLParser.EventContext ctx);

    T visitOpt_instead(PostgreSQLParser.Opt_insteadContext ctx);

    T visitNotifystmt(PostgreSQLParser.NotifystmtContext ctx);

    T visitNotify_payload(PostgreSQLParser.Notify_payloadContext ctx);

    T visitListenstmt(PostgreSQLParser.ListenstmtContext ctx);

    T visitUnlistenstmt(PostgreSQLParser.UnlistenstmtContext ctx);

    T visitTransactionstmt(PostgreSQLParser.TransactionstmtContext ctx);

    T visitOpt_transaction(PostgreSQLParser.Opt_transactionContext ctx);

    T visitTransaction_mode_item(PostgreSQLParser.Transaction_mode_itemContext ctx);

    T visitTransaction_mode_list(PostgreSQLParser.Transaction_mode_listContext ctx);

    T visitTransaction_mode_list_or_empty(PostgreSQLParser.Transaction_mode_list_or_emptyContext ctx);

    T visitOpt_transaction_chain(PostgreSQLParser.Opt_transaction_chainContext ctx);

    T visitViewstmt(PostgreSQLParser.ViewstmtContext ctx);

    T visitOpt_check_option(PostgreSQLParser.Opt_check_optionContext ctx);

    T visitLoadstmt(PostgreSQLParser.LoadstmtContext ctx);

    T visitCreatedbstmt(PostgreSQLParser.CreatedbstmtContext ctx);

    T visitCreatedb_opt_list(PostgreSQLParser.Createdb_opt_listContext ctx);

    T visitCreatedb_opt_items(PostgreSQLParser.Createdb_opt_itemsContext ctx);

    T visitCreatedb_opt_item(PostgreSQLParser.Createdb_opt_itemContext ctx);

    T visitCreatedb_opt_name(PostgreSQLParser.Createdb_opt_nameContext ctx);

    T visitOpt_equal(PostgreSQLParser.Opt_equalContext ctx);

    T visitAlterdatabasestmt(PostgreSQLParser.AlterdatabasestmtContext ctx);

    T visitAlterdatabasesetstmt(PostgreSQLParser.AlterdatabasesetstmtContext ctx);

    T visitDropdbstmt(PostgreSQLParser.DropdbstmtContext ctx);

    T visitDrop_option_list(PostgreSQLParser.Drop_option_listContext ctx);

    T visitDrop_option(PostgreSQLParser.Drop_optionContext ctx);

    T visitAltercollationstmt(PostgreSQLParser.AltercollationstmtContext ctx);

    T visitAltersystemstmt(PostgreSQLParser.AltersystemstmtContext ctx);

    T visitCreatedomainstmt(PostgreSQLParser.CreatedomainstmtContext ctx);

    T visitAlterdomainstmt(PostgreSQLParser.AlterdomainstmtContext ctx);

    T visitOpt_as(PostgreSQLParser.Opt_asContext ctx);

    T visitAltertsdictionarystmt(PostgreSQLParser.AltertsdictionarystmtContext ctx);

    T visitAltertsconfigurationstmt(PostgreSQLParser.AltertsconfigurationstmtContext ctx);

    T visitAny_with(PostgreSQLParser.Any_withContext ctx);

    T visitCreateconversionstmt(PostgreSQLParser.CreateconversionstmtContext ctx);

    T visitClusterstmt(PostgreSQLParser.ClusterstmtContext ctx);

    T visitCluster_index_specification(PostgreSQLParser.Cluster_index_specificationContext ctx);

    T visitVacuumstmt(PostgreSQLParser.VacuumstmtContext ctx);

    T visitAnalyzestmt(PostgreSQLParser.AnalyzestmtContext ctx);

    T visitVac_analyze_option_list(PostgreSQLParser.Vac_analyze_option_listContext ctx);

    T visitAnalyze_keyword(PostgreSQLParser.Analyze_keywordContext ctx);

    T visitVac_analyze_option_elem(PostgreSQLParser.Vac_analyze_option_elemContext ctx);

    T visitVac_analyze_option_name(PostgreSQLParser.Vac_analyze_option_nameContext ctx);

    T visitVac_analyze_option_arg(PostgreSQLParser.Vac_analyze_option_argContext ctx);

    T visitOpt_analyze(PostgreSQLParser.Opt_analyzeContext ctx);

    T visitOpt_verbose(PostgreSQLParser.Opt_verboseContext ctx);

    T visitOpt_full(PostgreSQLParser.Opt_fullContext ctx);

    T visitOpt_freeze(PostgreSQLParser.Opt_freezeContext ctx);

    T visitOpt_name_list(PostgreSQLParser.Opt_name_listContext ctx);

    T visitVacuum_relation(PostgreSQLParser.Vacuum_relationContext ctx);

    T visitVacuum_relation_list(PostgreSQLParser.Vacuum_relation_listContext ctx);

    T visitOpt_vacuum_relation_list(PostgreSQLParser.Opt_vacuum_relation_listContext ctx);

    T visitExplainstmt(PostgreSQLParser.ExplainstmtContext ctx);

    T visitExplainablestmt(PostgreSQLParser.ExplainablestmtContext ctx);

    T visitExplain_option_list(PostgreSQLParser.Explain_option_listContext ctx);

    T visitExplain_option_elem(PostgreSQLParser.Explain_option_elemContext ctx);

    T visitExplain_option_name(PostgreSQLParser.Explain_option_nameContext ctx);

    T visitExplain_option_arg(PostgreSQLParser.Explain_option_argContext ctx);

    T visitPreparestmt(PostgreSQLParser.PreparestmtContext ctx);

    T visitPrep_type_clause(PostgreSQLParser.Prep_type_clauseContext ctx);

    T visitPreparablestmt(PostgreSQLParser.PreparablestmtContext ctx);

    T visitExecutestmt(PostgreSQLParser.ExecutestmtContext ctx);

    T visitExecute_param_clause(PostgreSQLParser.Execute_param_clauseContext ctx);

    T visitDeallocatestmt(PostgreSQLParser.DeallocatestmtContext ctx);

    T visitInsertstmt(PostgreSQLParser.InsertstmtContext ctx);

    T visitInsert_target(PostgreSQLParser.Insert_targetContext ctx);

    T visitInsert_rest(PostgreSQLParser.Insert_restContext ctx);

    T visitOverride_kind(PostgreSQLParser.Override_kindContext ctx);

    T visitInsert_column_list(PostgreSQLParser.Insert_column_listContext ctx);

    T visitInsert_column_item(PostgreSQLParser.Insert_column_itemContext ctx);

    T visitOpt_on_conflict(PostgreSQLParser.Opt_on_conflictContext ctx);

    T visitOpt_conf_expr(PostgreSQLParser.Opt_conf_exprContext ctx);

    T visitReturning_clause(PostgreSQLParser.Returning_clauseContext ctx);

    T visitDeletestmt(PostgreSQLParser.DeletestmtContext ctx);

    T visitUsing_clause(PostgreSQLParser.Using_clauseContext ctx);

    T visitLockstmt(PostgreSQLParser.LockstmtContext ctx);

    T visitOpt_lock(PostgreSQLParser.Opt_lockContext ctx);

    T visitLock_type(PostgreSQLParser.Lock_typeContext ctx);

    T visitOpt_nowait(PostgreSQLParser.Opt_nowaitContext ctx);

    T visitOpt_nowait_or_skip(PostgreSQLParser.Opt_nowait_or_skipContext ctx);

    T visitUpdatestmt(PostgreSQLParser.UpdatestmtContext ctx);

    T visitSet_clause_list(PostgreSQLParser.Set_clause_listContext ctx);

    T visitSet_clause(PostgreSQLParser.Set_clauseContext ctx);

    T visitSet_target(PostgreSQLParser.Set_targetContext ctx);

    T visitSet_target_list(PostgreSQLParser.Set_target_listContext ctx);

    T visitDeclarecursorstmt(PostgreSQLParser.DeclarecursorstmtContext ctx);

    T visitCursor_name(PostgreSQLParser.Cursor_nameContext ctx);

    T visitCursor_options(PostgreSQLParser.Cursor_optionsContext ctx);

    T visitOpt_hold(PostgreSQLParser.Opt_holdContext ctx);

    T visitSelectstmt(PostgreSQLParser.SelectstmtContext ctx);

    T visitSelect_with_parens(PostgreSQLParser.Select_with_parensContext ctx);

    T visitSelect_no_parens(PostgreSQLParser.Select_no_parensContext ctx);

    T visitSelect_clause(PostgreSQLParser.Select_clauseContext ctx);

    T visitSimple_select(PostgreSQLParser.Simple_selectContext ctx);

    T visitUnion(PostgreSQLParser.UnionContext ctx);

    T visitIntersect(PostgreSQLParser.IntersectContext ctx);

    T visitExcept(PostgreSQLParser.ExceptContext ctx);

    T visitSet_operator_with_all_or_distinct(PostgreSQLParser.Set_operator_with_all_or_distinctContext ctx);

    T visitWith_clause(PostgreSQLParser.With_clauseContext ctx);

    T visitCte_list(PostgreSQLParser.Cte_listContext ctx);

    T visitCommon_table_expr(PostgreSQLParser.Common_table_exprContext ctx);

    T visitOpt_materialized(PostgreSQLParser.Opt_materializedContext ctx);

    T visitOpt_with_clause(PostgreSQLParser.Opt_with_clauseContext ctx);

    T visitInto_clause(PostgreSQLParser.Into_clauseContext ctx);

    T visitOpt_strict(PostgreSQLParser.Opt_strictContext ctx);

    T visitOpttempTableName(PostgreSQLParser.OpttempTableNameContext ctx);

    T visitOpt_table(PostgreSQLParser.Opt_tableContext ctx);

    T visitAll_or_distinct(PostgreSQLParser.All_or_distinctContext ctx);

    T visitDistinct_clause(PostgreSQLParser.Distinct_clauseContext ctx);

    T visitOpt_all_clause(PostgreSQLParser.Opt_all_clauseContext ctx);

    T visitOpt_sort_clause(PostgreSQLParser.Opt_sort_clauseContext ctx);

    T visitSort_clause(PostgreSQLParser.Sort_clauseContext ctx);

    T visitSortby_list(PostgreSQLParser.Sortby_listContext ctx);

    T visitSortby(PostgreSQLParser.SortbyContext ctx);

    T visitSelect_limit(PostgreSQLParser.Select_limitContext ctx);

    T visitOpt_select_limit(PostgreSQLParser.Opt_select_limitContext ctx);

    T visitLimit_clause(PostgreSQLParser.Limit_clauseContext ctx);

    T visitOffset_clause(PostgreSQLParser.Offset_clauseContext ctx);

    T visitSelect_limit_value(PostgreSQLParser.Select_limit_valueContext ctx);

    T visitSelect_offset_value(PostgreSQLParser.Select_offset_valueContext ctx);

    T visitSelect_fetch_first_value(PostgreSQLParser.Select_fetch_first_valueContext ctx);

    T visitI_or_f_const(PostgreSQLParser.I_or_f_constContext ctx);

    T visitRow_or_rows(PostgreSQLParser.Row_or_rowsContext ctx);

    T visitFirst_or_next(PostgreSQLParser.First_or_nextContext ctx);

    T visitGroup_clause(PostgreSQLParser.Group_clauseContext ctx);

    T visitGroup_by_list(PostgreSQLParser.Group_by_listContext ctx);

    T visitGroup_by_item(PostgreSQLParser.Group_by_itemContext ctx);

    T visitEmpty_grouping_set(PostgreSQLParser.Empty_grouping_setContext ctx);

    T visitRollup_clause(PostgreSQLParser.Rollup_clauseContext ctx);

    T visitCube_clause(PostgreSQLParser.Cube_clauseContext ctx);

    T visitGrouping_sets_clause(PostgreSQLParser.Grouping_sets_clauseContext ctx);

    T visitHaving_clause(PostgreSQLParser.Having_clauseContext ctx);

    T visitFor_locking_clause(PostgreSQLParser.For_locking_clauseContext ctx);

    T visitOpt_for_locking_clause(PostgreSQLParser.Opt_for_locking_clauseContext ctx);

    T visitFor_locking_items(PostgreSQLParser.For_locking_itemsContext ctx);

    T visitFor_locking_item(PostgreSQLParser.For_locking_itemContext ctx);

    T visitFor_locking_strength(PostgreSQLParser.For_locking_strengthContext ctx);

    T visitLocked_rels_list(PostgreSQLParser.Locked_rels_listContext ctx);

    T visitValues_clause(PostgreSQLParser.Values_clauseContext ctx);

    T visitFrom_clause(PostgreSQLParser.From_clauseContext ctx);

    T visitFrom_list(PostgreSQLParser.From_listContext ctx);

    T visitTable_ref(PostgreSQLParser.Table_refContext ctx);

    T visitAlias_clause(PostgreSQLParser.Alias_clauseContext ctx);

    T visitOpt_alias_clause(PostgreSQLParser.Opt_alias_clauseContext ctx);

    T visitFunc_alias_clause(PostgreSQLParser.Func_alias_clauseContext ctx);

    T visitJoin_type(PostgreSQLParser.Join_typeContext ctx);

    T visitJoin_qual(PostgreSQLParser.Join_qualContext ctx);

    T visitRelation_expr(PostgreSQLParser.Relation_exprContext ctx);

    T visitRelation_expr_list(PostgreSQLParser.Relation_expr_listContext ctx);

    T visitRelation_expr_opt_alias(PostgreSQLParser.Relation_expr_opt_aliasContext ctx);

    T visitTablesample_clause(PostgreSQLParser.Tablesample_clauseContext ctx);

    T visitOpt_repeatable_clause(PostgreSQLParser.Opt_repeatable_clauseContext ctx);

    T visitFunc_table(PostgreSQLParser.Func_tableContext ctx);

    T visitRowsfrom_item(PostgreSQLParser.Rowsfrom_itemContext ctx);

    T visitRowsfrom_list(PostgreSQLParser.Rowsfrom_listContext ctx);

    T visitOpt_col_def_list(PostgreSQLParser.Opt_col_def_listContext ctx);

    T visitOpt_ordinality(PostgreSQLParser.Opt_ordinalityContext ctx);

    T visitWhere_clause(PostgreSQLParser.Where_clauseContext ctx);

    T visitWhere_or_current_clause(PostgreSQLParser.Where_or_current_clauseContext ctx);

    T visitOpttablefuncelementlist(PostgreSQLParser.OpttablefuncelementlistContext ctx);

    T visitTablefuncelementlist(PostgreSQLParser.TablefuncelementlistContext ctx);

    T visitTablefuncelement(PostgreSQLParser.TablefuncelementContext ctx);

    T visitXmltable(PostgreSQLParser.XmltableContext ctx);

    T visitXmltable_column_list(PostgreSQLParser.Xmltable_column_listContext ctx);

    T visitXmltable_column_el(PostgreSQLParser.Xmltable_column_elContext ctx);

    T visitXmltable_column_option_list(PostgreSQLParser.Xmltable_column_option_listContext ctx);

    T visitXmltable_column_option_el(PostgreSQLParser.Xmltable_column_option_elContext ctx);

    T visitXml_namespace_list(PostgreSQLParser.Xml_namespace_listContext ctx);

    T visitXml_namespace_el(PostgreSQLParser.Xml_namespace_elContext ctx);

    T visitTypename(PostgreSQLParser.TypenameContext ctx);

    T visitOpt_array_bounds(PostgreSQLParser.Opt_array_boundsContext ctx);

    T visitSimpletypename(PostgreSQLParser.SimpletypenameContext ctx);

    T visitConsttypename(PostgreSQLParser.ConsttypenameContext ctx);

    T visitGenerictype(PostgreSQLParser.GenerictypeContext ctx);

    T visitOpt_type_modifiers(PostgreSQLParser.Opt_type_modifiersContext ctx);

    T visitNumeric(PostgreSQLParser.NumericContext ctx);

    T visitOpt_float(PostgreSQLParser.Opt_floatContext ctx);

    T visitBit(PostgreSQLParser.BitContext ctx);

    T visitConstbit(PostgreSQLParser.ConstbitContext ctx);

    T visitBitwithlength(PostgreSQLParser.BitwithlengthContext ctx);

    T visitBitwithoutlength(PostgreSQLParser.BitwithoutlengthContext ctx);

    T visitCharacter(PostgreSQLParser.CharacterContext ctx);

    T visitConstcharacter(PostgreSQLParser.ConstcharacterContext ctx);

    T visitCharacter_c(PostgreSQLParser.Character_cContext ctx);

    T visitOpt_varying(PostgreSQLParser.Opt_varyingContext ctx);

    T visitConstdatetime(PostgreSQLParser.ConstdatetimeContext ctx);

    T visitConstinterval(PostgreSQLParser.ConstintervalContext ctx);

    T visitOpt_timezone(PostgreSQLParser.Opt_timezoneContext ctx);

    T visitOpt_interval(PostgreSQLParser.Opt_intervalContext ctx);

    T visitInterval_second(PostgreSQLParser.Interval_secondContext ctx);

    T visitOpt_escape(PostgreSQLParser.Opt_escapeContext ctx);

    T visitA_expr(PostgreSQLParser.A_exprContext ctx);

    T visitA_expr_qual(PostgreSQLParser.A_expr_qualContext ctx);

    T visitA_expr_lessless(PostgreSQLParser.A_expr_lesslessContext ctx);

    T visitA_expr_or(PostgreSQLParser.A_expr_orContext ctx);

    T visitA_expr_and(PostgreSQLParser.A_expr_andContext ctx);

    T visitA_expr_in(PostgreSQLParser.A_expr_inContext ctx);

    T visitA_expr_unary_not(PostgreSQLParser.A_expr_unary_notContext ctx);

    T visitA_expr_isnull(PostgreSQLParser.A_expr_isnullContext ctx);

    T visitA_expr_is_not(PostgreSQLParser.A_expr_is_notContext ctx);

    T visitA_expr_compare(PostgreSQLParser.A_expr_compareContext ctx);

    T visitA_expr_like(PostgreSQLParser.A_expr_likeContext ctx);

    T visitA_expr_qual_op(PostgreSQLParser.A_expr_qual_opContext ctx);

    T visitA_expr_unary_qualop(PostgreSQLParser.A_expr_unary_qualopContext ctx);

    T visitA_expr_add(PostgreSQLParser.A_expr_addContext ctx);

    T visitA_expr_mul(PostgreSQLParser.A_expr_mulContext ctx);

    T visitA_expr_caret(PostgreSQLParser.A_expr_caretContext ctx);

    T visitA_expr_unary_sign(PostgreSQLParser.A_expr_unary_signContext ctx);

    T visitA_expr_at_time_zone(PostgreSQLParser.A_expr_at_time_zoneContext ctx);

    T visitA_expr_collate(PostgreSQLParser.A_expr_collateContext ctx);

    T visitA_expr_typecast(PostgreSQLParser.A_expr_typecastContext ctx);

    T visitB_expr(PostgreSQLParser.B_exprContext ctx);

    T visitC_expr_exists(PostgreSQLParser.C_expr_existsContext ctx);

    T visitC_expr_expr(PostgreSQLParser.C_expr_exprContext ctx);

    T visitC_expr_case(PostgreSQLParser.C_expr_caseContext ctx);

    T visitPlsqlvariablename(PostgreSQLParser.PlsqlvariablenameContext ctx);

    T visitFunc_application(PostgreSQLParser.Func_applicationContext ctx);

    T visitFunc_expr(PostgreSQLParser.Func_exprContext ctx);

    T visitFunc_expr_windowless(PostgreSQLParser.Func_expr_windowlessContext ctx);

    T visitFunc_expr_common_subexpr(PostgreSQLParser.Func_expr_common_subexprContext ctx);

    T visitXml_root_version(PostgreSQLParser.Xml_root_versionContext ctx);

    T visitOpt_xml_root_standalone(PostgreSQLParser.Opt_xml_root_standaloneContext ctx);

    T visitXml_attributes(PostgreSQLParser.Xml_attributesContext ctx);

    T visitXml_attribute_list(PostgreSQLParser.Xml_attribute_listContext ctx);

    T visitXml_attribute_el(PostgreSQLParser.Xml_attribute_elContext ctx);

    T visitDocument_or_content(PostgreSQLParser.Document_or_contentContext ctx);

    T visitXml_whitespace_option(PostgreSQLParser.Xml_whitespace_optionContext ctx);

    T visitXmlexists_argument(PostgreSQLParser.Xmlexists_argumentContext ctx);

    T visitXml_passing_mech(PostgreSQLParser.Xml_passing_mechContext ctx);

    T visitWithin_group_clause(PostgreSQLParser.Within_group_clauseContext ctx);

    T visitFilter_clause(PostgreSQLParser.Filter_clauseContext ctx);

    T visitWindow_clause(PostgreSQLParser.Window_clauseContext ctx);

    T visitWindow_definition_list(PostgreSQLParser.Window_definition_listContext ctx);

    T visitWindow_definition(PostgreSQLParser.Window_definitionContext ctx);

    T visitOver_clause(PostgreSQLParser.Over_clauseContext ctx);

    T visitWindow_specification(PostgreSQLParser.Window_specificationContext ctx);

    T visitOpt_existing_window_name(PostgreSQLParser.Opt_existing_window_nameContext ctx);

    T visitOpt_partition_clause(PostgreSQLParser.Opt_partition_clauseContext ctx);

    T visitOpt_frame_clause(PostgreSQLParser.Opt_frame_clauseContext ctx);

    T visitFrame_extent(PostgreSQLParser.Frame_extentContext ctx);

    T visitFrame_bound(PostgreSQLParser.Frame_boundContext ctx);

    T visitOpt_window_exclusion_clause(PostgreSQLParser.Opt_window_exclusion_clauseContext ctx);

    T visitRow(PostgreSQLParser.RowContext ctx);

    T visitExplicit_row(PostgreSQLParser.Explicit_rowContext ctx);

    T visitImplicit_row(PostgreSQLParser.Implicit_rowContext ctx);

    T visitSub_type(PostgreSQLParser.Sub_typeContext ctx);

    T visitAll_op(PostgreSQLParser.All_opContext ctx);

    T visitMathop(PostgreSQLParser.MathopContext ctx);

    T visitQual_op(PostgreSQLParser.Qual_opContext ctx);

    T visitQual_all_op(PostgreSQLParser.Qual_all_opContext ctx);

    T visitSubquery_Op(PostgreSQLParser.Subquery_OpContext ctx);

    T visitExpr_list(PostgreSQLParser.Expr_listContext ctx);

    T visitFunc_arg_list(PostgreSQLParser.Func_arg_listContext ctx);

    T visitFunc_arg_expr(PostgreSQLParser.Func_arg_exprContext ctx);

    T visitType_list(PostgreSQLParser.Type_listContext ctx);

    T visitArray_expr(PostgreSQLParser.Array_exprContext ctx);

    T visitArray_expr_list(PostgreSQLParser.Array_expr_listContext ctx);

    T visitExtract_list(PostgreSQLParser.Extract_listContext ctx);

    T visitExtract_arg(PostgreSQLParser.Extract_argContext ctx);

    T visitUnicode_normal_form(PostgreSQLParser.Unicode_normal_formContext ctx);

    T visitOverlay_list(PostgreSQLParser.Overlay_listContext ctx);

    T visitPosition_list(PostgreSQLParser.Position_listContext ctx);

    T visitSubstr_list(PostgreSQLParser.Substr_listContext ctx);

    T visitTrim_list(PostgreSQLParser.Trim_listContext ctx);

    T visitIn_expr_select(PostgreSQLParser.In_expr_selectContext ctx);

    T visitIn_expr_list(PostgreSQLParser.In_expr_listContext ctx);

    T visitCase_expr(PostgreSQLParser.Case_exprContext ctx);

    T visitWhen_clause_list(PostgreSQLParser.When_clause_listContext ctx);

    T visitWhen_clause(PostgreSQLParser.When_clauseContext ctx);

    T visitCase_default(PostgreSQLParser.Case_defaultContext ctx);

    T visitCase_arg(PostgreSQLParser.Case_argContext ctx);

    T visitColumnref(PostgreSQLParser.ColumnrefContext ctx);

    T visitIndirection_el(PostgreSQLParser.Indirection_elContext ctx);

    T visitOpt_slice_bound(PostgreSQLParser.Opt_slice_boundContext ctx);

    T visitIndirection(PostgreSQLParser.IndirectionContext ctx);

    T visitOpt_indirection(PostgreSQLParser.Opt_indirectionContext ctx);

    T visitOpt_target_list(PostgreSQLParser.Opt_target_listContext ctx);

    T visitTarget_list(PostgreSQLParser.Target_listContext ctx);

    T visitTarget_label(PostgreSQLParser.Target_labelContext ctx);

    T visitTarget_star(PostgreSQLParser.Target_starContext ctx);

    T visitQualified_name_list(PostgreSQLParser.Qualified_name_listContext ctx);

    T visitQualified_name(PostgreSQLParser.Qualified_nameContext ctx);

    T visitName_list(PostgreSQLParser.Name_listContext ctx);

    T visitName(PostgreSQLParser.NameContext ctx);

    T visitAttr_name(PostgreSQLParser.Attr_nameContext ctx);

    T visitFile_name(PostgreSQLParser.File_nameContext ctx);

    T visitFunc_name(PostgreSQLParser.Func_nameContext ctx);

    T visitAexprconst(PostgreSQLParser.AexprconstContext ctx);

    T visitXconst(PostgreSQLParser.XconstContext ctx);

    T visitBconst(PostgreSQLParser.BconstContext ctx);

    T visitFconst(PostgreSQLParser.FconstContext ctx);

    T visitIconst(PostgreSQLParser.IconstContext ctx);

    T visitSconst(PostgreSQLParser.SconstContext ctx);

    T visitAnysconst(PostgreSQLParser.AnysconstContext ctx);

    T visitOpt_uescape(PostgreSQLParser.Opt_uescapeContext ctx);

    T visitSignediconst(PostgreSQLParser.SignediconstContext ctx);

    T visitRoleid(PostgreSQLParser.RoleidContext ctx);

    T visitRolespec(PostgreSQLParser.RolespecContext ctx);

    T visitRole_list(PostgreSQLParser.Role_listContext ctx);

    T visitColid(PostgreSQLParser.ColidContext ctx);

    T visitType_function_name(PostgreSQLParser.Type_function_nameContext ctx);

    T visitNonreservedword(PostgreSQLParser.NonreservedwordContext ctx);

    T visitCollabel(PostgreSQLParser.CollabelContext ctx);

    T visitIdentifier(PostgreSQLParser.IdentifierContext ctx);

    T visitPlsqlidentifier(PostgreSQLParser.PlsqlidentifierContext ctx);

    T visitUnreserved_keyword(PostgreSQLParser.Unreserved_keywordContext ctx);

    T visitCol_name_keyword(PostgreSQLParser.Col_name_keywordContext ctx);

    T visitType_func_name_keyword(PostgreSQLParser.Type_func_name_keywordContext ctx);

    T visitReserved_keyword(PostgreSQLParser.Reserved_keywordContext ctx);

    T visitPl_function(PostgreSQLParser.Pl_functionContext ctx);

    T visitComp_options(PostgreSQLParser.Comp_optionsContext ctx);

    T visitComp_option(PostgreSQLParser.Comp_optionContext ctx);

    T visitSharp(PostgreSQLParser.SharpContext ctx);

    T visitOption_value(PostgreSQLParser.Option_valueContext ctx);

    T visitOpt_semi(PostgreSQLParser.Opt_semiContext ctx);

    T visitPl_block(PostgreSQLParser.Pl_blockContext ctx);

    T visitDecl_sect(PostgreSQLParser.Decl_sectContext ctx);

    T visitDecl_start(PostgreSQLParser.Decl_startContext ctx);

    T visitDecl_stmts(PostgreSQLParser.Decl_stmtsContext ctx);

    T visitLabel_decl(PostgreSQLParser.Label_declContext ctx);

    T visitDecl_stmt(PostgreSQLParser.Decl_stmtContext ctx);

    T visitDecl_statement(PostgreSQLParser.Decl_statementContext ctx);

    T visitOpt_scrollable(PostgreSQLParser.Opt_scrollableContext ctx);

    T visitDecl_cursor_query(PostgreSQLParser.Decl_cursor_queryContext ctx);

    T visitDecl_cursor_args(PostgreSQLParser.Decl_cursor_argsContext ctx);

    T visitDecl_cursor_arglist(PostgreSQLParser.Decl_cursor_arglistContext ctx);

    T visitDecl_cursor_arg(PostgreSQLParser.Decl_cursor_argContext ctx);

    T visitDecl_is_for(PostgreSQLParser.Decl_is_forContext ctx);

    T visitDecl_aliasitem(PostgreSQLParser.Decl_aliasitemContext ctx);

    T visitDecl_varname(PostgreSQLParser.Decl_varnameContext ctx);

    T visitDecl_const(PostgreSQLParser.Decl_constContext ctx);

    T visitDecl_datatype(PostgreSQLParser.Decl_datatypeContext ctx);

    T visitDecl_collate(PostgreSQLParser.Decl_collateContext ctx);

    T visitDecl_notnull(PostgreSQLParser.Decl_notnullContext ctx);

    T visitDecl_defval(PostgreSQLParser.Decl_defvalContext ctx);

    T visitDecl_defkey(PostgreSQLParser.Decl_defkeyContext ctx);

    T visitAssign_operator(PostgreSQLParser.Assign_operatorContext ctx);

    T visitProc_sect(PostgreSQLParser.Proc_sectContext ctx);

    T visitProc_stmt(PostgreSQLParser.Proc_stmtContext ctx);

    T visitStmt_perform(PostgreSQLParser.Stmt_performContext ctx);

    T visitStmt_call(PostgreSQLParser.Stmt_callContext ctx);

    T visitOpt_expr_list(PostgreSQLParser.Opt_expr_listContext ctx);

    T visitStmt_assign(PostgreSQLParser.Stmt_assignContext ctx);

    T visitStmt_getdiag(PostgreSQLParser.Stmt_getdiagContext ctx);

    T visitGetdiag_area_opt(PostgreSQLParser.Getdiag_area_optContext ctx);

    T visitGetdiag_list(PostgreSQLParser.Getdiag_listContext ctx);

    T visitGetdiag_list_item(PostgreSQLParser.Getdiag_list_itemContext ctx);

    T visitGetdiag_item(PostgreSQLParser.Getdiag_itemContext ctx);

    T visitGetdiag_target(PostgreSQLParser.Getdiag_targetContext ctx);

    T visitAssign_var(PostgreSQLParser.Assign_varContext ctx);

    T visitStmt_if(PostgreSQLParser.Stmt_ifContext ctx);

    T visitStmt_elsifs(PostgreSQLParser.Stmt_elsifsContext ctx);

    T visitStmt_else(PostgreSQLParser.Stmt_elseContext ctx);

    T visitStmt_case(PostgreSQLParser.Stmt_caseContext ctx);

    T visitOpt_expr_until_when(PostgreSQLParser.Opt_expr_until_whenContext ctx);

    T visitCase_when_list(PostgreSQLParser.Case_when_listContext ctx);

    T visitCase_when(PostgreSQLParser.Case_whenContext ctx);

    T visitOpt_case_else(PostgreSQLParser.Opt_case_elseContext ctx);

    T visitStmt_loop(PostgreSQLParser.Stmt_loopContext ctx);

    T visitStmt_while(PostgreSQLParser.Stmt_whileContext ctx);

    T visitStmt_for(PostgreSQLParser.Stmt_forContext ctx);

    T visitFor_control(PostgreSQLParser.For_controlContext ctx);

    T visitOpt_for_using_expression(PostgreSQLParser.Opt_for_using_expressionContext ctx);

    T visitOpt_cursor_parameters(PostgreSQLParser.Opt_cursor_parametersContext ctx);

    T visitOpt_reverse(PostgreSQLParser.Opt_reverseContext ctx);

    T visitOpt_by_expression(PostgreSQLParser.Opt_by_expressionContext ctx);

    T visitFor_variable(PostgreSQLParser.For_variableContext ctx);

    T visitStmt_foreach_a(PostgreSQLParser.Stmt_foreach_aContext ctx);

    T visitForeach_slice(PostgreSQLParser.Foreach_sliceContext ctx);

    T visitStmt_exit(PostgreSQLParser.Stmt_exitContext ctx);

    T visitExit_type(PostgreSQLParser.Exit_typeContext ctx);

    T visitStmt_return(PostgreSQLParser.Stmt_returnContext ctx);

    T visitOpt_return_result(PostgreSQLParser.Opt_return_resultContext ctx);

    T visitStmt_raise(PostgreSQLParser.Stmt_raiseContext ctx);

    T visitOpt_stmt_raise_level(PostgreSQLParser.Opt_stmt_raise_levelContext ctx);

    T visitOpt_raise_list(PostgreSQLParser.Opt_raise_listContext ctx);

    T visitOpt_raise_using(PostgreSQLParser.Opt_raise_usingContext ctx);

    T visitOpt_raise_using_elem(PostgreSQLParser.Opt_raise_using_elemContext ctx);

    T visitOpt_raise_using_elem_list(PostgreSQLParser.Opt_raise_using_elem_listContext ctx);

    T visitStmt_assert(PostgreSQLParser.Stmt_assertContext ctx);

    T visitOpt_stmt_assert_message(PostgreSQLParser.Opt_stmt_assert_messageContext ctx);

    T visitLoop_body(PostgreSQLParser.Loop_bodyContext ctx);

    T visitStmt_execsql(PostgreSQLParser.Stmt_execsqlContext ctx);

    T visitStmt_dynexecute(PostgreSQLParser.Stmt_dynexecuteContext ctx);

    T visitOpt_execute_using(PostgreSQLParser.Opt_execute_usingContext ctx);

    T visitOpt_execute_using_list(PostgreSQLParser.Opt_execute_using_listContext ctx);

    T visitOpt_execute_into(PostgreSQLParser.Opt_execute_intoContext ctx);

    T visitStmt_open(PostgreSQLParser.Stmt_openContext ctx);

    T visitOpt_open_bound_list_item(PostgreSQLParser.Opt_open_bound_list_itemContext ctx);

    T visitOpt_open_bound_list(PostgreSQLParser.Opt_open_bound_listContext ctx);

    T visitOpt_open_using(PostgreSQLParser.Opt_open_usingContext ctx);

    T visitOpt_scroll_option(PostgreSQLParser.Opt_scroll_optionContext ctx);

    T visitOpt_scroll_option_no(PostgreSQLParser.Opt_scroll_option_noContext ctx);

    T visitStmt_fetch(PostgreSQLParser.Stmt_fetchContext ctx);

    T visitInto_target(PostgreSQLParser.Into_targetContext ctx);

    T visitOpt_cursor_from(PostgreSQLParser.Opt_cursor_fromContext ctx);

    T visitOpt_fetch_direction(PostgreSQLParser.Opt_fetch_directionContext ctx);

    T visitStmt_move(PostgreSQLParser.Stmt_moveContext ctx);

    T visitStmt_close(PostgreSQLParser.Stmt_closeContext ctx);

    T visitStmt_null(PostgreSQLParser.Stmt_nullContext ctx);

    T visitStmt_commit(PostgreSQLParser.Stmt_commitContext ctx);

    T visitStmt_rollback(PostgreSQLParser.Stmt_rollbackContext ctx);

    T visitPlsql_opt_transaction_chain(PostgreSQLParser.Plsql_opt_transaction_chainContext ctx);

    T visitStmt_set(PostgreSQLParser.Stmt_setContext ctx);

    T visitCursor_variable(PostgreSQLParser.Cursor_variableContext ctx);

    T visitException_sect(PostgreSQLParser.Exception_sectContext ctx);

    T visitProc_exceptions(PostgreSQLParser.Proc_exceptionsContext ctx);

    T visitProc_exception(PostgreSQLParser.Proc_exceptionContext ctx);

    T visitProc_conditions(PostgreSQLParser.Proc_conditionsContext ctx);

    T visitProc_condition(PostgreSQLParser.Proc_conditionContext ctx);

    T visitOpt_block_label(PostgreSQLParser.Opt_block_labelContext ctx);

    T visitOpt_loop_label(PostgreSQLParser.Opt_loop_labelContext ctx);

    T visitOpt_label(PostgreSQLParser.Opt_labelContext ctx);

    T visitOpt_exitcond(PostgreSQLParser.Opt_exitcondContext ctx);

    T visitAny_identifier(PostgreSQLParser.Any_identifierContext ctx);

    T visitPlsql_unreserved_keyword(PostgreSQLParser.Plsql_unreserved_keywordContext ctx);

    T visitSql_expression(PostgreSQLParser.Sql_expressionContext ctx);

    T visitExpr_until_then(PostgreSQLParser.Expr_until_thenContext ctx);

    T visitExpr_until_semi(PostgreSQLParser.Expr_until_semiContext ctx);

    T visitExpr_until_rightbracket(PostgreSQLParser.Expr_until_rightbracketContext ctx);

    T visitExpr_until_loop(PostgreSQLParser.Expr_until_loopContext ctx);

    T visitMake_execsql_stmt(PostgreSQLParser.Make_execsql_stmtContext ctx);

    T visitOpt_returning_clause_into(PostgreSQLParser.Opt_returning_clause_intoContext ctx);
}
