/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d;

import java.awt.geom.AffineTransform;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.GeometricObject2D;
import one.gfw.geom.math.geom2d.NonInvertibleTransform2DException;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.Vector2D;
import one.gfw.geom.math.geom2d.line.LinearShape2D;
import one.gfw.geom.math.geom2d.transform.Bijection2D;
import one.gfw.geom.math.utils.EqualUtils;

public class AffineTransform2D
implements Bijection2D,
GeometricObject2D,
Cloneable {
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m10;
    protected double m11;
    protected double m12;

    public static AffineTransform2D createIdentity() {
        return new AffineTransform2D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public static AffineTransform2D create(AffineTransform2D trans) {
        return new AffineTransform2D(trans.m00, trans.m01, trans.m02, trans.m10, trans.m11, trans.m12);
    }

    public static AffineTransform2D create(double[] coefs) {
        if (coefs.length == 4) {
            return new AffineTransform2D(coefs[0], coefs[1], 0.0, coefs[2], coefs[3], 0.0);
        }
        if (coefs.length == 6) {
            return new AffineTransform2D(coefs[0], coefs[1], coefs[2], coefs[3], coefs[4], coefs[5]);
        }
        throw new IllegalArgumentException("Input array must have either 4 or 6 elements");
    }

    public static AffineTransform2D create(double xx, double yx, double tx, double xy, double yy, double ty) {
        return new AffineTransform2D(xx, yx, tx, xy, yy, ty);
    }

    public static AffineTransform2D createGlideReflection(LinearShape2D line, double distance) {
        Vector2D vector = line.direction().normalize();
        Point2D origin = line.origin();
        double dx = vector.x();
        double dy = vector.y();
        double x0 = origin.x();
        double y0 = origin.y();
        double tx = dx * distance;
        double ty = dy * distance;
        double delta = dx * dx + dy * dy;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dxy = dx * dy;
        double dxy0 = dx * y0;
        double dyx0 = dy * x0;
        return new AffineTransform2D((dx2 - dy2) / delta, 2.0 * dxy / delta, 2.0 * dy * (dyx0 - dxy0) / delta + tx, 2.0 * dxy / delta, (dy2 - dx2) / delta, 2.0 * dx * (dxy0 - dyx0) / delta + ty);
    }

    @Deprecated
    public static AffineTransform2D createHomothecy(Point2D center, double k) {
        return AffineTransform2D.createScaling(center, k, k);
    }

    public static AffineTransform2D createLineReflection(LinearShape2D line) {
        Point2D origin = line.origin();
        Vector2D vector = line.direction();
        double dx = vector.x();
        double dy = vector.y();
        double x0 = origin.x();
        double y0 = origin.y();
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dxy = dx * dy;
        double delta = dx2 + dy2;
        return new AffineTransform2D((dx2 - dy2) / delta, 2.0 * dxy / delta, 2.0 * (dy2 * x0 - dxy * y0) / delta, 2.0 * dxy / delta, (dy2 - dx2) / delta, 2.0 * (dx2 * y0 - dxy * x0) / delta);
    }

    public static AffineTransform2D createPointReflection(Point2D center) {
        return AffineTransform2D.createScaling(center, -1.0, -1.0);
    }

    public static AffineTransform2D createQuadrantRotation(int numQuadrant) {
        int n = (numQuadrant % 4 + 4) % 4;
        switch (n) {
            case 0: {
                return new AffineTransform2D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            }
            case 1: {
                return new AffineTransform2D(0.0, -1.0, 0.0, 1.0, 0.0, 0.0);
            }
            case 2: {
                return new AffineTransform2D(-1.0, 0.0, 0.0, 0.0, -1.0, 0.0);
            }
            case 3: {
                return new AffineTransform2D(0.0, 1.0, 0.0, -1.0, 0.0, 0.0);
            }
        }
        throw new RuntimeException("Error in integer rounding...");
    }

    public static AffineTransform2D createQuadrantRotation(Point2D center, int numQuadrant) {
        AffineTransform2D trans = AffineTransform2D.createQuadrantRotation(numQuadrant);
        trans.recenter(center.x(), center.y());
        return trans;
    }

    public static AffineTransform2D createQuadrantRotation(double x0, double y0, int numQuadrant) {
        AffineTransform2D trans = AffineTransform2D.createQuadrantRotation(numQuadrant);
        trans.recenter(x0, y0);
        return trans;
    }

    public static AffineTransform2D createRotation(double angle) {
        return AffineTransform2D.createRotation(0.0, 0.0, angle);
    }

    public static AffineTransform2D createRotation(Point2D center, double angle) {
        return AffineTransform2D.createRotation(center.x(), center.y(), angle);
    }

    public static AffineTransform2D createRotation(double cx, double cy, double angle) {
        int k = (int)Math.round((angle = Angle2D.formatAngle(angle)) * 2.0 / Math.PI);
        if (Math.abs((double)k * Math.PI / 2.0 - angle) < 1.0E-12) {
            return AffineTransform2D.createQuadrantRotation(cx, cy, k);
        }
        double cot = Math.cos(angle);
        double sit = Math.sin(angle);
        return new AffineTransform2D(cot, -sit, (1.0 - cot) * cx + sit * cy, sit, cot, (1.0 - cot) * cy - sit * cx);
    }

    public static AffineTransform2D createScaling(double sx, double sy) {
        return AffineTransform2D.createScaling(new Point2D(0.0, 0.0), sx, sy);
    }

    public static AffineTransform2D createScaling(Point2D center, double sx, double sy) {
        return new AffineTransform2D(sx, 0.0, (1.0 - sx) * center.x(), 0.0, sy, (1.0 - sy) * center.y());
    }

    public static AffineTransform2D createShear(double shx, double shy) {
        return new AffineTransform2D(1.0, shx, 0.0, shy, 1.0, 0.0);
    }

    public static AffineTransform2D createTransform(AffineTransform transform) {
        return new AffineTransform2D(transform);
    }

    public static AffineTransform2D createTranslation(Vector2D vect) {
        return new AffineTransform2D(1.0, 0.0, vect.x(), 0.0, 1.0, vect.y());
    }

    public static AffineTransform2D createTranslation(double dx, double dy) {
        return new AffineTransform2D(1.0, 0.0, dx, 0.0, 1.0, dy);
    }

    public static boolean isIdentity(AffineTransform2D trans) {
        if (Math.abs(trans.m00 - 1.0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(trans.m01) > 1.0E-12) {
            return false;
        }
        if (Math.abs(trans.m02) > 1.0E-12) {
            return false;
        }
        if (Math.abs(trans.m10) > 1.0E-12) {
            return false;
        }
        if (Math.abs(trans.m11 - 1.0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(trans.m12) > 1.0E-12);
    }

    public static boolean isDirect(AffineTransform2D trans) {
        return trans.m00 * trans.m11 - trans.m01 * trans.m10 > 0.0;
    }

    public static boolean isIsometry(AffineTransform2D trans) {
        double a = trans.m00;
        double b = trans.m01;
        double c = trans.m10;
        double d = trans.m11;
        if (Math.abs(a * a + b * b - 1.0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(c * c + d * d - 1.0) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(a * b + c * d) > 1.0E-12);
    }

    public static boolean isMotion(AffineTransform2D trans) {
        return AffineTransform2D.isIsometry(trans) && AffineTransform2D.isDirect(trans);
    }

    public static boolean isSimilarity(AffineTransform2D trans) {
        double a = trans.m00;
        double b = trans.m01;
        double d = trans.m11;
        double c = trans.m10;
        double k2 = Math.abs(a * d - b * c);
        if (Math.abs(a * a + b * b - k2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(c * c + d * d - k2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(a * a + c * c - k2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(b * b + d * d - k2) > 1.0E-12);
    }

    public AffineTransform2D() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
    }

    public AffineTransform2D(AffineTransform2D trans) {
        this.m00 = trans.m00;
        this.m01 = trans.m01;
        this.m02 = trans.m02;
        this.m10 = trans.m10;
        this.m11 = trans.m11;
        this.m12 = trans.m12;
    }

    public AffineTransform2D(AffineTransform transform) {
        double[] coefs = new double[6];
        transform.getMatrix(coefs);
        this.assignCoefs(coefs);
    }

    public AffineTransform2D(double[] coefs) {
        this.assignCoefs(coefs);
    }

    public AffineTransform2D(double xx, double yx, double tx, double xy, double yy, double ty) {
        this.m00 = xx;
        this.m01 = yx;
        this.m02 = tx;
        this.m10 = xy;
        this.m11 = yy;
        this.m12 = ty;
    }

    private void assignCoefs(double[] coefs) {
        if (coefs.length == 4) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m10 = coefs[2];
            this.m11 = coefs[3];
        } else {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m10 = coefs[3];
            this.m11 = coefs[4];
            this.m12 = coefs[5];
        }
    }

    private void recenter(double x0, double y0) {
        this.m02 = (1.0 - this.m00) * x0 - this.m01 * y0;
        this.m12 = (1.0 - this.m11) * y0 - this.m10 * x0;
    }

    public double[] coefficients() {
        double[] tab = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
        return tab;
    }

    public double[][] affineMatrix() {
        double[][] tab = new double[][]{{this.m00, this.m01, this.m02}, {this.m10, this.m11, this.m12}, {0.0, 0.0, 1.0}};
        return tab;
    }

    public AffineTransform asAwtTransform() {
        return new AffineTransform(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    }

    public AffineTransform2D concatenate(AffineTransform2D that) {
        double n00 = this.m00 * that.m00 + this.m01 * that.m10;
        double n01 = this.m00 * that.m01 + this.m01 * that.m11;
        double n02 = this.m00 * that.m02 + this.m01 * that.m12 + this.m02;
        double n10 = this.m10 * that.m00 + this.m11 * that.m10;
        double n11 = this.m10 * that.m01 + this.m11 * that.m11;
        double n12 = this.m10 * that.m02 + this.m11 * that.m12 + this.m12;
        return new AffineTransform2D(n00, n01, n02, n10, n11, n12);
    }

    public AffineTransform2D chain(AffineTransform2D that) {
        return new AffineTransform2D(that.m00 * this.m00 + that.m01 * this.m10, that.m00 * this.m01 + that.m01 * this.m11, that.m00 * this.m02 + that.m01 * this.m12 + that.m02, that.m10 * this.m00 + that.m11 * this.m10, that.m10 * this.m01 + that.m11 * this.m11, that.m10 * this.m02 + that.m11 * this.m12 + that.m12);
    }

    public AffineTransform2D preConcatenate(AffineTransform2D that) {
        return this.chain(that);
    }

    public boolean isSimilarity() {
        return AffineTransform2D.isSimilarity(this);
    }

    public boolean isMotion() {
        return AffineTransform2D.isMotion(this);
    }

    public boolean isIsometry() {
        return AffineTransform2D.isIsometry(this);
    }

    public boolean isDirect() {
        return AffineTransform2D.isDirect(this);
    }

    public boolean isIdentity() {
        return AffineTransform2D.isIdentity(this);
    }

    @Override
    public AffineTransform2D invert() {
        double det = this.m00 * this.m11 - this.m10 * this.m01;
        if (Math.abs(det) < 1.0E-12) {
            throw new NonInvertibleTransform2DException(this);
        }
        return new AffineTransform2D(this.m11 / det, -this.m01 / det, (this.m01 * this.m12 - this.m02 * this.m11) / det, -this.m10 / det, this.m00 / det, (this.m02 * this.m10 - this.m00 * this.m12) / det);
    }

    @Override
    public Point2D transform(Point2D p) {
        Point2D dst = new Point2D(p.x() * this.m00 + p.y() * this.m01 + this.m02, p.x() * this.m10 + p.y() * this.m11 + this.m12);
        return dst;
    }

    @Override
    public Point2D[] transform(Point2D[] src, Point2D[] dst) {
        if (dst == null) {
            dst = new Point2D[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            double x = src[i].x();
            double y = src[i].y();
            dst[i] = new Point2D(x * this.m00 + y * this.m01 + this.m02, x * this.m10 + y * this.m11 + this.m12);
        }
        return dst;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransform2D)) {
            return false;
        }
        double[] tab1 = this.coefficients();
        double[] tab2 = ((AffineTransform2D)obj).coefficients();
        for (int i = 0; i < 6; ++i) {
            if (!(Math.abs(tab1[i] - tab2[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String("AffineTransform2D(" + this.m00 + "," + this.m01 + "," + this.m02 + "," + this.m10 + "," + this.m11 + "," + this.m12 + ",");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransform2D)) {
            return false;
        }
        AffineTransform2D that = (AffineTransform2D)obj;
        if (!EqualUtils.areEqual(this.m00, that.m00)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m01, that.m01)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m02, that.m02)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m00, that.m00)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.m01, that.m01)) {
            return false;
        }
        return EqualUtils.areEqual(this.m02, that.m02);
    }

    public AffineTransform2D clone() {
        return new AffineTransform2D(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    }
}

