/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearContinuousCurve2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearCurve2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearCurveSet2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearCurves2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearDomain2D;
import one.gfw.geom.math.geom2d.circulinear.buffer.BufferCalculator;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.transform.CircleInversion2D;

public class CirculinearCurveArray2D<T extends CirculinearCurve2D>
extends CurveArray2D<T>
implements CirculinearCurveSet2D<T> {
    public static <T extends CirculinearCurve2D> CirculinearCurveArray2D<T> create1(Collection<T> curves) {
        return new CirculinearCurveArray2D<T>(curves);
    }

    public static <T extends CirculinearCurve2D> CirculinearCurveArray2D<T> create(T ... curves) {
        return new CirculinearCurveArray2D(curves);
    }

    public CirculinearCurveArray2D() {
        this.curves = new ArrayList();
    }

    public CirculinearCurveArray2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CirculinearCurveArray2D(T ... curves) {
        this.curves = new ArrayList(curves.length);
        for (T element : curves) {
            this.add(element);
        }
    }

    public CirculinearCurveArray2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    @Override
    public double length() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.curves()) {
            sum += curve.length();
        }
        return sum;
    }

    @Override
    public double length(double pos) {
        return CirculinearCurves2D.getLength(this, pos);
    }

    @Override
    public double position(double length) {
        return CirculinearCurves2D.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearCurve2D parallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createParallel(this, d);
    }

    @Override
    public CirculinearCurveArray2D<CirculinearCurve2D> transform(CircleInversion2D inv) {
        CirculinearCurveArray2D<CirculinearCurve2D> result = new CirculinearCurveArray2D<CirculinearCurve2D>(this.curves.size());
        for (CirculinearCurve2D curve : this.curves) {
            result.add(curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<? extends CirculinearContinuousCurve2D> continuousCurves() {
        ArrayList<? extends CirculinearContinuousCurve2D> result = new ArrayList<CirculinearContinuousCurve2D>();
        for (CirculinearCurve2D curve : this.curves) {
            result.addAll(curve.continuousCurves());
        }
        return result;
    }

    @Override
    public CirculinearCurveArray2D<? extends CirculinearCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        int n = set.size();
        CirculinearCurveArray2D<CirculinearCurve2D> result = new CirculinearCurveArray2D<CirculinearCurve2D>(n);
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof CirculinearCurve2D)) continue;
            result.add((CirculinearCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public CirculinearCurveArray2D<? extends CirculinearCurve2D> subCurve(double t0, double t1) {
        Curve2D subcurve = super.subCurve(t0, t1);
        CirculinearCurveArray2D<CirculinearCurve2D> result = new CirculinearCurveArray2D<CirculinearCurve2D>(subcurve.size());
        Iterator iterator = subcurve.iterator();
        while (iterator.hasNext()) {
            Curve2D curve = (Curve2D)iterator.next();
            if (curve instanceof CirculinearCurve2D) {
                result.add((CirculinearCurve2D)curve);
                continue;
            }
            System.err.println("CirculinearCurveArray2D.getSubCurve: error in class cast");
        }
        return result;
    }

    @Override
    public CirculinearCurveArray2D<? extends CirculinearCurve2D> reverse() {
        int n = this.curves.size();
        CirculinearCurve2D[] curves2 = new CirculinearCurve2D[n];
        for (int i = 0; i < n; ++i) {
            curves2[i] = ((CirculinearCurve2D)this.curves.get(n - 1 - i)).reverse();
        }
        return new CirculinearCurveArray2D(curves2);
    }
}

