/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Locale;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.GeometricObject2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.Vector2D;
import one.gfw.geom.math.geom2d.circulinear.CircleLine2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearDomain2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearElement2D;
import one.gfw.geom.math.geom2d.circulinear.buffer.BufferCalculator;
import one.gfw.geom.math.geom2d.conic.Circle2D;
import one.gfw.geom.math.geom2d.conic.CircularShape2D;
import one.gfw.geom.math.geom2d.conic.Ellipse2D;
import one.gfw.geom.math.geom2d.conic.EllipseArc2D;
import one.gfw.geom.math.geom2d.conic.EllipseArcShape2D;
import one.gfw.geom.math.geom2d.curve.AbstractSmoothCurve2D;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.curve.SmoothCurve2D;
import one.gfw.geom.math.geom2d.line.LineSegment2D;
import one.gfw.geom.math.geom2d.line.LinearShape2D;
import one.gfw.geom.math.geom2d.line.Ray2D;
import one.gfw.geom.math.geom2d.line.StraightLine2D;
import one.gfw.geom.math.geom2d.polygon.Polyline2D;
import one.gfw.geom.math.geom2d.transform.CircleInversion2D;
import one.gfw.geom.math.utils.EqualUtils;

public class CircleArc2D
extends AbstractSmoothCurve2D
implements EllipseArcShape2D,
CircularShape2D,
CirculinearElement2D,
Cloneable {
    protected Circle2D circle;
    protected double startAngle = 0.0;
    protected double angleExtent = Math.PI;

    @Deprecated
    public static CircleArc2D create(Circle2D support, double startAngle, double angleExtent) {
        return new CircleArc2D(support, startAngle, angleExtent);
    }

    @Deprecated
    public static CircleArc2D create(Circle2D support, double startAngle, double endAngle, boolean direct) {
        return new CircleArc2D(support, startAngle, endAngle, direct);
    }

    @Deprecated
    public static CircleArc2D create(Point2D center, double radius, double startAngle, double angleExtent) {
        return new CircleArc2D(center, radius, startAngle, angleExtent);
    }

    @Deprecated
    public static CircleArc2D create(Point2D center, double radius, double startAngle, double endAngle, boolean direct) {
        return new CircleArc2D(center, radius, startAngle, endAngle, direct);
    }

    public CircleArc2D() {
        this(0.0, 0.0, 1.0, 0.0, 1.5707963267948966);
    }

    public CircleArc2D(Circle2D circle, double startAngle, double angleExtent) {
        this(circle.xc, circle.yc, circle.r, startAngle, angleExtent);
    }

    public CircleArc2D(Circle2D circle, double startAngle, double endAngle, boolean direct) {
        this(circle.xc, circle.yc, circle.r, startAngle, endAngle, direct);
    }

    public CircleArc2D(Point2D center, double radius, double startAngle, double angleExtent) {
        this(center.x(), center.y(), radius, startAngle, angleExtent);
    }

    public CircleArc2D(Point2D center, double radius, double start, double end, boolean direct) {
        this(center.x(), center.y(), radius, start, end, direct);
    }

    public CircleArc2D(double xc, double yc, double r, double startAngle, double endAngle, boolean direct) {
        this.circle = new Circle2D(xc, yc, r);
        this.startAngle = startAngle;
        this.angleExtent = endAngle;
        this.angleExtent = Angle2D.formatAngle(endAngle - startAngle);
        if (!direct) {
            this.angleExtent -= Math.PI * 2;
        }
    }

    public CircleArc2D(double xc, double yc, double r, double start, double extent) {
        this.circle = new Circle2D(xc, yc, r);
        this.startAngle = start;
        this.angleExtent = extent;
    }

    public boolean isDirect() {
        return this.angleExtent >= 0.0;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getAngleExtent() {
        return this.angleExtent;
    }

    public boolean containsAngle(double angle) {
        return Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, angle, this.angleExtent >= 0.0);
    }

    public double getAngle(double position) {
        if (position < 0.0) {
            position = 0.0;
        }
        if (position > Math.abs(this.angleExtent)) {
            position = Math.abs(this.angleExtent);
        }
        if (this.angleExtent < 0.0) {
            position = -position;
        }
        return Angle2D.formatAngle(this.startAngle + position);
    }

    private double positionToAngle(double t) {
        if (t > Math.abs(this.angleExtent)) {
            t = Math.abs(this.angleExtent);
        }
        if (t < 0.0) {
            t = 0.0;
        }
        if (this.angleExtent < 0.0) {
            t = -t;
        }
        return t += this.startAngle;
    }

    @Override
    public Circle2D supportingCircle() {
        return this.circle;
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CircleArc2D parallel(double dist) {
        double r = this.circle.radius();
        double r2 = Math.max(this.angleExtent > 0.0 ? r + dist : r - dist, 0.0);
        return new CircleArc2D(this.circle.center(), r2, this.startAngle, this.angleExtent);
    }

    @Override
    public double length() {
        return this.circle.radius() * Math.abs(this.angleExtent);
    }

    @Override
    public double length(double pos) {
        return pos * this.circle.radius();
    }

    @Override
    public double position(double length) {
        return length / this.circle.radius();
    }

    @Override
    public CirculinearElement2D transform(CircleInversion2D inv) {
        CircleLine2D support = this.circle.transform(inv);
        Point2D p1 = this.firstPoint().transform(inv);
        Point2D p2 = this.lastPoint().transform(inv);
        if (support instanceof Circle2D) {
            Circle2D circle2 = (Circle2D)support;
            Point2D center = circle2.center();
            return new CircleArc2D(circle2.center(), circle2.radius(), Angle2D.horizontalAngle(center, p1), Angle2D.horizontalAngle(center, p2), !this.isDirect() ^ circle2.isDirect());
        }
        if (support instanceof StraightLine2D) {
            return new LineSegment2D(p1, p2);
        }
        System.err.println("CircleArc2D.transform(): error in transforming circle by inversion");
        return null;
    }

    @Override
    public double windingAngle(Point2D point) {
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.lastPoint();
        double angle1 = Angle2D.horizontalAngle(point, p1);
        double angle2 = Angle2D.horizontalAngle(point, p2);
        boolean b1 = new StraightLine2D(p1, p2).isInside(point);
        boolean b2 = this.circle.isInside(point);
        if (this.angleExtent > 0.0) {
            if (b1 || b2) {
                if (angle2 > angle1) {
                    return angle2 - angle1;
                }
                return Math.PI * 2 - angle1 + angle2;
            }
            if (angle2 > angle1) {
                return angle2 - angle1 - Math.PI * 2;
            }
            return angle2 - angle1;
        }
        if (!b1 || b2) {
            if (angle1 > angle2) {
                return angle2 - angle1;
            }
            return angle2 - angle1 - Math.PI * 2;
        }
        if (angle1 > angle2) {
            return angle2 - angle1 + Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public boolean isInside(Point2D point) {
        return this.signedDistance(point.x(), point.y()) < 0.0;
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        double dist = this.distance(x, y);
        Point2D point = new Point2D(x, y);
        boolean direct = this.angleExtent > 0.0;
        boolean inCircle = this.circle.isInside(point);
        if (inCircle) {
            return direct ? -dist : dist;
        }
        Point2D p1 = this.circle.point(this.startAngle);
        Point2D p2 = this.circle.point(this.startAngle + this.angleExtent);
        boolean onLeft = new StraightLine2D(p1, p2).isInside(point);
        if (direct && !onLeft) {
            return dist;
        }
        if (!direct && onLeft) {
            return -dist;
        }
        Vector2D tangent = this.circle.tangent(this.startAngle);
        boolean left1 = new Ray2D(p1, tangent).isInside(point);
        if (direct && !left1) {
            return dist;
        }
        if (!direct && left1) {
            return -dist;
        }
        tangent = this.circle.tangent(this.startAngle + this.angleExtent);
        boolean left2 = new Ray2D(p2, tangent).isInside(point);
        if (direct && !left2) {
            return dist;
        }
        if (!direct && left2) {
            return -dist;
        }
        if (direct) {
            return -dist;
        }
        return dist;
    }

    @Override
    public Vector2D tangent(double t) {
        t = this.positionToAngle(t);
        double r = this.circle.radius();
        if (this.angleExtent > 0.0) {
            return new Vector2D(-r * Math.sin(t), r * Math.cos(t));
        }
        return new Vector2D(r * Math.sin(t), -r * Math.cos(t));
    }

    @Override
    public double curvature(double t) {
        double kappa = this.circle.curvature(t);
        return this.isDirect() ? kappa : -kappa;
    }

    public Collection<? extends CircleArc2D> smoothPieces() {
        return CircleArc2D.wrapCurve(this);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Polyline2D asPolyline(int n) {
        double dt = Math.abs(this.angleExtent) / (double)n;
        Point2D[] points = new Point2D[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            points[i] = this.point((double)i * dt);
        }
        return new Polyline2D(points);
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return 0.0;
    }

    @Override
    public double t1() {
        return Math.abs(this.angleExtent);
    }

    @Override
    @Deprecated
    public double getT1() {
        return Math.abs(this.angleExtent);
    }

    @Override
    public Point2D point(double t) {
        t = this.positionToAngle(t);
        return this.circle.point(t);
    }

    @Override
    public double position(Point2D point) {
        double angle = Angle2D.horizontalAngle(this.circle.center(), point);
        if (this.containsAngle(angle)) {
            if (this.angleExtent > 0.0) {
                return Angle2D.formatAngle(angle - this.startAngle);
            }
            return Angle2D.formatAngle(this.startAngle - angle);
        }
        return this.firstPoint().distance(point) < this.lastPoint().distance(point) ? 0.0 : Math.abs(this.angleExtent);
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        return Circle2D.lineCircleIntersections(line, this);
    }

    @Override
    public double project(Point2D point) {
        double angle = this.circle.project(point);
        if (Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, angle, this.angleExtent > 0.0)) {
            if (this.angleExtent > 0.0) {
                return Angle2D.formatAngle(angle - this.startAngle);
            }
            return Angle2D.formatAngle(this.startAngle - angle);
        }
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.lastPoint();
        if (p1.distance(point) < p2.distance(point)) {
            return 0.0;
        }
        return Math.abs(this.angleExtent);
    }

    @Override
    public CircleArc2D subCurve(double t0, double t1) {
        if (this.angleExtent > 0.0) {
            t0 = Angle2D.formatAngle(this.startAngle + t0);
            t1 = Angle2D.formatAngle(this.startAngle + t1);
        } else {
            t0 = Angle2D.formatAngle(this.startAngle - t0);
            t1 = Angle2D.formatAngle(this.startAngle - t1);
        }
        if (!Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, t0, this.angleExtent > 0.0)) {
            t0 = this.startAngle;
        }
        if (!Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, t1, this.angleExtent > 0.0)) {
            t1 = Angle2D.formatAngle(this.startAngle + this.angleExtent);
        }
        return new CircleArc2D(this.circle, t0, t1, this.angleExtent > 0.0);
    }

    @Override
    public CircleArc2D reverse() {
        double newStart = Angle2D.formatAngle(this.startAngle + this.angleExtent);
        return new CircleArc2D(this.circle, newStart, -this.angleExtent);
    }

    public Collection<? extends CircleArc2D> continuousCurves() {
        return CircleArc2D.wrapCurve(this);
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        double angle = Angle2D.horizontalAngle(this.circle.xc, this.circle.yc, x, y);
        if (this.containsAngle(angle)) {
            return Math.abs(Point2D.distance(this.circle.xc, this.circle.yc, x, y) - this.circle.r);
        }
        return Math.min(this.firstPoint().distance(x, y), this.lastPoint().distance(x, y));
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public CurveSet2D<CircleArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<CircleArc2D> result = new CurveArray2D<CircleArc2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof CircleArc2D)) continue;
            result.add((CircleArc2D)curve2D);
        }
        return result;
    }

    @Override
    public EllipseArcShape2D transform(AffineTransform2D trans) {
        if (!AffineTransform2D.isSimilarity(trans)) {
            Ellipse2D ellipse = this.circle.asEllipse();
            EllipseArc2D arc = new EllipseArc2D(ellipse, this.startAngle, this.angleExtent);
            return arc.transform(trans);
        }
        Point2D center = this.circle.center();
        Point2D point1 = this.firstPoint();
        Point2D point2 = this.lastPoint();
        center = center.transform(trans);
        point1 = point1.transform(trans);
        point2 = point2.transform(trans);
        double angle1 = Angle2D.horizontalAngle(center, point1);
        double angle2 = Angle2D.horizontalAngle(center, point2);
        double[] coefs = trans.coefficients();
        double factor = Math.hypot(coefs[0], coefs[3]);
        double xc = center.x();
        double yc = center.y();
        double r2 = this.circle.radius() * factor;
        double startAngle = angle1;
        double angleExtent = Angle2D.formatAngle(angle2 - angle1);
        boolean b1 = AffineTransform2D.isDirect(trans);
        boolean b2 = this.isDirect();
        if (b1 && !b2 || !b1 && b2) {
            angleExtent -= Math.PI * 2;
        }
        return new CircleArc2D(xc, yc, r2, startAngle, angleExtent);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(double x, double y) {
        double r = this.circle.radius();
        if (Math.abs(Point2D.distance(this.circle.xc, this.circle.yc, x, y) - r) > 1.0E-12) {
            return false;
        }
        double angle = Angle2D.horizontalAngle(this.circle.xc, this.circle.yc, x, y);
        return this.containsAngle(angle);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Box2D boundingBox() {
        boolean direct;
        Point2D p0 = this.firstPoint();
        Point2D p1 = this.lastPoint();
        double x0 = p0.x();
        double y0 = p0.y();
        double x1 = p1.x();
        double y1 = p1.y();
        double xmin = Math.min(x0, x1);
        double xmax = Math.max(x0, x1);
        double ymin = Math.min(y0, y1);
        double ymax = Math.max(y0, y1);
        Point2D center = this.circle.center();
        double xc = center.x();
        double yc = center.y();
        double endAngle = this.startAngle + this.angleExtent;
        boolean bl = direct = this.angleExtent >= 0.0;
        if (Angle2D.containsAngle(this.startAngle, endAngle, 1.5707963267948966 + this.circle.theta, direct)) {
            ymax = Math.max(ymax, yc + this.circle.r);
        }
        if (Angle2D.containsAngle(this.startAngle, endAngle, 4.71238898038469 + this.circle.theta, direct)) {
            ymin = Math.min(ymin, yc - this.circle.r);
        }
        if (Angle2D.containsAngle(this.startAngle, endAngle, this.circle.theta, direct)) {
            xmax = Math.max(xmax, xc + this.circle.r);
        }
        if (Angle2D.containsAngle(this.startAngle, endAngle, Math.PI + this.circle.theta, direct)) {
            xmin = Math.min(xmin, xc - this.circle.r);
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        int nSeg = (int)Math.ceil(Math.abs(this.angleExtent) / 1.5707963267948966);
        nSeg = Math.min(nSeg, 4);
        double ext = this.angleExtent / (double)nSeg;
        double k = CircleArc2D.btan(Math.abs(ext));
        for (int i = 0; i < nSeg; ++i) {
            double ti0 = Math.abs((double)i * ext);
            double ti1 = Math.abs((double)(i + 1) * ext);
            Point2D p1 = this.point(ti0);
            Point2D p2 = this.point(ti1);
            Vector2D v1 = this.tangent(ti0).times(k);
            Vector2D v2 = this.tangent(ti1).times(k);
            path.curveTo(p1.x() + v1.x(), p1.y() + v1.y(), p2.x() - v2.x(), p2.y() - v2.y(), p2.x(), p2.y());
        }
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D point = this.firstPoint();
        path.moveTo((float)point.x(), (float)point.y());
        path = this.appendPath(path);
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getGeneralPath());
    }

    private static double btan(double increment) {
        return 1.3333333333333333 * Math.sin(increment /= 2.0) / (1.0 + Math.cos(increment));
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CircleArc2D)) {
            return super.equals(obj);
        }
        CircleArc2D arc = (CircleArc2D)obj;
        if (Math.abs(this.circle.xc - arc.circle.xc) > eps) {
            return false;
        }
        if (Math.abs(this.circle.yc - arc.circle.yc) > eps) {
            return false;
        }
        if (Math.abs(this.circle.r - arc.circle.r) > eps) {
            return false;
        }
        if (Math.abs(this.circle.theta - arc.circle.theta) > eps) {
            return false;
        }
        if (Math.abs(Angle2D.formatAngle(this.startAngle) - Angle2D.formatAngle(arc.startAngle)) > eps) {
            return false;
        }
        return !(Math.abs(Angle2D.formatAngle(this.angleExtent) - Angle2D.formatAngle(arc.angleExtent)) > eps);
    }

    public String toString() {
        Point2D center = this.circle.center();
        return String.format(Locale.US, "CircleArc2D(%7.2f,%7.2f,%7.2f,%7.5f,%7.5f)", center.x(), center.y(), this.circle.radius(), this.getStartAngle(), this.getAngleExtent());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CircleArc2D)) {
            return false;
        }
        CircleArc2D that = (CircleArc2D)obj;
        if (!this.circle.equals(that.circle)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.startAngle, that.startAngle)) {
            return false;
        }
        return EqualUtils.areEqual(this.angleExtent, that.angleExtent);
    }

    @Override
    public CircleArc2D clone() {
        return new CircleArc2D(this.circle.clone(), this.startAngle, this.angleExtent);
    }
}

