/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.conic;

import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.conic.Conic2D;
import one.gfw.geom.math.geom2d.conic.Ellipse2D;
import one.gfw.geom.math.geom2d.conic.Hyperbola2D;
import one.gfw.geom.math.geom2d.conic.Parabola2D;
import one.gfw.geom.math.geom2d.domain.ContourArray2D;
import one.gfw.geom.math.geom2d.line.StraightLine2D;

public class Conics2D {
    public static final Conic2D reduceConic(double[] coefs) {
        double ys;
        double xs;
        double f2;
        double dist;
        double delta;
        double f1;
        double e1;
        double d1;
        double c1;
        double b1;
        double a1;
        if (coefs.length < 6) {
            System.err.println("Conic2DUtils.reduceConic: must provide 6 coefficients");
            return null;
        }
        boolean debug = false;
        double eps = 1.0E-12;
        double a = coefs[0];
        double b = coefs[1];
        double c = coefs[2];
        double d = coefs[3];
        double e = coefs[4];
        double f = coefs[5];
        double theta0 = 0.0;
        if (Math.abs(b) < eps) {
            a1 = a;
            b1 = b;
            c1 = c;
            d1 = d;
            e1 = e;
            f1 = f;
            theta0 = 0.0;
        } else {
            theta0 = Math.abs(a - c) < eps ? 0.7853981633974483 : Angle2D.formatAngle(Math.atan2(b, a - c) / 2.0);
            if (debug) {
                System.out.println("conic main angle: " + Math.toDegrees(theta0));
            }
            double cot = Math.cos(theta0);
            double sit = Math.sin(theta0);
            double co2t = Math.cos(2.0 * theta0);
            double si2t = Math.sin(2.0 * theta0);
            double cot2 = cot * cot;
            double sit2 = sit * sit;
            a1 = a * cot2 + b * sit * cot + c * sit2;
            b1 = si2t * (c - a) + b * co2t;
            c1 = a * sit2 - b * sit * cot + c * cot2;
            d1 = d * cot + e * sit;
            e1 = -d * sit + e * cot;
            f1 = f;
        }
        if (Math.abs(b1) > eps) {
            System.err.println("Conic2DUtils.reduceConic: conic was not correctly transformed");
            return null;
        }
        if (Math.abs(a) < eps && Math.abs(c) < eps) {
            if (Math.abs(d) > eps || Math.abs(e) > eps) {
                return new ConicStraightLine2D(d, e, f);
            }
            return null;
        }
        if (Math.abs(a1) < eps) {
            if (debug) {
                System.out.println("horizontal parabola");
            }
            if (Math.abs(d1) < eps) {
                delta = e1 * e1 - 4.0 * c1 * f1;
                if (delta >= 0.0) {
                    double ys2 = -e1 / 2.0 / c1;
                    dist = Math.sqrt(delta) / 2.0 / c1;
                    Point2D center = new Point2D(0.0, ys2).transform(AffineTransform2D.createRotation(theta0));
                    return new ConicTwoLines2D(center, dist, theta0);
                }
                return null;
            }
            double c2 = -c1 / d1;
            double e2 = -e1 / d1;
            f2 = -f1 / d1;
            xs = -(e2 * e2 - 4.0 * c2 * f2) / (4.0 * c2);
            ys = -e2 * 0.5 / c2;
            return new Parabola2D(xs, ys, c2, theta0 - 1.5707963267948966);
        }
        if (Math.abs(c1) < eps) {
            if (debug) {
                System.out.println("vertical parabola");
            }
            if (Math.abs(e1) < eps) {
                delta = d1 * d1 - 4.0 * a1 * f1;
                if (delta >= 0.0) {
                    double xs2 = -d1 / 2.0 / a1;
                    dist = Math.sqrt(delta) / 2.0 / a1;
                    Point2D center = new Point2D(0.0, xs2).transform(AffineTransform2D.createRotation(theta0));
                    return new ConicTwoLines2D(center, dist, theta0);
                }
                return null;
            }
            double a2 = -a1 / e1;
            double d2 = -d1 / e1;
            f2 = -f1 / e1;
            xs = -d2 * 0.5 / a2;
            ys = -(d2 * d2 - 4.0 * a2 * f2) / (4.0 * a2);
            return new Parabola2D(xs, ys, a2, theta0);
        }
        Point2D center = new Point2D(-d1 / (2.0 * a1), -e1 / (2.0 * c1));
        center = center.transform(AffineTransform2D.createRotation(theta0));
        double num = (c1 * d1 * d1 + a1 * e1 * e1 - 4.0 * a1 * c1 * f1) / (4.0 * a1 * c1);
        double at = num / a1;
        double bt = num / c1;
        if (at < 0.0 && bt < 0.0) {
            System.err.println("Conic2DUtils.reduceConic(): found A<0 and C<0");
            return null;
        }
        if (at > 0.0 && bt > 0.0) {
            if (debug) {
                System.out.println("ellipse");
            }
            if (at > bt) {
                return new Ellipse2D(center, Math.sqrt(at), Math.sqrt(bt), theta0);
            }
            return new Ellipse2D(center, Math.sqrt(bt), Math.sqrt(at), Angle2D.formatAngle(theta0 + 1.5707963267948966));
        }
        if (at > 0.0) {
            if (debug) {
                System.out.println("east-west hyperbola");
            }
            return new Hyperbola2D(center, Math.sqrt(at), Math.sqrt(-bt), theta0);
        }
        if (debug) {
            System.out.println("north-south hyperbola");
        }
        return new Hyperbola2D(center, Math.sqrt(bt), Math.sqrt(-at), theta0 + 1.5707963267948966);
    }

    public static final double[] transformCentered(double[] coefs, AffineTransform2D trans) {
        double[][] mat = trans.affineMatrix();
        double a = mat[0][0];
        double b = mat[1][0];
        double c = mat[0][1];
        double d = mat[1][1];
        double A = coefs[0];
        double B = coefs[1];
        double C = coefs[2];
        double delta = a * d - b * c;
        delta *= delta;
        double A2 = (A * d * d + C * b * b - B * b * d) / delta;
        double B2 = (B * (a * d + b * c) - 2.0 * (A * c * d + C * a * b)) / delta;
        double C2 = (A * c * c + C * a * a - B * a * c) / delta;
        if (coefs.length == 3) {
            return new double[]{A2, B2, C2};
        }
        double D = coefs[3];
        double E = coefs[4];
        double F = coefs[5];
        double D2 = D * d - E * b;
        double E2 = E * a - D * c;
        return new double[]{A2, B2, C2, D2, E2, F};
    }

    public static final double[] transform(double[] coefs, AffineTransform2D trans) {
        double[][] mat = trans.invert().affineMatrix();
        double a = mat[0][0];
        double b = mat[1][0];
        double c = mat[0][1];
        double d = mat[1][1];
        double e = mat[0][2];
        double f = mat[1][2];
        double A = coefs[0];
        double B = coefs[1];
        double C = coefs[2];
        double D = coefs[3];
        double E = coefs[4];
        double F = coefs[5];
        double A2 = A * a * a + B * a * b + C * b * b;
        double B2 = 2.0 * (A * a * c + C * b * d) + B * (a * d + b * c);
        double C2 = A * c * c + B * c * d + C * d * d;
        double D2 = 2.0 * (A * a * e + C * b * f) + B * (a * f + b * e) + D * a + E * b;
        double E2 = 2.0 * (A * c * e + C * d * f) + B * (c * f + d * e) + D * c + E * d;
        double F2 = A * e * e + B * e * f + C * f * f + D * e + E * f + F;
        return new double[]{A2, B2, C2, D2, E2, F2};
    }

    static class ConicTwoLines2D
    extends ContourArray2D<StraightLine2D>
    implements Conic2D {
        double xc = 0.0;
        double yc = 0.0;
        double d = 1.0;
        double theta = 0.0;

        public ConicTwoLines2D(Point2D point, double d, double theta) {
            this(point.x(), point.y(), d, theta);
        }

        public ConicTwoLines2D(double xc, double yc, double d, double theta) {
            this.xc = xc;
            this.yc = yc;
            this.d = d;
            this.theta = theta;
            StraightLine2D baseLine = new StraightLine2D(new Point2D(xc, yc), theta);
            this.add(baseLine.parallel(d));
            this.add(baseLine.parallel(-d).reverse());
        }

        @Override
        public double[] conicCoefficients() {
            double[] coefs = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, -1.0};
            AffineTransform2D sca = AffineTransform2D.createScaling(0.0, this.d);
            AffineTransform2D rot = AffineTransform2D.createRotation(this.theta);
            AffineTransform2D tra = AffineTransform2D.createTranslation(this.xc, this.yc);
            AffineTransform2D trans = sca.chain(rot).chain(tra);
            return Conics2D.transform(coefs, trans);
        }

        @Override
        public Conic2D.Type conicType() {
            return Conic2D.Type.TWO_LINES;
        }

        @Override
        public double eccentricity() {
            return Double.NaN;
        }

        @Override
        public ConicTwoLines2D transform(AffineTransform2D trans) {
            Point2D center = new Point2D(this.xc, this.yc).transform(trans);
            StraightLine2D line = ((StraightLine2D)this.firstCurve()).transform(trans);
            double dist = line.distance(center);
            double angle = line.horizontalAngle();
            return new ConicTwoLines2D(center, dist, angle);
        }

        @Override
        public ConicTwoLines2D reverse() {
            return new ConicTwoLines2D(this.xc, this.yc, -this.d, this.theta);
        }
    }

    static class ConicStraightLine2D
    extends StraightLine2D
    implements Conic2D {
        double[] coefs = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0};

        public ConicStraightLine2D(StraightLine2D line) {
            super(line);
            this.coefs = new double[]{0.0, 0.0, 0.0, this.dy, -this.dx, this.dx * this.y0 - this.dy * this.x0};
        }

        public ConicStraightLine2D(double a, double b, double c) {
            super(StraightLine2D.createCartesian(a, b, c));
            this.coefs = new double[]{0.0, 0.0, 0.0, a, b, c};
        }

        @Override
        public double[] conicCoefficients() {
            return this.coefs;
        }

        @Override
        public Conic2D.Type conicType() {
            return Conic2D.Type.STRAIGHT_LINE;
        }

        @Override
        public double eccentricity() {
            return Double.NaN;
        }

        @Override
        public ConicStraightLine2D reverse() {
            return new ConicStraightLine2D(super.reverse());
        }

        @Override
        public ConicStraightLine2D transform(AffineTransform2D trans) {
            return new ConicStraightLine2D(super.transform(trans));
        }
    }
}

