/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.conic;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.GeometricObject2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.UnboundedShape2DException;
import one.gfw.geom.math.geom2d.Vector2D;
import one.gfw.geom.math.geom2d.conic.Parabola2D;
import one.gfw.geom.math.geom2d.curve.AbstractSmoothCurve2D;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.curve.SmoothCurve2D;
import one.gfw.geom.math.geom2d.domain.SmoothOrientedCurve2D;
import one.gfw.geom.math.geom2d.line.LinearShape2D;
import one.gfw.geom.math.geom2d.line.StraightLine2D;
import one.gfw.geom.math.geom2d.polygon.Polyline2D;
import one.gfw.geom.math.utils.EqualUtils;

public class ParabolaArc2D
extends AbstractSmoothCurve2D
implements SmoothOrientedCurve2D,
Cloneable {
    protected Parabola2D parabola = new Parabola2D();
    double t0 = 0.0;
    double t1 = 1.0;

    public static ParabolaArc2D create(Parabola2D parabola, double t0, double t1) {
        return new ParabolaArc2D(parabola, t0, t1);
    }

    public ParabolaArc2D(Parabola2D parabola, double t0, double t1) {
        this.parabola = parabola;
        this.t0 = t0;
        this.t1 = t1;
    }

    public Parabola2D getParabola() {
        return this.parabola;
    }

    @Override
    public double windingAngle(Point2D point) {
        boolean direct = this.parabola.isDirect();
        boolean inside = this.isInside(point);
        double angle0 = Double.isInfinite(this.t0) ? this.parabola.getAngle() + (double)(direct ? 1 : -1) * Math.PI / 2.0 : Angle2D.horizontalAngle(point, this.parabola.point(this.t0));
        double angle1 = Double.isInfinite(this.t1) ? this.parabola.getAngle() + (double)(direct ? 1 : -1) * Math.PI / 2.0 : Angle2D.horizontalAngle(point, this.parabola.point(this.t1));
        if (inside) {
            if (angle0 > angle1) {
                return Math.PI * 2 - angle0 + angle1;
            }
            return angle1 - angle0;
        }
        if (angle0 > angle1) {
            return angle1 - angle0;
        }
        return angle1 - angle0 - Math.PI * 2;
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.distance(x, y);
        }
        return -this.distance(x, y);
    }

    @Override
    public boolean isInside(Point2D point) {
        boolean direct = this.parabola.isDirect();
        boolean inside = this.parabola.isInside(point);
        if (inside && direct) {
            return true;
        }
        if (!inside && !direct) {
            return false;
        }
        double pos = this.parabola.project(point);
        if (pos < this.t0) {
            Point2D p0 = this.parabola.point(this.t0);
            Vector2D v0 = this.parabola.tangent(this.t0);
            StraightLine2D line0 = new StraightLine2D(p0, v0);
            return line0.isInside(point);
        }
        if (pos > this.t1) {
            Point2D p1 = this.parabola.point(this.t1);
            Vector2D v1 = this.parabola.tangent(this.t1);
            StraightLine2D line1 = new StraightLine2D(p1, v1);
            return line1.isInside(point);
        }
        return !direct;
    }

    @Override
    public Vector2D tangent(double t) {
        return this.parabola.tangent(t);
    }

    @Override
    public double curvature(double t) {
        return this.parabola.curvature(t);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Polyline2D asPolyline(int n) {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        double t0 = this.t0();
        double dt = (this.t1() - t0) / (double)n;
        Point2D[] points = new Point2D[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            points[i] = this.point(t0 + (double)i * dt);
        }
        return new Polyline2D(points);
    }

    @Override
    public double t0() {
        return this.t0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return this.t1;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        t = Math.min(Math.max(t, this.t0), this.t1);
        return this.parabola.point(t);
    }

    @Override
    public double position(Point2D point) {
        if (!this.parabola.contains(point)) {
            return Double.NaN;
        }
        double t = this.parabola.position(point);
        if (t - this.t0 < -1.0E-12) {
            return Double.NaN;
        }
        if (this.t1 - t < 1.0E-12) {
            return Double.NaN;
        }
        return t;
    }

    @Override
    public double project(Point2D point) {
        double t = this.parabola.project(point);
        return Math.min(Math.max(t, this.t0), this.t1);
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        Collection<Point2D> inters0 = this.parabola.intersections(line);
        ArrayList<Point2D> inters = new ArrayList<Point2D>(2);
        for (Point2D point : inters0) {
            double pos = this.parabola.position(point);
            if (!(pos > this.t0) || !(pos < this.t1)) continue;
            inters.add(point);
        }
        return inters;
    }

    @Override
    public ParabolaArc2D reverse() {
        return new ParabolaArc2D(this.parabola.reverse(), -this.t1, -this.t0);
    }

    @Override
    public ParabolaArc2D subCurve(double t0, double t1) {
        if (t1 < t0) {
            return null;
        }
        t0 = Math.max(this.t0, t0);
        t1 = Math.min(this.t1, t1);
        return new ParabolaArc2D(this.parabola, t0, t1);
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        return this.asPolyline(100).distance(x, y);
    }

    @Override
    public boolean isBounded() {
        if (this.t0 == Double.NEGATIVE_INFINITY) {
            return false;
        }
        return this.t1 != Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isEmpty() {
        return this.t1 <= this.t0;
    }

    @Override
    public CurveSet2D<? extends ParabolaArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<ParabolaArc2D> result = new CurveArray2D<ParabolaArc2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof ParabolaArc2D)) continue;
            result.add((ParabolaArc2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        return this.asPolyline(100).boundingBox();
    }

    @Override
    public ParabolaArc2D transform(AffineTransform2D trans) {
        Parabola2D par = this.parabola.transform(trans);
        double startPos = Double.isInfinite(this.t0) ? Double.NEGATIVE_INFINITY : par.project(this.firstPoint().transform(trans));
        double endPos = Double.isInfinite(this.t1) ? Double.POSITIVE_INFINITY : par.project(this.lastPoint().transform(trans));
        return new ParabolaArc2D(par, startPos, endPos);
    }

    @Override
    public boolean contains(double x, double y) {
        if (!this.parabola.contains(x, y)) {
            return false;
        }
        double t = this.parabola.position(new Point2D(x, y));
        if (t < this.t0) {
            return false;
        }
        return !(t > this.t1);
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.x(), point.y());
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.lastPoint();
        Vector2D v1 = this.tangent(this.t0);
        Vector2D v2 = this.tangent(this.t1);
        StraightLine2D line1 = new StraightLine2D(p1, v1);
        StraightLine2D line2 = new StraightLine2D(p2, v2);
        Point2D pc = line1.intersection(line2);
        path.quadTo(pc.x(), pc.y(), p2.x(), p2.y());
        return path;
    }

    public GeneralPath getGeneralPath() {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        return this.asPolyline(32).asGeneralPath();
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParabolaArc2D)) {
            return false;
        }
        ParabolaArc2D arc = (ParabolaArc2D)obj;
        if (!this.parabola.almostEquals(arc.parabola, eps)) {
            return false;
        }
        if (Math.abs(this.t0 - arc.t0) > eps) {
            return false;
        }
        return !(Math.abs(this.t1 - arc.t1) > eps);
    }

    public String toString() {
        return String.format("ParabolaArc2D(%f,%f,%f,%f,%f,%f)", this.parabola.xv, this.parabola.yv, this.parabola.a, this.parabola.theta, this.t0, this.t1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParabolaArc2D)) {
            return false;
        }
        ParabolaArc2D that = (ParabolaArc2D)obj;
        if (!this.parabola.equals(that.parabola)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.t0, that.t0)) {
            return false;
        }
        return EqualUtils.areEqual(this.t1, that.t1);
    }

    @Override
    public ParabolaArc2D clone() {
        return new ParabolaArc2D(this.parabola.clone(), this.t0, this.t1);
    }
}

