/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.curve;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.UnboundedShape2DException;
import one.gfw.geom.math.geom2d.curve.ContinuousCurve2D;
import one.gfw.geom.math.geom2d.polygon.LinearCurve2D;
import one.gfw.geom.math.geom2d.polygon.LinearRing2D;
import one.gfw.geom.math.geom2d.polygon.Polyline2D;

public abstract class AbstractContinuousCurve2D
implements ContinuousCurve2D,
Cloneable {
    protected static <T extends ContinuousCurve2D> Collection<T> wrapCurve(T curve) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(curve);
        return list;
    }

    @Override
    public LinearCurve2D asPolyline(int n) {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        if (this.isClosed()) {
            return this.asPolylineClosed(n);
        }
        return this.asPolylineOpen(n);
    }

    protected Polyline2D asPolylineOpen(int n) {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        double t0 = this.t0();
        double dt = (this.t1() - t0) / (double)n;
        Point2D[] points = new Point2D[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            points[i] = this.point(t0 + (double)i * dt);
        }
        return new Polyline2D(points);
    }

    protected LinearRing2D asPolylineClosed(int n) {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        double t0 = this.t0();
        double dt = (this.t1() - t0) / (double)n;
        Point2D[] points = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            points[i] = this.point(t0 + (double)i * dt);
        }
        return new LinearRing2D(points);
    }

    @Override
    public Collection<? extends ContinuousCurve2D> continuousCurves() {
        return AbstractContinuousCurve2D.wrapCurve(this);
    }

    @Override
    public Point2D firstPoint() {
        double t0 = this.t0();
        if (Double.isInfinite(t0)) {
            throw new UnboundedShape2DException(this);
        }
        return this.point(t0);
    }

    @Override
    public Point2D lastPoint() {
        double t1 = this.t1();
        if (Double.isInfinite(t1)) {
            throw new UnboundedShape2DException(this);
        }
        return this.point(t1);
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.asAwtShape());
    }

    @Override
    public Shape asAwtShape() {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        GeneralPath path = new GeneralPath();
        Point2D point = this.firstPoint();
        path.moveTo((float)point.x(), (float)point.y());
        path = this.appendPath(path);
        return path;
    }

    @Override
    public abstract ContinuousCurve2D clone();
}

