/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.domain;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.domain.Boundary2D;
import one.gfw.geom.math.geom2d.domain.ContinuousOrientedCurve2D;
import one.gfw.geom.math.geom2d.domain.Contour2D;
import one.gfw.geom.math.geom2d.domain.Domain2D;
import one.gfw.geom.math.geom2d.domain.GenericDomain2D;
import one.gfw.geom.math.geom2d.domain.OrientedCurve2D;

public class ContourArray2D<T extends Contour2D>
extends CurveArray2D<T>
implements Boundary2D {
    public static <T extends Contour2D> ContourArray2D<T> create1(Collection<T> curves) {
        return new ContourArray2D<Collection<T>>(curves);
    }

    public static <T extends Contour2D> ContourArray2D<T> create(T ... curves) {
        return new ContourArray2D<T[]>(curves);
    }

    public ContourArray2D() {
    }

    public ContourArray2D(int size) {
        super(size);
    }

    public ContourArray2D(T ... curves) {
        super(curves);
    }

    public ContourArray2D(Collection<? extends T> curves) {
        super(curves);
    }

    public ContourArray2D(T curve) {
        this.add(curve);
    }

    @Override
    public Collection<? extends T> continuousCurves() {
        return Collections.unmodifiableCollection(this.curves);
    }

    @Override
    public Domain2D domain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    @Override
    public double windingAngle(Point2D point) {
        double angle = 0.0;
        for (OrientedCurve2D curve : this.curves()) {
            angle += curve.windingAngle(point);
        }
        return angle;
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        double minDist = Double.POSITIVE_INFINITY;
        double dist = Double.POSITIVE_INFINITY;
        for (OrientedCurve2D curve : this.curves()) {
            if (!(Math.abs(dist = Math.min(dist, curve.signedDistance(x, y))) < Math.abs(minDist))) continue;
            minDist = dist;
        }
        return minDist;
    }

    @Override
    public boolean isInside(Point2D point) {
        return this.signedDistance(point.x(), point.y()) < 0.0;
    }

    @Override
    public ContourArray2D<? extends Contour2D> reverse() {
        Contour2D[] curves2 = new Contour2D[this.curves.size()];
        int n = this.curves.size();
        for (int i = 0; i < n; ++i) {
            curves2[i] = ((Contour2D)this.curves.get(n - 1 - i)).reverse();
        }
        return new ContourArray2D<Contour2D[]>(curves2);
    }

    @Override
    public CurveSet2D<? extends ContinuousOrientedCurve2D> subCurve(double t0, double t1) {
        Curve2D curveSet = super.subCurve(t0, t1);
        ArrayList<ContinuousOrientedCurve2D> curves = new ArrayList<ContinuousOrientedCurve2D>();
        for (Curve2D curve : curveSet.curves()) {
            curves.add((ContinuousOrientedCurve2D)curve);
        }
        return new CurveArray2D(curves);
    }

    @Override
    public CurveSet2D<? extends ContinuousOrientedCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        CurveArray2D<ContinuousOrientedCurve2D> result = new CurveArray2D<ContinuousOrientedCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof ContinuousOrientedCurve2D)) continue;
            result.add((ContinuousOrientedCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public ContourArray2D<? extends Contour2D> transform(AffineTransform2D trans) {
        ContourArray2D<Contour2D> result = new ContourArray2D<Contour2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            result.add((Contour2D)curve.transform(trans));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ContourArray2D)) {
            return false;
        }
        return super.equals(obj);
    }
}

