/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.domain;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.GeometricObject2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.UnboundedShape2DException;
import one.gfw.geom.math.geom2d.domain.Boundaries2D;
import one.gfw.geom.math.geom2d.domain.Boundary2D;
import one.gfw.geom.math.geom2d.domain.Contour2D;
import one.gfw.geom.math.geom2d.domain.Domain2D;
import one.gfw.geom.math.geom2d.polygon.LinearCurve2D;
import one.gfw.geom.math.geom2d.polygon.LinearRing2D;
import one.gfw.geom.math.geom2d.polygon.MultiPolygon2D;
import one.gfw.geom.math.geom2d.polygon.Polygon2D;

public class GenericDomain2D
implements Domain2D {
    protected Boundary2D boundary = null;

    public static GenericDomain2D create(Boundary2D boundary) {
        return new GenericDomain2D(boundary);
    }

    public GenericDomain2D(Boundary2D boundary) {
        this.boundary = boundary;
    }

    @Override
    public Polygon2D asPolygon(int n) {
        Collection<? extends Contour2D> contours = this.boundary.continuousCurves();
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>(contours.size());
        for (Contour2D contour2D : contours) {
            if (!contour2D.isBounded()) {
                throw new UnboundedShape2DException(this);
            }
            if (!contour2D.isClosed()) {
                throw new IllegalArgumentException("Can not transform open curve to linear ring");
            }
            LinearCurve2D poly = contour2D.asPolyline(n);
            assert (poly instanceof LinearRing2D) : "expected result as a linear ring";
            rings.add((LinearRing2D)poly);
        }
        return new MultiPolygon2D(rings);
    }

    @Override
    public Boundary2D boundary() {
        return this.boundary;
    }

    @Override
    public Collection<? extends Contour2D> contours() {
        return this.boundary.continuousCurves();
    }

    @Override
    public Domain2D complement() {
        return new GenericDomain2D(this.boundary.reverse());
    }

    @Override
    public double distance(Point2D p) {
        return Math.max(this.boundary.signedDistance(p.x(), p.y()), 0.0);
    }

    @Override
    public double distance(double x, double y) {
        return Math.max(this.boundary.signedDistance(x, y), 0.0);
    }

    @Override
    public boolean isBounded() {
        if (!this.boundary.isBounded()) {
            return false;
        }
        Box2D box = this.boundary.boundingBox();
        Point2D point = new Point2D(box.getMinX(), box.getMinY());
        return !this.boundary.isInside(point);
    }

    @Override
    public boolean isEmpty() {
        return this.boundary.isEmpty() && !this.contains(0.0, 0.0);
    }

    @Override
    public Domain2D clip(Box2D box) {
        return new GenericDomain2D(Boundaries2D.clipBoundary(this.boundary(), box));
    }

    @Override
    public Box2D boundingBox() {
        if (this.isBounded()) {
            return this.boundary.boundingBox();
        }
        return Box2D.INFINITE_BOX;
    }

    @Override
    public GenericDomain2D transform(AffineTransform2D trans) {
        Boundary2D transformed = this.boundary.transform(trans);
        if (!trans.isDirect()) {
            transformed = transformed.reverse();
        }
        return new GenericDomain2D(transformed);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.boundary.signedDistance(x, y) <= 0.0;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public void draw(Graphics2D g2) {
        this.boundary.draw(g2);
    }

    @Override
    public void fill(Graphics2D g2) {
        this.boundary.fill(g2);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericDomain2D)) {
            return false;
        }
        GenericDomain2D domain = (GenericDomain2D)obj;
        return this.boundary.almostEquals(domain.boundary, eps);
    }

    public String toString() {
        return "GenericDomain2D(boundary=" + this.boundary + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericDomain2D)) {
            return false;
        }
        GenericDomain2D domain = (GenericDomain2D)obj;
        return this.boundary.equals(domain.boundary);
    }
}

