/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.grid.Grid2D;
import one.gfw.geom.math.geom2d.line.LineSegment2D;
import one.gfw.geom.math.geom2d.line.LinearShape2D;
import one.gfw.geom.math.geom2d.line.StraightLine2D;
import one.gfw.geom.math.geom2d.point.PointArray2D;
import one.gfw.geom.math.geom2d.point.PointSet2D;

public class TriangleGrid2D
implements Grid2D {
    double x0 = 0.0;
    double y0 = 0.0;
    double s = 1.0;
    double theta = 0.0;

    private static final boolean isEven(int n) {
        return Math.abs((double)n * 0.5 - Math.floor((double)n * 0.5)) < 0.25;
    }

    public TriangleGrid2D() {
        this(0.0, 0.0, 1.0, 0.0);
    }

    public TriangleGrid2D(double s) {
        this(0.0, 0.0, s, 0.0);
    }

    public TriangleGrid2D(double x0, double y0) {
        this(x0, y0, 1.0, 0.0);
    }

    public TriangleGrid2D(double x0, double y0, double s) {
        this(x0, y0, s, 0.0);
    }

    public TriangleGrid2D(double x0, double y0, double s, double theta) {
        this.x0 = x0;
        this.y0 = y0;
        this.s = s;
        this.theta = theta;
    }

    public TriangleGrid2D(Point2D point) {
        this(point.x(), point.y(), 1.0, 0.0);
    }

    public TriangleGrid2D(Point2D point, double s) {
        this(point.x(), point.y(), s, 0.0);
    }

    public TriangleGrid2D(Point2D point, double s, double theta) {
        this(point.x(), point.y(), s, theta);
    }

    @Deprecated
    public void setOrigin(Point2D point) {
        this.x0 = point.getX();
        this.y0 = point.getY();
    }

    @Override
    public Point2D getOrigin() {
        return new Point2D(this.x0, this.y0);
    }

    public double getSize() {
        return this.s;
    }

    @Deprecated
    public void setSize(double s) {
        this.s = s;
    }

    @Deprecated
    public void setAngle(double theta) {
        this.theta = theta;
    }

    public double getTheta() {
        return this.theta;
    }

    @Override
    public Point2D getClosestVertex(Point2D point) {
        double d3;
        Point2D p3;
        Point2D p2;
        Point2D p1;
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        StraightLine2D baseLine = new StraightLine2D(this.x0, this.y0, cot, sit);
        double s2 = this.s * Math.sqrt(3.0) / 2.0;
        double d = baseLine.signedDistance(point);
        int n1 = (int)Math.floor(d / s2);
        int n2 = (int)Math.ceil(d / s2);
        StraightLine2D line1 = baseLine.parallel((double)n1 * s2);
        StraightLine2D line2 = baseLine.parallel((double)n2 * s2);
        double t = line1.project(new Point2D(point));
        if (TriangleGrid2D.isEven(n1)) {
            p1 = line1.point(Math.floor(t / this.s) * this.s);
            p2 = line1.point(Math.ceil(t / this.s) * this.s);
            p3 = line2.point((Math.floor(t / this.s) + 0.5) * this.s);
        } else {
            p1 = line1.point((Math.floor(t / this.s) + 0.5) * this.s);
            p2 = line2.point(Math.floor(t / this.s) * this.s);
            p3 = line2.point(Math.ceil(t / this.s) * this.s);
        }
        Point2D res = p1;
        double minDist = res.distance(point);
        double d2 = p2.distance(point);
        if (d2 < minDist) {
            res = p2;
            minDist = d2;
        }
        if ((d3 = p3.distance(point)) < minDist) {
            res = p3;
            minDist = d3;
        }
        return res;
    }

    @Override
    public Collection<LineSegment2D> getEdges(Box2D box) {
        ArrayList<LineSegment2D> array = new ArrayList<LineSegment2D>();
        double d = this.s * Math.sqrt(3.0) / 2.0;
        for (int k = 0; k < 3; ++k) {
            double theta2 = this.theta + Math.PI * (double)k / 3.0;
            double cot = Math.cos(theta2);
            double sit = Math.sin(theta2);
            StraightLine2D baseLine = new StraightLine2D(this.x0, this.y0, cot, sit);
            double dmin = Double.POSITIVE_INFINITY;
            double dmax = Double.NEGATIVE_INFINITY;
            for (Point2D point : box.vertices()) {
                double dist = baseLine.signedDistance(point);
                dmin = Math.min(dmin, dist);
                dmax = Math.max(dmax, dist);
            }
            double s2 = this.s * Math.sqrt(3.0) / 2.0;
            int i0 = (int)Math.ceil(dmin / s2);
            int i1 = (int)Math.floor(dmax / s2);
            for (int i = i0; i <= i1; ++i) {
                StraightLine2D line = baseLine.parallel(d * (double)i);
                Iterator iterator = line.clip(box).iterator();
                while (iterator.hasNext()) {
                    LinearShape2D arc = (LinearShape2D)iterator.next();
                    if (!(arc instanceof LineSegment2D)) continue;
                    array.add((LineSegment2D)arc);
                }
            }
        }
        return array;
    }

    @Override
    public PointSet2D getVertices(Box2D box) {
        ArrayList<Point2D> array = new ArrayList<Point2D>();
        double d = this.s * Math.sqrt(3.0) / 2.0;
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        StraightLine2D baseLine = new StraightLine2D(this.x0, this.y0, cot, sit);
        double dmin = Double.POSITIVE_INFINITY;
        double dmax = Double.NEGATIVE_INFINITY;
        for (Point2D point : box.vertices()) {
            double dist = baseLine.signedDistance(point);
            dmin = Math.min(dmin, dist);
            dmax = Math.max(dmax, dist);
        }
        int i0 = (int)Math.ceil(dmin / this.s);
        int i1 = (int)Math.floor(dmax / this.s);
        for (int i = i0; i <= i1; ++i) {
            StraightLine2D line = baseLine.parallel(d * (double)i);
            LineSegment2D seg = (LineSegment2D)line.clip(box).firstCurve();
            double t1 = line.position(seg.firstPoint());
            double t2 = line.position(seg.lastPoint());
            double t0 = TriangleGrid2D.isEven(i) ? 0.0 : this.s * 0.5;
            int j0 = (int)Math.ceil((t1 - t0) / this.s);
            int j1 = (int)Math.floor((t2 - t0) / this.s);
            if (j1 < j0) continue;
            for (int j = j0; j <= j1; ++j) {
                array.add(line.point((double)j * this.s + t0));
            }
        }
        return new PointArray2D(array);
    }
}

