/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.line;

import java.util.ArrayList;
import java.util.Collection;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.Vector2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearDomain2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearElement2D;
import one.gfw.geom.math.geom2d.circulinear.buffer.BufferCalculator;
import one.gfw.geom.math.geom2d.conic.Circle2D;
import one.gfw.geom.math.geom2d.conic.CircleArc2D;
import one.gfw.geom.math.geom2d.curve.AbstractSmoothCurve2D;
import one.gfw.geom.math.geom2d.curve.ContinuousCurve2D;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.domain.SmoothOrientedCurve2D;
import one.gfw.geom.math.geom2d.line.DegeneratedLine2DException;
import one.gfw.geom.math.geom2d.line.InvertedRay2D;
import one.gfw.geom.math.geom2d.line.LineSegment2D;
import one.gfw.geom.math.geom2d.line.LinearElement2D;
import one.gfw.geom.math.geom2d.line.LinearShape2D;
import one.gfw.geom.math.geom2d.line.Ray2D;
import one.gfw.geom.math.geom2d.line.StraightLine2D;
import one.gfw.geom.math.geom2d.transform.CircleInversion2D;

public abstract class AbstractLine2D
extends AbstractSmoothCurve2D
implements SmoothOrientedCurve2D,
LinearElement2D {
    protected double x0;
    protected double y0;
    protected double dx;
    protected double dy;

    public static Point2D getIntersection(AbstractLine2D line1, AbstractLine2D line2) {
        double denom = line1.dx * line2.dy - line1.dy * line2.dx;
        if (Math.abs(denom) < 1.0E-12) {
            return null;
        }
        double t = ((line1.y0 - line2.y0) * line2.dx - (line1.x0 - line2.x0) * line2.dy) / denom;
        return new Point2D(line1.x0 + t * line1.dx, line1.y0 + t * line1.dy);
    }

    public static boolean isColinear(AbstractLine2D line1, AbstractLine2D line2) {
        if (Math.abs(line1.dx * line2.dy - line1.dy * line2.dx) > 1.0E-12) {
            return false;
        }
        return Math.abs((line2.y0 - line1.y0) * line2.dx - (line2.x0 - line1.x0) * line2.dy) / Math.hypot(line2.dx, line2.dy) < 1.0E-12;
    }

    public static boolean isParallel(AbstractLine2D line1, AbstractLine2D line2) {
        return Math.abs(line1.dx * line2.dy - line1.dy * line2.dx) < 1.0E-12;
    }

    protected AbstractLine2D(double x0, double y0, double dx, double dy) {
        this.x0 = x0;
        this.y0 = y0;
        this.dx = dx;
        this.dy = dy;
    }

    protected AbstractLine2D(Point2D point, Vector2D vector) {
        this.x0 = point.x();
        this.y0 = point.y();
        this.dx = vector.x();
        this.dy = vector.y();
    }

    protected AbstractLine2D(LinearShape2D line) {
        this(line.origin(), line.direction());
    }

    public boolean isColinear(LinearShape2D linear) {
        if (!this.isParallel(linear)) {
            return false;
        }
        StraightLine2D line = linear.supportingLine();
        if (Math.abs(this.dx) > Math.abs(this.dy)) {
            return !(Math.abs((line.x0 - this.x0) * this.dy / this.dx + this.y0 - line.y0) > 1.0E-12);
        }
        return !(Math.abs((line.y0 - this.y0) * this.dx / this.dy + this.x0 - line.x0) > 1.0E-12);
    }

    public boolean isParallel(LinearShape2D line) {
        return Vector2D.isColinear(this.direction(), line.direction());
    }

    protected boolean supportContains(double x, double y) {
        double denom = Math.hypot(this.dx, this.dy);
        if (denom < 1.0E-12) {
            throw new DegeneratedLine2DException(this);
        }
        return Math.abs((x - this.x0) * this.dy - (y - this.y0) * this.dx) / denom < 1.0E-12;
    }

    public double[][] parametric() {
        double[][] tab = new double[2][2];
        tab[0][0] = this.x0;
        tab[0][1] = this.dx;
        tab[1][0] = this.y0;
        tab[1][1] = this.dy;
        return tab;
    }

    public double[] cartesianEquation() {
        double[] tab = new double[]{this.dy, -this.dx, this.dx * this.y0 - this.dy * this.x0};
        return tab;
    }

    public double[] polarCoefficients() {
        double[] tab = new double[2];
        double d = this.signedDistance(0.0, 0.0);
        tab[0] = Math.abs(d);
        tab[1] = d > 0.0 ? (this.horizontalAngle() + Math.PI) % (Math.PI * 2) : this.horizontalAngle();
        return tab;
    }

    public double[] polarCoefficientsSigned() {
        double[] tab = new double[]{this.signedDistance(0.0, 0.0), this.horizontalAngle()};
        return tab;
    }

    public double positionOnLine(Point2D point) {
        return this.positionOnLine(point.x(), point.y());
    }

    public double positionOnLine(double x, double y) {
        double denom = this.dx * this.dx + this.dy * this.dy;
        if (Math.abs(denom) < 1.0E-12) {
            throw new DegeneratedLine2DException(this);
        }
        return ((y - this.y0) * this.dy + (x - this.x0) * this.dx) / denom;
    }

    public Point2D projectedPoint(Point2D p) {
        return this.projectedPoint(p.x(), p.y());
    }

    public Point2D projectedPoint(double x, double y) {
        if (this.contains(x, y)) {
            return new Point2D(x, y);
        }
        double t = this.positionOnLine(x, y);
        return new Point2D(this.x0 + t * this.dx, this.y0 + t * this.dy);
    }

    public Point2D getSymmetric(Point2D p) {
        return this.getSymmetric(p.x(), p.y());
    }

    public Point2D getSymmetric(double x, double y) {
        double t = 2.0 * this.positionOnLine(x, y);
        return new Point2D(2.0 * this.x0 + t * this.dx - x, 2.0 * this.y0 + t * this.dy - y);
    }

    public StraightLine2D parallel(Point2D point) {
        return new StraightLine2D(point, this.dx, this.dy);
    }

    public StraightLine2D perpendicular(Point2D point) {
        return new StraightLine2D(point, -this.dy, this.dx);
    }

    @Override
    public Point2D origin() {
        return new Point2D(this.x0, this.y0);
    }

    @Override
    public Vector2D direction() {
        return new Vector2D(this.dx, this.dy);
    }

    @Override
    public double horizontalAngle() {
        return (Math.atan2(this.dy, this.dx) + Math.PI * 2) % (Math.PI * 2);
    }

    @Override
    public Point2D intersection(LinearShape2D line) {
        Vector2D vect = line.direction();
        double dx2 = vect.x();
        double dy2 = vect.y();
        double denom = this.dx * dy2 - this.dy * dx2;
        if (Math.abs(denom) < 1.0E-12) {
            return null;
        }
        Point2D origin = line.origin();
        double x2 = origin.x();
        double y2 = origin.y();
        double t = ((this.y0 - y2) * dx2 - (this.x0 - x2) * dy2) / denom;
        Point2D point = new Point2D(this.x0 + t * this.dx, this.y0 + t * this.dy);
        if (this.contains(point) && line.contains(point)) {
            return point;
        }
        return null;
    }

    @Override
    public StraightLine2D supportingLine() {
        return new StraightLine2D(this);
    }

    @Override
    public double length() {
        if (!this.isBounded()) {
            return Double.POSITIVE_INFINITY;
        }
        return (this.t1() - this.t0()) * Math.hypot(this.dx, this.dy);
    }

    @Override
    public double length(double pos) {
        return pos * Math.hypot(this.dx, this.dy);
    }

    @Override
    public double position(double distance) {
        double delta = Math.hypot(this.dx, this.dy);
        if (delta < 1.0E-12) {
            throw new DegeneratedLine2DException(this);
        }
        return distance / delta;
    }

    @Override
    public CirculinearElement2D transform(CircleInversion2D inv) {
        Point2D center = inv.center();
        double r = inv.radius();
        StraightLine2D line = this.supportingLine();
        Point2D po = line.projectedPoint(center);
        double d = line.distance(center);
        boolean inf0 = Double.isInfinite(this.t0());
        boolean inf1 = Double.isInfinite(this.t1());
        if (Math.abs(d) < 1.0E-12) {
            if (inf0) {
                if (inf1) {
                    return new StraightLine2D(this);
                }
                Point2D p2 = this.lastPoint().transform(inv);
                return new InvertedRay2D(p2, this.direction());
            }
            Point2D p1 = this.firstPoint().transform(inv);
            if (inf1) {
                return new Ray2D(p1, this.direction());
            }
            Point2D p2 = this.lastPoint().transform(inv);
            return new LineSegment2D(p1, p2);
        }
        double angle = Angle2D.horizontalAngle(center, po);
        double r2 = r * r / d / 2.0;
        Point2D c2 = Point2D.createPolar(center, r2, angle);
        boolean direct = this.isInside(center);
        if (inf0 && inf1) {
            return new Circle2D(c2, r2, direct);
        }
        Point2D p1 = inf0 ? center : this.firstPoint().transform(inv);
        Point2D p2 = inf1 ? center : this.lastPoint().transform(inv);
        double theta1 = Angle2D.horizontalAngle(c2, p1);
        double theta2 = Angle2D.horizontalAngle(c2, p2);
        return new CircleArc2D(c2, r2, theta1, theta2, direct);
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public double windingAngle(Point2D point) {
        double t0 = this.t0();
        double t1 = this.t1();
        double angle1 = t0 == Double.NEGATIVE_INFINITY ? Angle2D.horizontalAngle(-this.dx, -this.dy) : Angle2D.horizontalAngle(point.x(), point.y(), this.x0 + t0 * this.dx, this.y0 + t0 * this.dy);
        double angle2 = t1 == Double.POSITIVE_INFINITY ? Angle2D.horizontalAngle(this.dx, this.dy) : Angle2D.horizontalAngle(point.x(), point.y(), this.x0 + t1 * this.dx, this.y0 + t1 * this.dy);
        if (this.isInside(point)) {
            if (angle2 > angle1) {
                return angle2 - angle1;
            }
            return Math.PI * 2 - angle1 + angle2;
        }
        if (angle2 > angle1) {
            return angle2 - angle1 - Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        double delta = Math.hypot(this.dx, this.dy);
        if (delta < 1.0E-12) {
            throw new DegeneratedLine2DException(this);
        }
        return ((x - this.x0) * this.dy - (y - this.y0) * this.dx) / delta;
    }

    @Override
    public boolean isInside(Point2D p) {
        return (p.x() - this.x0) * this.dy - (p.y() - this.y0) * this.dx < 0.0;
    }

    @Override
    public Vector2D tangent(double t) {
        return new Vector2D(this.dx, this.dy);
    }

    @Override
    public double curvature(double t) {
        return 0.0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public Collection<? extends AbstractLine2D> smoothPieces() {
        return AbstractLine2D.wrapCurve(this);
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        if (this.isParallel(line)) {
            return new ArrayList<Point2D>(0);
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>(1);
        Point2D point = this.intersection(line);
        if (point != null) {
            points.add(point);
        }
        return points;
    }

    @Override
    public double position(Point2D point) {
        double pos = this.positionOnLine(point);
        double eps = Math.hypot(this.dx, this.dy) * 1.0E-12;
        if (pos < this.t0() - eps) {
            return Double.NaN;
        }
        if (pos > this.t1() + eps) {
            return Double.NaN;
        }
        return pos;
    }

    @Override
    public double project(Point2D point) {
        double pos = this.positionOnLine(point);
        return Math.min(Math.max(pos, this.t0()), this.t1());
    }

    @Override
    public AbstractLine2D subCurve(double t0, double t1) {
        t0 = Math.max(t0, this.t0());
        if (Double.isInfinite(t1 = Math.min(t1, this.t1()))) {
            if (Double.isInfinite(t0)) {
                return new StraightLine2D(this);
            }
            return new Ray2D(this.point(t0), this.direction());
        }
        if (Double.isInfinite(t0)) {
            return new InvertedRay2D(this.point(t1), this.direction());
        }
        return new LineSegment2D(this.point(t0), this.point(t1));
    }

    public Collection<? extends AbstractLine2D> continuousCurves() {
        return AbstractLine2D.wrapCurve(this);
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        Point2D proj = this.projectedPoint(x, y);
        if (this.contains(proj)) {
            return proj.distance(x, y);
        }
        double dist = Double.POSITIVE_INFINITY;
        if (!Double.isInfinite(this.t0())) {
            dist = this.firstPoint().distance(x, y);
        }
        if (!Double.isInfinite(this.t1())) {
            dist = Math.min(dist, this.lastPoint().distance(x, y));
        }
        return dist;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean isEmpty() {
        return Math.hypot(this.dx, this.dy) < 1.0E-12;
    }

    @Override
    public abstract AbstractLine2D transform(AffineTransform2D var1);

    @Override
    public CurveSet2D<? extends AbstractLine2D> clip(Box2D box) {
        CurveSet2D<ContinuousCurve2D> set = Curves2D.clipContinuousCurve(this, box);
        CurveArray2D<AbstractLine2D> result = new CurveArray2D<AbstractLine2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof AbstractLine2D)) continue;
            result.add((AbstractLine2D)curve2D);
        }
        return result;
    }

    @Override
    public abstract AbstractLine2D clone();
}

