/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.polygon;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.GeometricObject2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearBoundary2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearContourArray2D;
import one.gfw.geom.math.geom2d.circulinear.CirculinearDomain2D;
import one.gfw.geom.math.geom2d.circulinear.GenericCirculinearDomain2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.domain.Boundary2D;
import one.gfw.geom.math.geom2d.domain.ContourArray2D;
import one.gfw.geom.math.geom2d.domain.Domain2D;
import one.gfw.geom.math.geom2d.line.LineSegment2D;
import one.gfw.geom.math.geom2d.polygon.LinearCurve2D;
import one.gfw.geom.math.geom2d.polygon.LinearRing2D;
import one.gfw.geom.math.geom2d.polygon.Polygon2D;
import one.gfw.geom.math.geom2d.polygon.Polygons2D;
import one.gfw.geom.math.geom2d.polygon.SimplePolygon2D;
import one.gfw.geom.math.geom2d.transform.CircleInversion2D;

public class MultiPolygon2D
implements Domain2D,
Polygon2D {
    ArrayList<LinearRing2D> rings = new ArrayList();

    public static MultiPolygon2D create(Collection<LinearRing2D> rings) {
        return new MultiPolygon2D(rings);
    }

    public static MultiPolygon2D create(LinearRing2D ... rings) {
        return new MultiPolygon2D(rings);
    }

    public MultiPolygon2D() {
    }

    public MultiPolygon2D(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public MultiPolygon2D(LinearRing2D ... rings) {
        for (LinearRing2D ring : rings) {
            this.rings.add(ring);
        }
    }

    public MultiPolygon2D(SimplePolygon2D polygon) {
        this.rings.addAll(((CurveArray2D)((Object)polygon.boundary())).curves());
    }

    public MultiPolygon2D(Collection<LinearRing2D> lines) {
        this.rings.addAll(lines);
    }

    public void addRing(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public void insertRing(int index, LinearRing2D ring) {
        this.rings.add(index, ring);
    }

    public void removeRing(LinearRing2D ring) {
        this.rings.remove(ring);
    }

    public void clearRings() {
        this.rings.clear();
    }

    public LinearRing2D getRing(int index) {
        return this.rings.get(index);
    }

    public void setRing(int index, LinearRing2D ring) {
        this.rings.set(index, ring);
    }

    public int ringNumber() {
        return this.rings.size();
    }

    @Override
    public double area() {
        return Polygons2D.computeArea(this);
    }

    @Override
    public Point2D centroid() {
        return Polygons2D.computeCentroid(this);
    }

    public Collection<LineSegment2D> edges() {
        int nEdges = this.edgeNumber();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(nEdges);
        for (LinearRing2D ring : this.rings) {
            edges.addAll(ring.edges());
        }
        return edges;
    }

    @Override
    public int edgeNumber() {
        int count = 0;
        for (LinearRing2D ring : this.rings) {
            count += ring.vertexNumber();
        }
        return count;
    }

    @Override
    public Collection<Point2D> vertices() {
        int nv = this.vertexNumber();
        ArrayList<Point2D> points = new ArrayList<Point2D>(nv);
        for (LinearRing2D ring : this.rings) {
            points.addAll(ring.vertices());
        }
        return points;
    }

    @Override
    public Point2D vertex(int i) {
        int count = 0;
        LinearCurve2D boundary = null;
        for (LinearRing2D ring : this.rings) {
            int nv = ring.vertexNumber();
            if (count + nv > i) {
                boundary = ring;
                break;
            }
            count += nv;
        }
        if (boundary == null) {
            throw new IndexOutOfBoundsException();
        }
        return boundary.vertex(i - count);
    }

    @Override
    public void setVertex(int i, Point2D point) {
        int count = 0;
        LinearCurve2D boundary = null;
        for (LinearRing2D ring : this.rings) {
            int nv = ring.vertexNumber();
            if (count + nv > i) {
                boundary = ring;
                break;
            }
            count += nv;
        }
        if (boundary == null) {
            throw new IndexOutOfBoundsException();
        }
        boundary.setVertex(i - count, point);
    }

    @Override
    public void addVertex(Point2D position) {
        if (this.rings.size() == 0) {
            throw new RuntimeException("Can not add a vertex to a multipolygon with no ring");
        }
        LinearRing2D ring = this.rings.get(this.rings.size() - 1);
        ring.addVertex(position);
    }

    @Override
    public void insertVertex(int index, Point2D point) {
        if (this.rings.size() == 0) {
            throw new RuntimeException("Can not add a vertex to a multipolygon with no ring");
        }
        int nv = this.vertexNumber();
        if (nv <= index) {
            throw new IllegalArgumentException("Can not insert vertex at position " + index + " (max is " + nv + ")");
        }
        int count = 0;
        LinearCurve2D boundary = null;
        for (LinearRing2D ring : this.rings) {
            nv = ring.vertexNumber();
            if (count + nv > index) {
                boundary = ring;
                break;
            }
            count += nv;
        }
        if (boundary == null) {
            throw new IndexOutOfBoundsException();
        }
        boundary.insertVertex(index - count, point);
    }

    @Override
    public void removeVertex(int i) {
        int count = 0;
        LinearCurve2D boundary = null;
        for (LinearRing2D ring : this.rings) {
            int nv = ring.vertexNumber();
            if (count + nv > i) {
                boundary = ring;
                break;
            }
            count += nv;
        }
        if (boundary == null) {
            throw new IndexOutOfBoundsException();
        }
        boundary.removeVertex(i - count);
    }

    @Override
    public int vertexNumber() {
        int count = 0;
        for (LinearRing2D ring : this.rings) {
            count += ring.vertexNumber();
        }
        return count;
    }

    @Override
    public int closestVertexIndex(Point2D point) {
        double minDist = Double.POSITIVE_INFINITY;
        int index = -1;
        int i = 0;
        for (LinearRing2D ring : this.rings) {
            for (Point2D vertex : ring.vertices()) {
                double dist = vertex.distance(point);
                if (dist < minDist) {
                    index = i;
                    minDist = dist;
                }
                ++i;
            }
        }
        return index;
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        return new GenericCirculinearDomain2D((CirculinearBoundary2D)((Object)((CirculinearContourArray2D)((CirculinearContourArray2D)this.boundary()).transform(inv)).reverse()));
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        return Polygons2D.createBuffer(this, dist);
    }

    @Override
    public Polygon2D asPolygon(int n) {
        return this;
    }

    @Override
    public CirculinearContourArray2D<LinearRing2D> boundary() {
        return CirculinearContourArray2D.create2(this.rings);
    }

    public Collection<LinearRing2D> contours() {
        return Collections.unmodifiableList(this.rings);
    }

    @Override
    public Polygon2D complement() {
        ArrayList<LinearRing2D> reverseLines = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            reverseLines.add(ring.reverse());
        }
        return new MultiPolygon2D(reverseLines);
    }

    @Override
    public Box2D boundingBox() {
        Box2D box = new Box2D(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (LinearRing2D ring : this.rings) {
            box = box.union(ring.boundingBox());
        }
        return box;
    }

    @Override
    public Polygon2D clip(Box2D box) {
        return Polygons2D.clipPolygon(this, box);
    }

    @Override
    public double distance(Point2D p) {
        return Math.max(((ContourArray2D)this.boundary()).signedDistance(p), 0.0);
    }

    @Override
    public double distance(double x, double y) {
        return Math.max(((ContourArray2D)this.boundary()).signedDistance(x, y), 0.0);
    }

    @Override
    public boolean isBounded() {
        Boundary2D boundary = this.boundary();
        if (!boundary.isBounded()) {
            return false;
        }
        double area = 0.0;
        for (LinearRing2D ring : this.rings) {
            area += ring.area();
        }
        return area > 0.0;
    }

    @Override
    public boolean isEmpty() {
        for (LinearRing2D ring : this.rings) {
            if (ring.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MultiPolygon2D transform(AffineTransform2D trans) {
        ArrayList<LinearRing2D> transformed = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            transformed.add(ring.transform(trans));
        }
        return new MultiPolygon2D(transformed);
    }

    @Override
    public boolean contains(Point2D point) {
        double angle = 0.0;
        for (LinearRing2D ring : this.rings) {
            angle += ring.windingAngle(point);
        }
        double area = this.area();
        if (area > 0.0) {
            return angle > Math.PI;
        }
        return angle > -Math.PI;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D(x, y));
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(((CurveArray2D)((Object)this.boundary())).getGeneralPath());
    }

    @Override
    public void fill(Graphics2D g) {
        g.fill(((CurveArray2D)((Object)this.boundary())).getGeneralPath());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiPolygon2D)) {
            return false;
        }
        MultiPolygon2D polygon = (MultiPolygon2D)obj;
        if (polygon.rings.size() != this.rings.size()) {
            return false;
        }
        for (int i = 0; i < this.rings.size(); ++i) {
            if (this.rings.get(i).almostEquals(polygon.rings.get(i), eps)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiPolygon2D)) {
            return false;
        }
        MultiPolygon2D polygon = (MultiPolygon2D)obj;
        if (polygon.rings.size() != this.rings.size()) {
            return false;
        }
        for (int i = 0; i < this.rings.size(); ++i) {
            if (this.rings.get(i).equals(polygon.rings.get(i))) continue;
            return false;
        }
        return true;
    }

    public MultiPolygon2D clone() {
        ArrayList<LinearRing2D> array = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            array.add(ring.clone());
        }
        return new MultiPolygon2D(array);
    }
}

