/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.polygon.convhull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.polygon.Polygon2D;
import one.gfw.geom.math.geom2d.polygon.SimplePolygon2D;
import one.gfw.geom.math.geom2d.polygon.convhull.ConvexHull2D;

public class GrahamScan2D
implements ConvexHull2D {
    @Override
    public Polygon2D convexHull(Collection<? extends Point2D> points) {
        int nbPoints = points.size();
        Point2D lowestPoint = null;
        double lowestY = Double.MAX_VALUE;
        for (Point2D point2D : points) {
            double y = point2D.y();
            if (!(y < lowestY)) continue;
            lowestPoint = point2D;
            lowestY = y;
        }
        CompareByPseudoAngle comparator = new CompareByPseudoAngle(lowestPoint);
        ArrayList<? extends Point2D> arrayList = new ArrayList<Point2D>(nbPoints);
        arrayList.addAll(points);
        Collections.sort(arrayList, comparator);
        int m = 2;
        for (int i = 3; i < nbPoints; ++i) {
            while (Point2D.ccw((Point2D)arrayList.get(m), (Point2D)arrayList.get(m - 1), (Point2D)arrayList.get(i)) >= 0) {
                --m;
            }
            Collections.swap(arrayList, ++m, i);
        }
        List hull = arrayList.subList(0, Math.min(m + 1, nbPoints));
        return new SimplePolygon2D(hull);
    }

    private class CompareByPseudoAngle
    implements Comparator<Point2D> {
        Point2D basePoint;

        public CompareByPseudoAngle(Point2D base) {
            this.basePoint = base;
        }

        @Override
        public int compare(Point2D point1, Point2D point2) {
            double angle2;
            double angle1 = Angle2D.pseudoAngle(this.basePoint, point1);
            if (angle1 < (angle2 = Angle2D.pseudoAngle(this.basePoint, point2))) {
                return -1;
            }
            if (angle1 > angle2) {
                return 1;
            }
            return 0;
        }
    }
}

