/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.polygon.convhull;

import java.util.ArrayList;
import java.util.Collection;
import one.gfw.geom.math.geom2d.Angle2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.polygon.Polygon2D;
import one.gfw.geom.math.geom2d.polygon.SimplePolygon2D;
import one.gfw.geom.math.geom2d.polygon.convhull.ConvexHull2D;

public class JarvisMarch2D
implements ConvexHull2D {
    /*
     * WARNING - void declaration
     */
    @Override
    public Polygon2D convexHull(Collection<? extends Point2D> points) {
        Point2D point2D;
        Point2D lowestPoint = null;
        double ymin = Double.MAX_VALUE;
        for (Point2D point2D2 : points) {
            double y = point2D2.y();
            if (!(y < ymin)) continue;
            ymin = y;
            lowestPoint = point2D2;
        }
        ArrayList<void> hullPoints = new ArrayList<void>();
        Point2D point2D3 = lowestPoint;
        Point2D nextPoint = null;
        double angle = 0.0;
        do {
            void var8_8;
            hullPoints.add(var8_8);
            nextPoint = this.findNextPoint((Point2D)var8_8, angle, points);
            angle = Angle2D.horizontalAngle((Point2D)var8_8, nextPoint);
        } while ((point2D = nextPoint) != lowestPoint);
        return new SimplePolygon2D(hullPoints);
    }

    private Point2D findNextPoint(Point2D basePoint, double startAngle, Collection<? extends Point2D> points) {
        Point2D minPoint = null;
        double minAngle = Double.MAX_VALUE;
        for (Point2D point2D : points) {
            if (basePoint.equals(point2D)) continue;
            double angle = Angle2D.horizontalAngle(basePoint, point2D);
            if (!((angle = Angle2D.formatAngle(angle - startAngle)) < minAngle)) continue;
            minAngle = angle;
            minPoint = point2D;
        }
        return minPoint;
    }
}

