/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.spline;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.GeometricObject2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.Vector2D;
import one.gfw.geom.math.geom2d.curve.AbstractSmoothCurve2D;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.curve.SmoothCurve2D;
import one.gfw.geom.math.geom2d.domain.ContinuousOrientedCurve2D;
import one.gfw.geom.math.geom2d.line.LinearShape2D;
import one.gfw.geom.math.geom2d.polygon.Polyline2D;

public class CubicBezierCurve2D
extends AbstractSmoothCurve2D
implements SmoothCurve2D,
ContinuousOrientedCurve2D,
Cloneable {
    protected double x1;
    protected double y1;
    protected double ctrlx1;
    protected double ctrly1;
    protected double ctrlx2;
    protected double ctrly2;
    protected double x2;
    protected double y2;

    @Deprecated
    public static final CubicBezierCurve2D create(Point2D p1, Point2D c1, Point2D c2, Point2D p2) {
        return new CubicBezierCurve2D(p1, c1, c2, p2);
    }

    @Deprecated
    public static final CubicBezierCurve2D create(Point2D p1, Vector2D v1, Point2D p2, Vector2D v2) {
        return new CubicBezierCurve2D(p1, v1, p2, v2);
    }

    public CubicBezierCurve2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public CubicBezierCurve2D(double[][] coefs) {
        this(coefs[0][0], coefs[1][0], coefs[0][0] + coefs[0][1] / 3.0, coefs[1][0] + coefs[1][1] / 3.0, coefs[0][0] + 2.0 * coefs[0][1] / 3.0 + coefs[0][2] / 3.0, coefs[1][0] + 2.0 * coefs[1][1] / 3.0 + coefs[1][2] / 3.0, coefs[0][0] + coefs[0][1] + coefs[0][2] + coefs[0][3], coefs[1][0] + coefs[1][1] + coefs[1][2] + coefs[1][3]);
    }

    public CubicBezierCurve2D(Point2D p1, Point2D ctrl1, Point2D ctrl2, Point2D p2) {
        this(p1.x(), p1.y(), ctrl1.x(), ctrl1.y(), ctrl2.x(), ctrl2.y(), p2.x(), p2.y());
    }

    public CubicBezierCurve2D(Point2D p1, Vector2D v1, Point2D p2, Vector2D v2) {
        this(p1.x(), p1.y(), p1.x() + v1.x() / 3.0, p1.y() + v1.y() / 3.0, p2.x() - v2.x() / 3.0, p2.y() - v2.y() / 3.0, p2.x(), p2.y());
    }

    public CubicBezierCurve2D(double x1, double y1, double xctrl1, double yctrl1, double xctrl2, double yctrl2, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx1 = xctrl1;
        this.ctrly1 = yctrl1;
        this.ctrlx2 = xctrl2;
        this.ctrly2 = yctrl2;
        this.x2 = x2;
        this.y2 = y2;
    }

    public Point2D getControl1() {
        return new Point2D(this.ctrlx1, this.ctrly1);
    }

    public Point2D getControl2() {
        return new Point2D(this.ctrlx2, this.ctrly2);
    }

    public Point2D getP1() {
        return this.firstPoint();
    }

    public Point2D getP2() {
        return this.lastPoint();
    }

    public Point2D getCtrlP1() {
        return this.getControl1();
    }

    public Point2D getCtrlP2() {
        return this.getControl2();
    }

    public double[][] getParametric() {
        double[][] tab = new double[2][4];
        tab[0][0] = this.x1;
        tab[0][1] = 3.0 * this.ctrlx1 - 3.0 * this.x1;
        tab[0][2] = 3.0 * this.x1 - 6.0 * this.ctrlx1 + 3.0 * this.ctrlx2;
        tab[0][3] = this.x2 - 3.0 * this.ctrlx2 + 3.0 * this.ctrlx1 - this.x1;
        tab[1][0] = this.y1;
        tab[1][1] = 3.0 * this.ctrly1 - 3.0 * this.y1;
        tab[1][2] = 3.0 * this.y1 - 6.0 * this.ctrly1 + 3.0 * this.ctrly2;
        tab[1][3] = this.y2 - 3.0 * this.ctrly2 + 3.0 * this.ctrly1 - this.y1;
        return tab;
    }

    @Override
    public double windingAngle(Point2D point) {
        return this.asPolyline(100).windingAngle(point);
    }

    @Override
    public boolean isInside(Point2D pt) {
        return this.asPolyline(100).isInside(pt);
    }

    @Override
    public double signedDistance(Point2D point) {
        if (this.isInside(point)) {
            return -this.distance(point.x(), point.y());
        }
        return this.distance(point.x(), point.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.distance(x, y);
        }
        return this.distance(x, y);
    }

    @Override
    public Vector2D tangent(double t) {
        double[][] c = this.getParametric();
        double dx = c[0][1] + (2.0 * c[0][2] + 3.0 * c[0][3] * t) * t;
        double dy = c[1][1] + (2.0 * c[1][2] + 3.0 * c[1][3] * t) * t;
        return new Vector2D(dx, dy);
    }

    @Override
    public double curvature(double t) {
        double[][] c = this.getParametric();
        double xp = c[0][1] + (2.0 * c[0][2] + 3.0 * c[0][3] * t) * t;
        double yp = c[1][1] + (2.0 * c[1][2] + 3.0 * c[1][3] * t) * t;
        double xs = 2.0 * c[0][2] + 6.0 * c[0][3] * t;
        double ys = 2.0 * c[1][2] + 6.0 * c[1][3] * t;
        return (xp * ys - yp * xs) / Math.pow(Math.hypot(xp, yp), 3.0);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Polyline2D asPolyline(int n) {
        double dt = 1.0 / (double)n;
        Point2D[] points = new Point2D[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            points[i] = this.point((double)i * dt);
        }
        return new Polyline2D(points);
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return 1.0;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        return this.asPolyline(100).intersections(line);
    }

    @Override
    public Point2D point(double t) {
        t = Math.min(Math.max(t, 0.0), 1.0);
        double[][] c = this.getParametric();
        double x = c[0][0] + (c[0][1] + (c[0][2] + c[0][3] * t) * t) * t;
        double y = c[1][0] + (c[1][1] + (c[1][2] + c[1][3] * t) * t) * t;
        return new Point2D(x, y);
    }

    @Override
    public Point2D firstPoint() {
        return new Point2D(this.x1, this.y1);
    }

    @Override
    public Point2D lastPoint() {
        return new Point2D(this.x2, this.y2);
    }

    @Override
    public double position(Point2D point) {
        int N = 100;
        return this.asPolyline(N).position(point) / (double)N;
    }

    @Override
    public double project(Point2D point) {
        int N = 100;
        return this.asPolyline(N).project(point) / (double)N;
    }

    @Override
    public CubicBezierCurve2D reverse() {
        return new CubicBezierCurve2D(this.lastPoint(), this.getControl1(), this.getControl2(), this.firstPoint());
    }

    @Override
    public CubicBezierCurve2D subCurve(double t0, double t1) {
        if ((t0 = Math.max(t0, 0.0)) > (t1 = Math.min(t1, 1.0))) {
            return null;
        }
        double dt = t1 - t0;
        Vector2D v0 = this.tangent(t0).times(dt);
        Vector2D v1 = this.tangent(t1).times(dt);
        return new CubicBezierCurve2D(this.point(t0), v0, this.point(t1), v1);
    }

    @Override
    public boolean contains(double x, double y) {
        return new CubicCurve2D.Double(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2).contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        return this.asPolyline(100).distance(x, y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CurveSet2D<? extends CubicBezierCurve2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<CubicBezierCurve2D> result = new CurveArray2D<CubicBezierCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof CubicBezierCurve2D)) continue;
            result.add((CubicBezierCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.getControl1();
        Point2D p3 = this.getControl2();
        Point2D p4 = this.lastPoint();
        double xmin = Math.min(Math.min(p1.x(), p2.x()), Math.min(p3.x(), p4.x()));
        double xmax = Math.max(Math.max(p1.x(), p2.x()), Math.max(p3.x(), p4.x()));
        double ymin = Math.min(Math.min(p1.y(), p2.y()), Math.min(p3.y(), p4.y()));
        double ymax = Math.max(Math.max(p1.y(), p2.y()), Math.max(p3.y(), p4.y()));
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public CubicBezierCurve2D transform(AffineTransform2D trans) {
        return new CubicBezierCurve2D(trans.transform(this.firstPoint()), trans.transform(this.getControl1()), trans.transform(this.getControl2()), trans.transform(this.lastPoint()));
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        Point2D p2 = this.getControl1();
        Point2D p3 = this.getControl2();
        Point2D p4 = this.lastPoint();
        path.curveTo(p2.x(), p2.y(), p3.x(), p3.y(), p4.x(), p4.y());
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.getControl1();
        Point2D p3 = this.getControl2();
        Point2D p4 = this.lastPoint();
        path.moveTo(p1.x(), p1.y());
        path.curveTo(p2.x(), p2.y(), p3.x(), p3.y(), p4.x(), p4.y());
        return path;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CubicBezierCurve2D)) {
            return false;
        }
        CubicBezierCurve2D bezier = (CubicBezierCurve2D)obj;
        if (Math.abs(this.x1 - bezier.x1) > eps) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > eps) {
            return false;
        }
        if (Math.abs(this.ctrlx1 - bezier.ctrlx1) > eps) {
            return false;
        }
        if (Math.abs(this.ctrly1 - bezier.ctrly1) > eps) {
            return false;
        }
        if (Math.abs(this.ctrlx2 - bezier.ctrlx2) > eps) {
            return false;
        }
        if (Math.abs(this.ctrly2 - bezier.ctrly2) > eps) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > eps) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > eps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CubicBezierCurve2D)) {
            return false;
        }
        CubicBezierCurve2D bezier = (CubicBezierCurve2D)obj;
        if (Math.abs(this.x1 - bezier.x1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx1 - bezier.ctrlx1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly1 - bezier.ctrly1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx2 - bezier.ctrlx2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly2 - bezier.ctrly2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > 1.0E-12);
    }

    @Override
    public CubicBezierCurve2D clone() {
        return new CubicBezierCurve2D(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }
}

