/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.geom.math.geom2d.spline;

import java.util.Collection;
import one.gfw.geom.math.geom2d.AffineTransform2D;
import one.gfw.geom.math.geom2d.Box2D;
import one.gfw.geom.math.geom2d.Point2D;
import one.gfw.geom.math.geom2d.Vector2D;
import one.gfw.geom.math.geom2d.curve.ContinuousCurve2D;
import one.gfw.geom.math.geom2d.curve.Curve2D;
import one.gfw.geom.math.geom2d.curve.CurveArray2D;
import one.gfw.geom.math.geom2d.curve.CurveSet2D;
import one.gfw.geom.math.geom2d.curve.Curves2D;
import one.gfw.geom.math.geom2d.curve.PolyCurve2D;
import one.gfw.geom.math.geom2d.spline.CubicBezierCurve2D;

public class PolyCubicBezierCurve2D
extends PolyCurve2D<CubicBezierCurve2D> {
    public static final PolyCubicBezierCurve2D create(Point2D ... points) {
        int np = points.length;
        int nc = (np - 1) / 3;
        PolyCubicBezierCurve2D polyBezier = new PolyCubicBezierCurve2D(nc);
        for (int i = 0; i < np - 3; i += 3) {
            polyBezier.add(new CubicBezierCurve2D(points[i], points[i + 1], points[i + 2], points[i + 3]));
        }
        return polyBezier;
    }

    public static final PolyCubicBezierCurve2D create(Point2D[] points, Vector2D[] vectors) {
        int np = Math.min(points.length, vectors.length);
        int nc = (np - 1) / 2;
        PolyCubicBezierCurve2D polyBezier = new PolyCubicBezierCurve2D(nc);
        for (int i = 0; i < nc - 1; i += 2) {
            polyBezier.add(new CubicBezierCurve2D(points[i], vectors[i], points[i + 1], vectors[i + 1]));
        }
        return polyBezier;
    }

    public PolyCubicBezierCurve2D() {
    }

    public PolyCubicBezierCurve2D(int n) {
        super(n);
    }

    public PolyCubicBezierCurve2D(CubicBezierCurve2D ... curves) {
        super((ContinuousCurve2D[])curves);
    }

    public PolyCubicBezierCurve2D(Collection<CubicBezierCurve2D> curves) {
        super(curves);
    }

    @Override
    public CurveSet2D<? extends PolyCubicBezierCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        CurveArray2D<PolyCubicBezierCurve2D> result = new CurveArray2D<PolyCubicBezierCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof PolyCubicBezierCurve2D)) continue;
            result.add((PolyCubicBezierCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public PolyCubicBezierCurve2D transform(AffineTransform2D trans) {
        PolyCubicBezierCurve2D result = new PolyCubicBezierCurve2D(this.curves.size());
        for (CubicBezierCurve2D curve : this.curves) {
            result.add(curve.transform(trans));
        }
        return result;
    }
}

