/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.launcher.DefaultCommand;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

@Name(value="version")
@Summary(value="Displays the version.")
@Description(value="Prints the vert.x core version used by the application.")
public class VersionCommand
extends DefaultCommand {
    private static final Logger log = LoggerFactory.getLogger(VersionCommand.class);
    private static String version;

    @Override
    public void run() throws CLIException {
        log.info(VersionCommand.getVersion());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        if (version != null) {
            return version;
        }
        try (InputStream is = VersionCommand.class.getClassLoader().getResourceAsStream("META-INF/vertx/vertx-version.txt");){
            if (is == null) {
                throw new IllegalStateException("Cannot find vertx-version.txt on classpath");
            }
            Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");
            try {
                version = scanner.hasNext() ? scanner.next().trim() : "";
                String string = version;
                if (scanner != null) {
                    scanner.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

