/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.net.impl.pool.Executor;
import io.vertx.core.net.impl.pool.Task;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class CombinerExecutor<S>
implements Executor<S> {
    private final Queue<Executor.Action<S>> q = PlatformDependent.newMpscQueue();
    private final AtomicInteger s = new AtomicInteger();
    private final S state;
    private final ThreadLocal<Task> current = new ThreadLocal();

    public CombinerExecutor(S state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Executor.Action<S> action) {
        this.q.add(action);
        if (this.s.get() != 0 || !this.s.compareAndSet(0, 1)) {
            return;
        }
        Task head = null;
        do {
            try {
                head = this.pollAndExecute(head);
            }
            finally {
                this.s.set(0);
            }
        } while (!this.q.isEmpty() && this.s.compareAndSet(0, 1));
        if (head != null) {
            Task inProgress = this.current.get();
            if (inProgress == null) {
                this.current.set(head);
                try {
                    while (head != null) {
                        head.run();
                        head = head.next;
                    }
                }
                finally {
                    this.current.remove();
                }
            } else {
                CombinerExecutor.merge(inProgress, head);
            }
        }
    }

    private Task pollAndExecute(Task head) {
        Executor.Action<S> action;
        while ((action = this.q.poll()) != null) {
            Task task = action.execute(this.state);
            if (task == null) continue;
            if (head == null) {
                head = task;
                continue;
            }
            CombinerExecutor.merge(head, task);
        }
        return head;
    }

    private static void merge(Task head, Task tail) {
        Task tmp = tail.prev;
        tail.prev = head.prev;
        head.prev.next = tail;
        head.prev = tmp;
    }
}

