package javax.persistence;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static javax.persistence.DiscriminatorType.STRING;


@Target({TYPE})
@Retention(RUNTIME)
public @interface DiscriminatorColumn {
    String name() default "DTYPE";

    DiscriminatorType discriminatorType() default STRING;

    String columnDefinition() default "";

    int length() default 31;
}
