package javax.persistence;

import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


@Target(TYPE)
@Retention(RUNTIME)
@Repeatable(NamedStoredProcedureQueries.class)
public @interface NamedStoredProcedureQuery {

    String name();

    String procedureName();

    StoredProcedureParameter[] parameters() default {};

    Class[] resultClasses() default {};

    String[] resultSetMappings() default {};

    QueryHint[] hints() default {};
}

