package javax.persistence;

import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


@Target(TYPE)
@Retention(RUNTIME)
@Repeatable(SecondaryTables.class)
public @interface SecondaryTable {

    String name();

    String catalog() default "";

    String schema() default "";

    PrimaryKeyJoinColumn[] pkJoinColumns() default {};

    UniqueConstraint[] uniqueConstraints() default {};

    Index[] indexes() default {};

    ForeignKey foreignKey() default @ForeignKey(ConstraintMode.PROVIDER_DEFAULT);
}
