package aj.org.objectweb.asm;

public abstract class RecordComponentVisitor {

    protected final int api;

    RecordComponentVisitor delegate;

    public RecordComponentVisitor(final int api) {
        this(api, null);
    }

    public RecordComponentVisitor(final int api, final RecordComponentVisitor recordComponentVisitor) {
        if (api != Opcodes.ASM9 && api != Opcodes.ASM8 && api != Opcodes.ASM7 && api != Opcodes.ASM6 && api != Opcodes.ASM5 && api != Opcodes.ASM4 && api != Opcodes.ASM10_EXPERIMENTAL) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        if (api == Opcodes.ASM10_EXPERIMENTAL) {
            Constants.checkAsmExperimental(this);
        }
        this.api = api;
        this.delegate = recordComponentVisitor;
    }

    public RecordComponentVisitor getDelegate() {
        return delegate;
    }

    public AnnotationVisitor visitAnnotation(final String descriptor, final boolean visible) {
        if (delegate != null) {
            return delegate.visitAnnotation(descriptor, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(final int typeRef, final TypePath typePath, final String descriptor, final boolean visible) {
        if (delegate != null) {
            return delegate.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }
        return null;
    }

    public void visitAttribute(final Attribute attribute) {
        if (delegate != null) {
            delegate.visitAttribute(attribute);
        }
    }

    public void visitEnd() {
        if (delegate != null) {
            delegate.visitEnd();
        }
    }
}
