package javax.persistence;

import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Target({TYPE})
@Retention(RUNTIME)
@Repeatable(NamedEntityGraphs.class)
public @interface NamedEntityGraph {

    String name() default "";

    NamedAttributeNode[] attributeNodes() default {};

    boolean includeAllAttributes() default false;

    NamedSubgraph[] subgraphs() default {};

    NamedSubgraph[] subclassSubgraphs() default {};
}
