package javax.persistence;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Query {

    List getResultList();

    Object getSingleResult();

    int executeUpdate();

    Query setMaxResults(int maxResult);

    int getMaxResults();

    Query setFirstResult(int startPosition);

    int getFirstResult();

    Query setHint(String hintName, Object value);

    Map<String, Object> getHints();

    <T> Query setParameter(Parameter<T> param, T value);

    Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType);

    Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType);

    Query setParameter(String name, Object value);

    Query setParameter(String name, Calendar value, TemporalType temporalType);

    Query setParameter(String name, Date value, TemporalType temporalType);

    Query setParameter(int position, Object value);

    Query setParameter(int position, Calendar value, TemporalType temporalType);

    Query setParameter(int position, Date value, TemporalType temporalType);

    Set<Parameter<?>> getParameters();

    Parameter<?> getParameter(String name);

    <T> Parameter<T> getParameter(String name, Class<T> type);

    Parameter<?> getParameter(int position);

    <T> Parameter<T> getParameter(int position, Class<T> type);

    boolean isBound(Parameter<?> param);

    <T> T getParameterValue(Parameter<T> param);

    Object getParameterValue(String name);

    Object getParameterValue(int position);

    Query setFlushMode(FlushModeType flushMode);

    FlushModeType getFlushMode();

    Query setLockMode(LockModeType lockMode);

    LockModeType getLockMode();

    <T> T unwrap(Class<T> cls);
}
