package javax.persistence;

import java.util.Calendar;
import java.util.Date;

public interface StoredProcedureQuery extends Query {

    StoredProcedureQuery setHint(String hintName, Object value);

    <T> StoredProcedureQuery setParameter(Parameter<T> param, T value);

    StoredProcedureQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType);

    StoredProcedureQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType);

    StoredProcedureQuery setParameter(String name, Object value);

    StoredProcedureQuery setParameter(String name, Calendar value, TemporalType temporalType);

    StoredProcedureQuery setParameter(String name, Date value, TemporalType temporalType);

    StoredProcedureQuery setParameter(int position, Object value);

    StoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType);

    StoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType);

    StoredProcedureQuery setFlushMode(FlushModeType flushMode);

    StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode);

    StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode);

    Object getOutputParameterValue(int position);

    Object getOutputParameterValue(String parameterName);

    boolean execute();

    boolean hasMoreResults();

    int getUpdateCount();
}
