package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AnnotationDefault extends Attribute {

    private ElementValue value;

    public AnnotationDefault(int nameIndex, int len, DataInputStream dis, ConstantPool cpool) throws IOException {
        this(nameIndex, len, ElementValue.readElementValue(dis, cpool), cpool);
    }

    private AnnotationDefault(int nameIndex, int len, ElementValue value, ConstantPool cpool) {
        super(Constants.ATTR_ANNOTATION_DEFAULT, nameIndex, len, cpool);
        this.value = value;
    }

    public Attribute copy(ConstantPool constant_pool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public final ElementValue getElementValue() {
        return value;
    }

    public final void dump(DataOutputStream dos) throws IOException {
        super.dump(dos);
        value.dump(dos);
    }

    public void accept(ClassVisitor v) {
        v.visitAnnotationDefault(this);
    }
}
