package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisTypeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisTypeAnnos;

public interface ClassVisitor {

    void visitCode(Code obj);

    void visitCodeException(CodeException obj);

    void visitConstantClass(ConstantClass obj);

    void visitConstantDouble(ConstantDouble obj);

    void visitConstantFieldref(ConstantFieldref obj);

    void visitConstantFloat(ConstantFloat obj);

    void visitConstantInteger(ConstantInteger obj);

    void visitConstantInterfaceMethodref(ConstantInterfaceMethodref obj);

    void visitConstantLong(ConstantLong obj);

    void visitConstantMethodref(ConstantMethodref obj);

    void visitConstantMethodHandle(ConstantMethodHandle obj);

    void visitConstantNameAndType(ConstantNameAndType obj);

    void visitConstantMethodType(ConstantMethodType obj);

    void visitConstantInvokeDynamic(ConstantInvokeDynamic obj);

    void visitConstantDynamic(ConstantDynamic obj);

    void visitConstantPool(ConstantPool obj);

    void visitConstantString(ConstantString obj);

    void visitConstantModule(ConstantModule obj);

    void visitConstantPackage(ConstantPackage obj);

    void visitConstantUtf8(ConstantUtf8 obj);

    void visitConstantValue(ConstantValue obj);

    void visitDeprecated(Deprecated obj);

    void visitExceptionTable(ExceptionTable obj);

    void visitField(Field obj);

    void visitInnerClass(InnerClass obj);

    void visitInnerClasses(InnerClasses obj);

    void visitJavaClass(JavaClass obj);

    void visitLineNumber(LineNumber obj);

    void visitLineNumberTable(LineNumberTable obj);

    void visitLocalVariable(LocalVariable obj);

    void visitLocalVariableTable(LocalVariableTable obj);

    void visitMethod(Method obj);

    void visitSignature(Signature obj);

    void visitSourceFile(SourceFile obj);

    void visitSynthetic(Synthetic obj);

    void visitBootstrapMethods(BootstrapMethods obj);

    void visitUnknown(Unknown obj);

    void visitStackMap(StackMap obj);

    void visitStackMapEntry(StackMapEntry obj);

    void visitEnclosingMethod(EnclosingMethod obj);

    void visitRuntimeVisibleAnnotations(RuntimeVisAnnos obj);

    void visitRuntimeInvisibleAnnotations(RuntimeInvisAnnos obj);

    void visitRuntimeVisibleParameterAnnotations(RuntimeVisParamAnnos obj);

    void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisParamAnnos obj);

    void visitRuntimeVisibleTypeAnnotations(RuntimeVisTypeAnnos obj);

    void visitRuntimeInvisibleTypeAnnotations(RuntimeInvisTypeAnnos obj);

    void visitAnnotationDefault(AnnotationDefault obj);

    void visitLocalVariableTypeTable(LocalVariableTypeTable obj);

    void visitMethodParameters(MethodParameters methodParameters);

    void visitModule(Module module);

    void visitModulePackages(ModulePackages modulePackage);

    void visitModuleMainClass(ModuleMainClass moduleMainClass);

    void visitNestHost(NestHost nestHost);

    void visitNestMembers(NestMembers nestMembers);
}
