package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ConstantCP extends Constant {

    protected int classIndex, nameAndTypeIndex;

    ConstantCP(byte tag, DataInputStream file) throws IOException {
        this(tag, file.readUnsignedShort(), file.readUnsignedShort());
    }

    protected ConstantCP(byte tag, int classIndex, int nameAndTypeIndex) {
        super(tag);
        this.classIndex = classIndex;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(classIndex);
        file.writeShort(nameAndTypeIndex);
    }

    public final int getClassIndex() {
        return classIndex;
    }

    public final int getNameAndTypeIndex() {
        return nameAndTypeIndex;
    }

    public String getClass(ConstantPool cp) {
        return cp.constantToString(classIndex, Constants.CONSTANT_Class);
    }

    @Override
    public final String toString() {
        return super.toString() + "(classIndex = " + classIndex + ", nameAndTypeIndex = " + nameAndTypeIndex + ")";
    }
}
