package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantClass extends Constant {

    private int nameIndex;

    ConstantClass(DataInputStream file) throws IOException {
        super(Constants.CONSTANT_Class);
        this.nameIndex = file.readUnsignedShort();
    }

    public ConstantClass(int nameIndex) {
        super(Constants.CONSTANT_Class);
        this.nameIndex = nameIndex;
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantClass(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(nameIndex);
    }

    public final int getNameIndex() {
        return nameIndex;
    }

    @Override
    public Integer getValue() {
        return nameIndex;
    }

    public String getClassname(ConstantPool cpool) {
        return cpool.getConstantUtf8(nameIndex).getValue();
    }

    @Override
    public final String toString() {
        return super.toString() + "(name_index = " + nameIndex + ")";
    }
}
