package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantDouble extends Constant implements SimpleConstant {

    private double value;

    public ConstantDouble(double value) {
        super(Constants.CONSTANT_Double);
        this.value = value;
    }

    ConstantDouble(DataInputStream file) throws IOException {
        this(file.readDouble());
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantDouble(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeDouble(value);
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + value + ")";
    }

    @Override
    public Double getValue() {
        return value;
    }

    public String getStringValue() {
        return Double.toString(value);
    }
}
