package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantDynamic extends Constant {

    private final int bootstrapMethodAttrIndex;

    private final int nameAndTypeIndex;

    ConstantDynamic(DataInputStream file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public ConstantDynamic(int readUnsignedShort, int nameAndTypeIndex) {
        super(Constants.CONSTANT_Dynamic);
        this.bootstrapMethodAttrIndex = readUnsignedShort;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(bootstrapMethodAttrIndex);
        file.writeShort(nameAndTypeIndex);
    }

    public final int getNameAndTypeIndex() {
        return nameAndTypeIndex;
    }

    public final int getBootstrapMethodAttrIndex() {
        return bootstrapMethodAttrIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bootstrapMethodAttrIndex=" + bootstrapMethodAttrIndex + ",nameAndTypeIndex=" + nameAndTypeIndex + ")";
    }

    @Override
    public String getValue() {
        return toString();
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantDynamic(this);
    }
}
