package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.IOException;

public final class ConstantFieldref extends ConstantCP {

    ConstantFieldref(DataInputStream file) throws IOException {
        super(Constants.CONSTANT_Fieldref, file);
    }

    public ConstantFieldref(int class_index, int name_and_type_index) {
        super(Constants.CONSTANT_Fieldref, class_index, name_and_type_index);
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantFieldref(this);
    }

    @Override
    public String getValue() {
        return toString();
    }
}
