package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantFloat extends Constant implements SimpleConstant {

    private float floatValue;

    public ConstantFloat(float floatValue) {
        super(Constants.CONSTANT_Float);
        this.floatValue = floatValue;
    }

    ConstantFloat(DataInputStream file) throws IOException {
        this(file.readFloat());
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantFloat(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeFloat(floatValue);
    }

    @Override
    public final Float getValue() {
        return floatValue;
    }

    public final String getStringValue() {
        return Float.toString(floatValue);
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + floatValue + ")";
    }
}
